/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import oracle.cloud.paas.model.DatePropertyAdapter;

public class Helper {
    private static DateFormat dataFormat = null;
    private static DateFormat instanceLogDateFormat = null;

    public static void safeClose(Closeable in, Logger logger) {
        block3: {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.fillInStackTrace();
                    if (logger == null) break block3;
                    logger.log(Level.WARNING, "failed to close the stream.", ex);
                }
            }
        }
    }

    public static void safeClose(Closeable in, PrintWriter writer) {
        block3: {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    if (writer == null) break block3;
                    ex.printStackTrace(writer);
                }
            }
        }
    }

    public static void safeClose(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String getActiveJobIDKeyMessage() {
        return "active job ID = ";
    }

    public static String printDate(Date date) {
        return Helper.getDataFormat().format(date);
    }

    public static String printSILogFormatDate(Date date) {
        String odl = Helper.getInstanceLogDateFormat().format(date);
        int lngth = odl.length();
        odl = odl.substring(0, lngth - 2) + ":" + odl.substring(lngth - 2, lngth);
        return odl;
    }

    private static void writeStream(InputStream in, FileOutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        do {
            if ((n = in.read(buffer)) <= 0) continue;
            out.write(buffer, 0, n);
        } while (n > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File f, InputStream in, Logger logger) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            Helper.writeStream(in, out);
        }
        finally {
            Helper.safeClose((Closeable)out, logger);
            Helper.safeClose((Closeable)in, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File f, InputStream in) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            Helper.writeStream(in, out);
        }
        finally {
            Helper.safeClose(out);
            Helper.safeClose(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File f, InputStream in, PrintWriter writer) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            Helper.writeStream(in, out);
        }
        finally {
            Helper.safeClose((Closeable)out, writer);
            Helper.safeClose((Closeable)in, writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File outFile, File inFile, Logger logger) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFile);
            Helper.writeFile(outFile, (InputStream)in, logger);
        }
        finally {
            Helper.safeClose((Closeable)in, logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File outFile, File inFile, PrintWriter writer) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFile);
            Helper.writeFile(outFile, (InputStream)in, writer);
        }
        finally {
            Helper.safeClose((Closeable)in, writer);
        }
    }

    public static void writeFile(File outFile, File inFile) throws IOException {
        FileInputStream in = new FileInputStream(inFile);
        Helper.writeFile(outFile, in);
    }

    public static boolean isTimezoneIdValid(String timezoneId) {
        if (timezoneId == null) {
            return false;
        }
        TimeZone tz = TimeZone.getTimeZone(timezoneId);
        return !tz.getID().equals("GMT") || timezoneId.equals("GMT");
    }

    private static DateFormat getDataFormat() {
        if (dataFormat == null) {
            dataFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss z");
            if (DatePropertyAdapter.PRESENTATION_TIMEZONE != null) {
                dataFormat.setTimeZone(DatePropertyAdapter.PRESENTATION_TIMEZONE);
            }
        }
        return dataFormat;
    }

    private static DateFormat getInstanceLogDateFormat() {
        if (instanceLogDateFormat == null) {
            instanceLogDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            if (DatePropertyAdapter.PRESENTATION_TIMEZONE != null) {
                instanceLogDateFormat.setTimeZone(DatePropertyAdapter.PRESENTATION_TIMEZONE);
            }
        }
        return instanceLogDateFormat;
    }

    public static void resetDateFormats() {
        dataFormat = null;
        instanceLogDateFormat = null;
    }

    public static JMXConnector getJMXConnector(String hostname, String portString, String username, String password, String mserver, Long timeout) throws IOException {
        String protocol = "t3";
        Integer portInteger = Integer.valueOf(portString);
        int port = portInteger;
        String jndiroot = "/jndi/";
        JMXServiceURL serviceURL = new JMXServiceURL(protocol, hostname, port, jndiroot + mserver);
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("java.naming.security.principal", username);
        h.put("java.naming.security.credentials", password);
        h.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        h.put("jmx.remote.x.request.waiting.timeout", timeout);
        return JMXConnectorFactory.connect(serviceURL, h);
    }

    public static Throwable getCause(Throwable e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static String getCauseInfo(Throwable e) {
        Throwable cause = Helper.getCause(e);
        String msg = cause.getMessage();
        return msg == null ? cause.getClass().getName() : cause.getClass().getName() + ": " + msg;
    }

    public static String getVersionedLibraryName(String libName, String specVersion, String implVersion) {
        if (specVersion == null && implVersion == null) {
            return libName;
        }
        StringBuffer versionedName = new StringBuffer(libName);
        versionedName.append("(");
        if (specVersion != null && !specVersion.trim().isEmpty()) {
            versionedName.append(specVersion);
        }
        if (implVersion != null && !implVersion.trim().isEmpty()) {
            versionedName.append(",");
            versionedName.append(implVersion);
        }
        versionedName.append(")");
        return versionedName.toString();
    }

    public static String[] getLibraryNameVersions(String libName) {
        String implVersion;
        if (libName.indexOf("(") == -1 && libName.indexOf(")") == -1) {
            return new String[]{libName, null, null};
        }
        String name = libName.substring(0, libName.indexOf("("));
        String versions = libName.substring(libName.indexOf("(") + 1, libName.indexOf(")")).trim();
        if (versions.isEmpty()) {
            return new String[]{name, null, null};
        }
        if (versions.indexOf(",") == -1) {
            return new String[]{name, versions, null};
        }
        String specVersion = versions.substring(0, versions.indexOf(",")).trim();
        if (specVersion.isEmpty()) {
            specVersion = null;
        }
        if ((implVersion = versions.substring(versions.indexOf(",") + 1, versions.length()).trim()).isEmpty()) {
            implVersion = null;
        }
        return new String[]{name, specVersion, implVersion};
    }

    public static String getLibraryRegisteredName(String libName) {
        String implVersion;
        if (libName.indexOf("(") == -1 && libName.indexOf(")") == -1) {
            return libName;
        }
        String name = libName.substring(0, libName.indexOf("("));
        String versions = libName.substring(libName.indexOf("(") + 1, libName.indexOf(")")).trim();
        if (versions.isEmpty()) {
            return name;
        }
        if (versions.indexOf(",") == -1) {
            name = name + "#" + versions;
            return name;
        }
        String specVersion = versions.substring(0, versions.indexOf(",")).trim();
        if (!specVersion.isEmpty()) {
            name = name + "#" + specVersion;
        }
        if (!(implVersion = versions.substring(versions.indexOf(",") + 1, versions.length()).trim()).isEmpty()) {
            name = name + "@" + implVersion;
        }
        return name;
    }
}

