/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.api;

import java.util.HashMap;
import java.util.Map;
import oracle.cloud.paas.api.JobQuery;
import oracle.cloud.paas.model.JobStatus;

public class JobQueryBuilder {
    private JobQueryImpl query = new JobQueryImpl();

    private JobQueryBuilder() {
    }

    public static JobQueryBuilder createBuilder() {
        return new JobQueryBuilder();
    }

    public JobQuery build() {
        JobQueryImpl result = this.query;
        this.query = null;
        return result;
    }

    public JobQueryBuilder identityDomain(String domain) {
        this.query.filter.put("domain", domain);
        return this;
    }

    public JobQueryBuilder service(String service) {
        this.query.filter.put("service", service);
        return this;
    }

    public JobQueryBuilder application(String application) {
        String apps = (String)this.query.filter.get("application");
        apps = apps == null ? application : apps + "," + application;
        this.query.filter.put("application", apps);
        return this;
    }

    public JobQueryBuilder library(String library) {
        this.query.filter.put("library", library);
        return this;
    }

    public JobQueryBuilder type(String type) {
        this.query.filter.put("type", type);
        return this;
    }

    public JobQueryBuilder status(JobStatus status) {
        String statuses = (String)this.query.filter.get("status");
        statuses = statuses == null ? status.toString() : statuses + "," + status.toString();
        this.query.filter.put("status", statuses);
        return this;
    }

    public JobQueryBuilder limit(int limit) {
        this.query.filter.put("limit", String.valueOf(limit));
        return this;
    }

    public JobQueryBuilder newCriteria(String name, String value) {
        this.query.filter.put(name, value);
        return this;
    }

    private static class JobQueryImpl
    implements JobQuery {
        private Map<String, String> filter = new HashMap<String, String>();

        private JobQueryImpl() {
        }

        @Override
        public Map<String, String> getFilter() {
            return this.filter;
        }
    }
}

