/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloud.paas.api;

import java.net.URL;
import java.util.ServiceLoader;
import oracle.cloud.paas.api.ApplicationManager;
import oracle.cloud.paas.spi.ApplicationManagerServiceProvider;

public class ApplicationManagerConnectionFactory {
    public static ApplicationManager createServiceEndpoint(URL url, String user, String password) {
        return ApplicationManagerConnectionFactory.createServiceEndpoint(url, null, user, password);
    }

    public static ApplicationManager createServiceEndpoint(URL url, String identityDomain, String user, String password) {
        return ApplicationManagerConnectionFactory.createServiceEndpoint("cloud", url, identityDomain, user, password);
    }

    public static ApplicationManager createServiceEndpoint(String provider, URL url, String user, String password) {
        return ApplicationManagerConnectionFactory.createServiceEndpoint(provider, url, null, user, password);
    }

    public static ApplicationManager createServiceEndpoint(String provider, URL url, String identityDomain, String user, String password) {
        ServiceLoader<ApplicationManagerServiceProvider> loader = ServiceLoader.load(ApplicationManagerServiceProvider.class);
        for (ApplicationManagerServiceProvider impl : loader) {
            if (!impl.getName().equals(provider)) continue;
            return impl.createApplicationManagerConnection(url, identityDomain, user, password);
        }
        return null;
    }
}

