/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.webtier.jsp.variables.EclipseExpressionUtil;
import oracle.eclipse.tools.webtier.jsp.variables.EclipseJavaTypeRetriever;
import oracle.eclipse.tools.webtier.jsp.variables.EclipseTypeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class JDTCodeVarAnalyzer {
    public List getVarDefinitions(String source) {
        StringBuffer buffer = new StringBuffer("class __m7inner { public void __m7_internal_method() {");
        int sourceOffset = buffer.length();
        buffer.append(source).append(";}}");
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(buffer.toString().toCharArray());
        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
        VarDeclVisitor visitor = new VarDeclVisitor(sourceOffset);
        compilationUnit.accept((ASTVisitor)visitor);
        return visitor.getVarDefs();
    }

    public Set<String> getReturnStringLiterals(IMethod method, IProject project) {
        final EclipseJavaTypeRetriever jtr = new EclipseJavaTypeRetriever(method.getDeclaringType().getFullyQualifiedName(), project);
        MethodDeclaration md = EclipseTypeUtil.findMethodDeclaration((ASTNode)jtr.getCompilationUnitNode(), method.getElementName());
        if (md == null) {
            return Collections.emptySet();
        }
        final HashSet found = new HashSet();
        final HashSet<String> result = new HashSet<String>();
        md.getBody().accept(new ASTVisitor(){

            public boolean visit(ReturnStatement rs) {
                Expression re = rs.getExpression();
                Object exprObj = EclipseExpressionUtil.getExpressionConstant(re, jtr.getJavaType(), jtr.getJavaProject());
                if (exprObj instanceof String) {
                    result.add((String)exprObj);
                    found.add(exprObj);
                }
                return true;
            }
        });
        return result;
    }

    private static class VarDeclVisitor
    extends ASTVisitor {
        private List<VarDefinition> mVarDefs;
        private int mSourceOffset;

        public VarDeclVisitor(int offset) {
            this.mSourceOffset = offset;
            this.mVarDefs = new ArrayList<VarDefinition>();
        }

        public List<VarDefinition> getVarDefs() {
            return this.mVarDefs;
        }

        public boolean visit(VariableDeclarationStatement node) {
            if (this.isTopLevel((ASTNode)node)) {
                this.commonVisit(node.getType(), node.fragments());
            }
            return true;
        }

        private boolean isTopLevel(ASTNode node) {
            ASTNode parent = node.getParent().getParent();
            return parent instanceof MethodDeclaration && "__m7_internal_method".equals(((MethodDeclaration)parent).getName().getIdentifier());
        }

        private void commonVisit(Type type, List fragments) {
            String typeName = type.toString();
            int count = fragments.size();
            int i = 0;
            while (i < count) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                String identifier = fragment.getName().getIdentifier();
                int offset = fragment.getStartPosition() - this.mSourceOffset;
                int len = fragment.getLength();
                this.mVarDefs.add(new VarDefinition(identifier, typeName, offset, len));
                ++i;
            }
        }
    }

    public static final class VarDefinition {
        private final String mType;
        private final String mName;
        private final int mOffset;
        private final int mLen;

        public String getType() {
            return this.mType;
        }

        public String getName() {
            return this.mName;
        }

        public int getOffset() {
            return this.mOffset;
        }

        public int getmLen() {
            return this.mLen;
        }

        public VarDefinition(String name, String type, int offset, int len) {
            assert (name != null);
            assert (type != null);
            this.mName = name;
            this.mType = type;
            this.mOffset = offset;
            this.mLen = len;
        }

        public String toString() {
            return String.valueOf(this.mName) + " (" + this.mType + ")";
        }
    }
}

