/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.variables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.services.util.StringUtil;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;

public class EclipseExpressionUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getExpressionConstant(Expression expr, IType type, IJavaProject javaProject) {
        if (expr instanceof ParenthesizedExpression) {
            expr = ((ParenthesizedExpression)expr).getExpression();
        }
        Object constant = null;
        if (expr instanceof StringLiteral) {
            return ((StringLiteral)expr).getLiteralValue();
        }
        if (expr instanceof NumberLiteral) {
            String numStr = ((NumberLiteral)expr).getToken();
            try {
                return Integer.parseInt(numStr);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (expr instanceof BooleanLiteral) {
            return ((BooleanLiteral)expr).booleanValue();
        }
        if (expr instanceof CharacterLiteral) {
            return Character.valueOf(((CharacterLiteral)expr).charValue());
        }
        if (expr instanceof NullLiteral) {
            return null;
        }
        if (expr instanceof TypeLiteral) {
            Type tl = ((TypeLiteral)expr).getType();
            return tl.resolveBinding().getQualifiedName();
        }
        if (expr instanceof SimpleName || expr instanceof QualifiedName) {
            try {
                IType realType = null;
                String identifier = null;
                if (expr instanceof SimpleName) {
                    realType = type;
                    identifier = ((SimpleName)expr).getIdentifier();
                } else {
                    ITypeBinding tb = ((QualifiedName)expr).getQualifier().resolveTypeBinding();
                    if (tb == null) {
                        return null;
                    }
                    realType = javaProject.findType(tb.getQualifiedName());
                    identifier = ((QualifiedName)expr).getName().getIdentifier();
                }
                if (realType == null) return constant;
                if (identifier == null) return constant;
                if (realType.isEnum()) {
                    return String.valueOf(realType.getFullyQualifiedName()) + '.' + identifier;
                }
                IField field = realType.getField(identifier);
                if (field == null) return constant;
                constant = field.getConstant();
                if (!(constant instanceof String)) return constant;
                return StringUtil.unquote((String)((String)constant));
            }
            catch (JavaModelException javaModelException) {
                return constant;
            }
        }
        if (!(expr instanceof ArrayInitializer)) return constant;
        List exprs = ((ArrayInitializer)expr).expressions();
        ArrayList<Object> constExprs = new ArrayList<Object>(exprs.size());
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Object constExpr = EclipseExpressionUtil.getExpressionConstant((Expression)iter.next(), type, javaProject);
            if (constExpr == null) {
                return null;
            }
            constExprs.add(constExpr);
        }
        return constExprs;
    }
}

