/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.variables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ImplicitVariable;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.webtier.jsp.variables.JSPImplicitScopeVariable;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;

public class DefaultImplicitImmediateVariableProvider {
    private static DefaultImplicitImmediateVariableProvider INSTANCE;
    private static final String PAGE_CONTEXT_STRING_FULLY_QUALIFIED_CLASS = "javax.servlet.jsp.PageContext";
    private static final String APPLICATION_SCOPE = "applicationScope";
    private static final String SESSION_SCOPE = "sessionScope";
    private static final String REQUEST_SCOPE = "requestScope";
    private static final String PAGE_SCOPE = "pageScope";
    private static final String COOKIE_IMPLICIT_OBJ = "cookie";
    private static final String HEADER_IMPLICIT_OBJ = "header";
    private static final String HEADER_VALUES_IMPLICIT_OBJ = "headerValues";
    private static final String INIT_PARAM_IMPLICIT_OBJ = "initParam";
    private static final String PARAM_IMPLICIT_OBJ = "param";
    private static final String PARAM_VALUES_IMPLICIT_OBJ = "paramValues";
    private static final String PAGE_CONTEXT_IMPLICIT_OBJ = "pageContext";

    public static synchronized DefaultImplicitImmediateVariableProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultImplicitImmediateVariableProvider();
        }
        return INSTANCE;
    }

    protected DefaultImplicitImmediateVariableProvider() {
    }

    public List<Variable> getSymbols(IFile file, Project project, IDatatypeProvider provider) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        variables.addAll(this.getRequestScopeSymbols(file, project, provider).values());
        variables.addAll(this.getSessionScopeSymbols(file, project).values());
        variables.addAll(this.getApplicationScopeSymbols(file, project, provider).values());
        variables.addAll(this.getPageScopeSymbols(file, project, provider).values());
        return variables;
    }

    private Map<String, Variable> getRequestScopeSymbols(IFile file, Project project, IDatatypeProvider dataTypeProvider) {
        HashMap<String, Variable> requestSymbols = new HashMap<String, Variable>();
        Variable symbol = this.createScopeSymbol(file, Variable.SCOPE.REQUEST_SCOPE, REQUEST_SCOPE, project);
        requestSymbols.put(symbol.getName(), symbol);
        requestSymbols.put(COOKIE_IMPLICIT_OBJ, this.createUnknownImplicitVariable(dataTypeProvider, "java.util.Map", COOKIE_IMPLICIT_OBJ, Variable.SCOPE.REQUEST_SCOPE));
        requestSymbols.put(HEADER_IMPLICIT_OBJ, this.createUnknownImplicitVariable(dataTypeProvider, "java.util.Map", HEADER_IMPLICIT_OBJ, Variable.SCOPE.REQUEST_SCOPE));
        requestSymbols.put(HEADER_VALUES_IMPLICIT_OBJ, this.createUnknownImplicitVariable(dataTypeProvider, "java.util.Map", HEADER_VALUES_IMPLICIT_OBJ, Variable.SCOPE.REQUEST_SCOPE));
        requestSymbols.put(PARAM_IMPLICIT_OBJ, this.createUnknownImplicitVariable(dataTypeProvider, "java.util.Map", PARAM_IMPLICIT_OBJ, Variable.SCOPE.REQUEST_SCOPE));
        requestSymbols.put(PARAM_VALUES_IMPLICIT_OBJ, this.createUnknownImplicitVariable(dataTypeProvider, "java.util.Map", PARAM_VALUES_IMPLICIT_OBJ, Variable.SCOPE.REQUEST_SCOPE));
        return Collections.unmodifiableMap(requestSymbols);
    }

    private Map<String, Variable> getSessionScopeSymbols(IFile file, Project project) {
        Variable symbol = this.createScopeSymbol(file, Variable.SCOPE.SESSION_SCOPE, SESSION_SCOPE, project);
        return Collections.unmodifiableMap(Collections.singletonMap(symbol.getName(), symbol));
    }

    private Map<String, Variable> getApplicationScopeSymbols(IFile file, Project project, IDatatypeProvider dataTypeProvider) {
        HashMap<String, Variable> symbols = new HashMap<String, Variable>();
        symbols.put(INIT_PARAM_IMPLICIT_OBJ, this.createUnknownImplicitVariable(dataTypeProvider, "java.util.Map", INIT_PARAM_IMPLICIT_OBJ, Variable.SCOPE.REQUEST_SCOPE));
        Variable symbol = this.createScopeSymbol(file, Variable.SCOPE.APPLICATION_SCOPE, APPLICATION_SCOPE, project);
        symbols.put(symbol.getName(), symbol);
        return Collections.unmodifiableMap(symbols);
    }

    private Map<String, Variable> getPageScopeSymbols(IFile file, Project project, IDatatypeProvider dataTypeProvider) {
        HashMap<String, Object> symbols = new HashMap<String, Object>();
        ImplicitVariable variable = new ImplicitVariable(PAGE_CONTEXT_IMPLICIT_OBJ, dataTypeProvider.getDataType(PAGE_CONTEXT_STRING_FULLY_QUALIFIED_CLASS, null), Variable.SCOPE.PAGE_SCOPE, ResolutionTime.PAGE_COMPILE);
        symbols.put(variable.getName(), variable);
        Variable symbol = this.createScopeSymbol(file, Variable.SCOPE.PAGE_SCOPE, PAGE_SCOPE, project);
        symbols.put(symbol.getName(), symbol);
        return Collections.unmodifiableMap(symbols);
    }

    private Variable createScopeSymbol(IFile file, Variable.SCOPE scope, String name, Project project) {
        HashMap mapSource = new HashMap();
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setMapSource(mapSource);
        typeDesc.setImmutable(false);
        return new JSPImplicitScopeVariable(name, (IMapTypeDescriptor)typeDesc, project, scope);
    }

    private Variable createUnknownImplicitVariable(IDatatypeProvider dataTypeProvider, String varType, String varName, Variable.SCOPE scope) {
        DataType dt = dataTypeProvider.getDataType(varType, null);
        return new ImplicitVariable(varName, dt, scope, ResolutionTime.PAGE_COMPILE);
    }
}

