/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.webtier.jsp.Activator;
import oracle.eclipse.tools.webtier.jsp.validation.OepeValidationContext;
import oracle.eclipse.tools.webtier.jsp.validation.OepeViewAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.dom.AttrDOMAdapter;
import org.eclipse.jst.jsf.common.dom.AttributeIdentifier;
import org.eclipse.jst.jsf.common.dom.DOMAdapter;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.common.internal.types.TypeComparator;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorDiagnosticFactory;
import org.eclipse.jst.jsf.common.internal.types.TypeComparatorPreferences;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.region.Region2AttrAdapter;
import org.eclipse.jst.jsf.core.internal.region.Region2ElementAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidationMessage;
import org.eclipse.jst.jsf.validation.internal.AbstractXMLViewValidationStrategy;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

final class AttributeValidatingStrategy
extends AbstractXMLViewValidationStrategy {
    static final boolean DEBUG;
    public static final String ID = "org.eclipse.jst.jsf.validation.strategy.AttributeValidatingStrategy";
    private static final String DISPLAY_NAME = "Attribute Validator";
    private final OepeValidationContext _validationContext;
    private final TypeComparator _typeComparator;

    static {
        String value = Platform.getDebugOption((String)"oracle.eclipse.tools.webtier.jsp/debug/jspsemanticsvalidator");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public AttributeValidatingStrategy(OepeValidationContext validationContext) {
        super(ID, DISPLAY_NAME);
        this._validationContext = validationContext;
        this._typeComparator = new TypeComparator(new TypeComparatorDiagnosticFactory(new TypeComparatorPreferences()));
    }

    public boolean isInteresting(DOMAdapter domAdapter) {
        return domAdapter instanceof AttrDOMAdapter;
    }

    public void validate(DOMAdapter domAdapter) {
        if (domAdapter instanceof AttrDOMAdapter) {
            long curTime = System.nanoTime();
            Region2AttrAdapter attrAdapter = (Region2AttrAdapter)domAdapter;
            if (attrAdapter.getAttributeValueRegion() != null) {
                IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(attrAdapter.getDocumentContext().getStructuredDocument(), attrAdapter.getOwningElement().getDocumentContext().getDocumentPosition() + attrAdapter.getAttributeValueRegion().getStart());
                this.validateAttributeValue(context, attrAdapter);
            }
            if (DEBUG) {
                System.out.println(String.format("Validation for attribute: %s took %d", domAdapter.toString(), System.nanoTime() - curTime));
            }
        }
    }

    private void validateAttributeValue(final IStructuredDocumentContext context, final Region2AttrAdapter attrAdapter) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)exception, (String)String.format("Error validating attribute: %s on element %s", attrAdapter.getNodeName(), attrAdapter.getOwningElement().getNodeName()));
            }

            public void run() throws Exception {
                Region2ElementAdapter elementAdapter = attrAdapter.getOwningElement();
                if (!AttributeValidatingStrategy.this.checkIfELAndValidate(elementAdapter, attrAdapter, context)) {
                    AttributeValidatingStrategy.this.validateNonELAttributeValue(context, attrAdapter);
                }
            }
        });
    }

    private boolean checkIfELAndValidate(Region2ElementAdapter elementAdapter, Region2AttrAdapter attrAdapter, IStructuredDocumentContext context) {
        int offsetOfFirstEL = -1;
        String attrValue = attrAdapter.getValue();
        offsetOfFirstEL = attrValue.indexOf(36);
        offsetOfFirstEL = offsetOfFirstEL != -1 && offsetOfFirstEL < attrValue.length() - 1 && attrValue.charAt(offsetOfFirstEL + 1) == '{' ? (offsetOfFirstEL += 2) : -1;
        OepeViewAdapter adapter = new OepeViewAdapter();
        boolean isEL = false;
        if (adapter != null && offsetOfFirstEL != -1) {
            try {
                IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), context.getDocumentPosition() + offsetOfFirstEL + 1);
                XMLViewDefnAdapter.DTELExpression elExpression = adapter.getELExpression((IModelContext)elContext);
                if (elExpression != null) {
                    String elText = elExpression.getText();
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(3)) + "EL attrVal= " + elText);
                    }
                    elContext = elExpression.getDocumentContext();
                    if (this._validationContext.shouldValidateEL()) {
                        if ("".equals(elText.trim())) {
                            int offset = elContext.getDocumentPosition() - 1;
                            int length = elText.length() + 2;
                            Diagnostic diagnostic = this._validationContext.getDiagnosticFactory().create_EMPTY_EL_EXPRESSION();
                            if (this._validationContext.shouldValidateEL()) {
                                this._validationContext.getReporter().report(diagnostic, offset, length);
                            }
                        } else {
                            List elVals = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidELValues.class, elContext, attrAdapter.getAttributeIdentifier());
                            String safeELText = elText.replaceAll("[\n\r\t]", " ");
                            this.validateELExpression(context, elContext, elVals, elementAdapter, attrAdapter, safeELText);
                            isEL = true;
                        }
                    }
                }
            }
            catch (IDTViewHandler.ViewHandlerException viewHandlerException) {}
        }
        boolean isEL2 = this.checkIfELAndValidate2(attrAdapter, context);
        return isEL || isEL2;
    }

    private boolean checkIfELAndValidate2(Region2AttrAdapter attrAdapter, IStructuredDocumentContext sDocContext) {
        ITextRegionList regionList;
        ITextRegionCollection parentRegion;
        ITextRegion attrValueRegion = attrAdapter.getAttributeValueRegion();
        if (attrValueRegion instanceof ITextRegionCollection && (parentRegion = (ITextRegionCollection)attrValueRegion).getType() == "XML_TAG_ATTRIBUTE_VALUE" && (regionList = parentRegion.getRegions()).size() >= 3) {
            ITextRegion openQuote = regionList.get(0);
            ITextRegion vblOpen = regionList.get(1);
            if ((openQuote.getType() == "XML_TAG_ATTRIBUTE_VALUE_DQUOTE" || openQuote.getType() == "JSP_VBL_DQUOTE" || openQuote.getType() == "JSP_TAG_ATTRIBUTE_VALUE_DQUOTE") && vblOpen.getType() == "JSP_VBL_OPEN") {
                boolean foundClosingQuote = false;
                int i = 2;
                while (!foundClosingQuote && i < regionList.size()) {
                    ITextRegion searchRegion = regionList.get(i);
                    if (searchRegion.getType() == "JSP_VBL_CLOSE") {
                        foundClosingQuote = true;
                    }
                    ++i;
                }
                if (!foundClosingQuote && this._validationContext.shouldValidateEL()) {
                    int offset = sDocContext.getDocumentPosition() + 1;
                    int length = parentRegion.getText().length();
                    Diagnostic diagnostic = this._validationContext.getDiagnosticFactory().create_MISSING_CLOSING_EXPR_BRACKET();
                    this._validationContext.getReporter().report(diagnostic, offset, length);
                }
                return true;
            }
        }
        return false;
    }

    private void validateELExpression(IStructuredDocumentContext context, IStructuredDocumentContext elContext, List elVals, Region2ElementAdapter elementAdapter, Region2AttrAdapter attrAdapter, String elText) {
        ELExpressionValidator elValidator = new ELExpressionValidator(elContext, elText, this._validationContext.getSymbolResolverFactory(), this._validationContext.getReporter());
        elValidator.validateXMLNode();
        CompositeType exprType = elValidator.getExpressionType();
        if (exprType != null) {
            for (IValidELValues elval : elVals) {
                String attributeVal = attrAdapter.getValue();
                Diagnostic status = null;
                try {
                    CompositeType expectedType = elval.getExpectedRuntimeType();
                    ArrayList<String> asList = new ArrayList<String>(Arrays.asList(expectedType.getSignatures()));
                    if (asList.contains("Ljava.lang.Object;")) {
                        asList.add("Ljava.lang.String;");
                        expectedType = new CompositeType(asList.toArray(new String[0]), expectedType.getAssignmentTypeMask());
                    }
                    if (expectedType == null || (status = this._typeComparator.calculateTypeCompatibility(expectedType, exprType)).getSeverity() == 0) continue;
                    this.reportValidationMessage(status, context, attributeVal);
                }
                catch (ELIsNotValidException e) {
                    this.reportValidationMessage(this.createValidationMessage(context, attributeVal, 2, e.getMessage(), this._validationContext.getFile()), context, attributeVal);
                }
            }
        }
    }

    private void validateNonELAttributeValue(IStructuredDocumentContext context, Region2AttrAdapter attrAdapter) {
        AttributeIdentifier attributeId;
        if (!this._validationContext.shouldValidateStaticValue()) {
            return;
        }
        String attributeValue = attrAdapter.getValue();
        if (DEBUG) {
            System.out.println(String.valueOf(this.addDebugSpacer(3)) + "attrVal= " + (attributeValue != null ? attributeValue : "null"));
        }
        if ((attributeId = attrAdapter.getAttributeIdentifier()).getTagIdentifier() == null || attributeId.getTagIdentifier().getTagName() == null || attributeId.getName() == null) {
            return;
        }
        List vv = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidValues.class, context, attributeId);
        if (!vv.isEmpty()) {
            for (IValidValues v : vv) {
                if (!v.isValidValue(attributeValue.trim())) {
                    if (DEBUG) {
                        System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NOT VALID ");
                    }
                    for (IValidationMessage msg : v.getValidationMessages()) {
                        this.reportValidationMessage(this.createValidationMessage(context, attributeValue, msg.getSeverity(), msg.getMessage(), this._validationContext.getFile()), context, attributeValue);
                    }
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println(String.valueOf(this.addDebugSpacer(5)) + "VALID ");
            }
        } else if (DEBUG) {
            System.out.println(String.valueOf(this.addDebugSpacer(4)) + "NO META DATA ");
        }
    }

    private void reportValidationMessage(Diagnostic problem, IStructuredDocumentContext context, String attributeValue) {
        int start = context.getDocumentPosition() + 1;
        int length = attributeValue.length();
        this._validationContext.getReporter().report(problem, start, length);
    }

    private Diagnostic createValidationMessage(IStructuredDocumentContext context, String attributeValue, int severity, String msg, IFile file) {
        BasicDiagnostic diagnostic = new BasicDiagnostic(severity, "", -1, msg, null);
        return diagnostic;
    }

    private String addDebugSpacer(int count) {
        StringBuffer ret = new StringBuffer("");
        int i = 0;
        while (i <= count) {
            ret.append("\t");
            ++i;
        }
        return ret.toString();
    }
}

