/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.tools;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.webtier.jsp.tools.BoundTLDEcoreAdvisor;
import oracle.eclipse.tools.webtier.jsp.tools.ExtendedEcoreFactory;
import oracle.eclipse.tools.webtier.jsp.tools.TLDEcoreAdvisor;
import oracle.eclipse.tools.xml.model.util.AbstractECoreUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MergeCommonAttributes
extends AbstractECoreUtil {
    private final Resource _res;
    private final EPackage _ePackage;
    private final List<String> _attrNames;

    public MergeCommonAttributes(URI uri, List<String> attrNames) throws IOException {
        ResourceSet resSet = this.createInitializedResourceSet();
        this._res = this.getNewResource(resSet, uri);
        if (this._res.getContents().isEmpty()) {
            throw new IllegalStateException("Could not find package");
        }
        this._ePackage = (EPackage)this._res.getContents().get(0);
        this._attrNames = attrNames;
    }

    protected final void generate() throws IOException {
        EClass newSuperClass = (EClass)this._ePackage.getEClassifier("NewSuperClass");
        if (newSuperClass == null) {
            newSuperClass = ExtendedEcoreFactory.INSTANCE.createEClass("NewSuperClass", true, true);
        }
        BoundTLDEcoreAdvisor advisor = new BoundTLDEcoreAdvisor();
        HashMap<String, List<TLDEcoreAdvisor.PossibleDuplicate>> foundAttrs = new HashMap<String, List<TLDEcoreAdvisor.PossibleDuplicate>>();
        for (String attrName : this._attrNames) {
            for (EClassifier eClassifier : this._ePackage.getEClassifiers()) {
                EClass eClass;
                EStructuralFeature feature;
                if (!(eClassifier instanceof EClass) || !((feature = (eClass = (EClass)eClassifier).getEStructuralFeature(attrName)) instanceof EAttribute)) continue;
                advisor.findOrAddToMap((EAttribute)feature, foundAttrs);
            }
        }
        HashSet classesThatHaveAll = new HashSet();
        classesThatHaveAll.addAll(EcoreUtil.getObjectsByType((Collection)this._ePackage.getEClassifiers(), (EClassifier)EcorePackage.Literals.ECLASS));
        for (Map.Entry entry : foundAttrs.entrySet()) {
            for (TLDEcoreAdvisor.PossibleDuplicate possDup : (List)entry.getValue()) {
                if (!possDup.isDuplicate()) continue;
                EAttribute newEAttr = (EAttribute)EcoreUtil.copy((EObject)possDup.getAttribute());
                newSuperClass.getEStructuralFeatures().add((Object)newEAttr);
                Iterator classIt = classesThatHaveAll.iterator();
                while (classIt.hasNext()) {
                    EClass eClass = (EClass)classIt.next();
                    if (possDup.getDuplicateClasses().contains(eClass) || possDup.getAttribute().getEContainingClass() == eClass) continue;
                    classIt.remove();
                }
            }
        }
        if (newSuperClass.eContainer() == null) {
            this._ePackage.getEClassifiers().add((Object)newSuperClass);
        }
        for (EClass superClassable : classesThatHaveAll) {
            for (String attrName : this._attrNames) {
                EStructuralFeature eAttr = newSuperClass.getEStructuralFeature(attrName);
                if (eAttr == null) {
                    throw new IllegalStateException("Could not find attribute: " + attrName);
                }
                superClassable.getEStructuralFeatures().remove((Object)superClassable.getEStructuralFeature(attrName));
                superClassable.getESuperTypes().add((Object)newSuperClass);
            }
        }
        this._res.save(Collections.emptyMap());
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block18: {
            if (args.length < 2) {
                MergeCommonAttributes.error(AbstractECoreUtil.CmdLineError.NOT_ENOUGH_ARGUMENTS, String.format("Usage: %s <ecore-file> attrName1 [attrName2, ...]\n", new Object[]{MergeCommonAttributes.class.getName()}));
            }
            fileName = args[0];
            inStream = null;
            try {
                uri = URI.createFileURI((String)fileName);
                attrNames = new String[args.length - 1];
                System.arraycopy(args, 1, attrNames, 0, args.length - 1);
                new MergeCommonAttributes(uri, Arrays.asList(attrNames)).generate();
            }
            catch (FileNotFoundException e) {
                MergeCommonAttributes.error(AbstractECoreUtil.CmdLineError.FILE_NOT_FOUND, e.getLocalizedMessage());
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException v0) {}
                }
                break block18;
            }
            catch (IOException e) {
                try {
                    MergeCommonAttributes.error(AbstractECoreUtil.CmdLineError.GENERAL_IO_FAILURE, e.getLocalizedMessage());
                    ** if (inStream == null) goto lbl-1000
                }
                catch (Throwable var5_7) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var5_7;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        inStream.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block18;
                }
            }
            if (inStream == null) break block18;
            try {
                inStream.close();
            }
            catch (IOException v3) {}
        }
        System.exit(0);
    }

    private static void error(AbstractECoreUtil.CmdLineError code, String message) {
        System.err.println(code.toString());
        if (message != null) {
            System.err.println(message);
        }
        System.exit(code.toReturnCode());
    }
}

