/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.technology;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.Activator;
import oracle.eclipse.tools.application.common.services.appservices.IAppLocalizer;
import oracle.eclipse.tools.application.common.services.appservices.IDatatypeProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentContentProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IDocumentLocalizationContext;
import oracle.eclipse.tools.application.common.services.documentservices.IImplicitVariableProvider;
import oracle.eclipse.tools.application.common.services.documentservices.IVersionProvider;
import oracle.eclipse.tools.application.common.services.documentservices.internal.IDocumentLocalizationContextWorkingCopy;
import oracle.eclipse.tools.application.common.services.metadata.IVersion;
import oracle.eclipse.tools.application.common.services.techextservices.EnumVarGenerator;
import oracle.eclipse.tools.application.common.services.techextservices.FieldsGenerator;
import oracle.eclipse.tools.application.common.services.variables.ArtificialVariable;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCache;
import oracle.eclipse.tools.application.common.services.variables.IFileVariablesCacheProvider;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.application.common.services.variables.VariablesController;
import oracle.eclipse.tools.common.services.dependency.model.internal.ITechnologyDiscoveryStore;
import oracle.eclipse.tools.common.services.dependency.structuredmodel.IStructuredXMLModelVisitor;
import oracle.eclipse.tools.common.services.document.AbstractDocumentService;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.HashingComparator;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.document.IDocumentService;
import oracle.eclipse.tools.common.services.document.IVisitableDocument;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.app.services.IAppService;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.project.technology.TechnologyDocumentServiceAdapterFactory;
import oracle.eclipse.tools.common.services.techextservices.IDocumentBinder;
import oracle.eclipse.tools.webtier.javawebapp.document.AbstractJavaAppDocumentLocalizationContext;
import oracle.eclipse.tools.webtier.javawebapp.document.LocalizationSerializer;
import oracle.eclipse.tools.webtier.jsp.document.JSPBinder;
import oracle.eclipse.tools.webtier.jsp.document.JSPExpressionFieldGenerator;
import oracle.eclipse.tools.webtier.jsp.document.JSPGetPropertyFieldGenerator;
import oracle.eclipse.tools.webtier.jsp.technology.JspAppLocalizer;
import oracle.eclipse.tools.webtier.jsp.variables.DefaultImplicitImmediateVariableProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class JSPTechnologyExtension
extends AbstractTechnologyExtension
implements ITechnologyDiscoveryStore {
    public static final String ID = "jsp";
    private final Set<String> _supportedURIs;
    private JspAppLocalizer _appLocalizer;

    public JSPTechnologyExtension(Project project, ITechnologyDescriptor techDescriptor) {
        super(project, techDescriptor);
        this._appLocalizer = new JspAppLocalizer(this.getTechExtDescriptor().getTechnologyIdentifier(), project);
        this._supportedURIs = this.initializeUris();
    }

    public void close() {
        this._appLocalizer.dispose();
        super.close();
    }

    private Set<String> initializeUris() {
        HashSet<String> uris = new HashSet<String>();
        uris.add("JSP");
        uris.add("http://java.sun.com/jsp/Page");
        return uris;
    }

    public <T extends IAppService> T getAppService(Class<T> serviceType) {
        if (serviceType == IAppLocalizer.class) {
            return (T)((Object)this._appLocalizer);
        }
        if (serviceType == ITechnologyDiscoveryStore.class) {
            return (T)((Object)this);
        }
        if (serviceType == oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class) {
            return (T)new oracle.eclipse.tools.application.common.services.appservices.IVersionProvider(){

                public IVersion getVersion(String nsId) {
                    if (JSPTechnologyExtension.this._supportedURIs.contains(nsId)) {
                        return JSPTechnologyExtension.this.getJSPVersion(JSPTechnologyExtension.this.getVersion());
                    }
                    return null;
                }
            };
        }
        return (T)super.getAppService(serviceType);
    }

    private IVersion getJSPVersion(String jspVersion) {
        return Activator.getDefault().getVersionFactory().getVersion(jspVersion);
    }

    public IDocumentService getDocumentService(Class<? extends IDocumentService> serviceType, IDocument forDocument) {
        if (IImplicitVariableProvider.class.equals(serviceType)) {
            return new ImplicitVariableProviderForJSP(forDocument);
        }
        if (IDocumentBinder.class.equals(serviceType) && forDocument.getDocumentType().equals("jsp.JSPDocument")) {
            return new JSPBinder(forDocument);
        }
        if (IDocumentContentProvider.class.equals(serviceType)) {
            return new DocumentContentProviderForJSP(forDocument);
        }
        if (IFileVariablesCacheProvider.class.equals(serviceType) && forDocument.getDocumentType().equals("jsp.JSPDocument")) {
            return new JSPFileVariablesCacheProvider(forDocument);
        }
        if (IVersionProvider.class.equals(serviceType)) {
            return new VersionProviderForJSP(forDocument);
        }
        return super.getDocumentService(serviceType, forDocument);
    }

    public IStatus load(int saveNumber) {
        LocalizationSerializer ls = new LocalizationSerializer(this.getProject().getEclipseProject(), (ITechnologyExtension)this);
        return ls.load(saveNumber);
    }

    public IStatus store(int saveNumber, int prevSaveNumber) {
        LocalizationSerializer ls = new LocalizationSerializer(this.getProject().getEclipseProject(), (ITechnologyExtension)this);
        return ls.store(this.getCachedAdapters(IDocumentLocalizationContext.class), saveNumber, prevSaveNumber);
    }

    protected TechnologyDocumentServiceAdapterFactory getServiceAdapterFactory() {
        return new TechnologyDocumentServiceAdapterFactory(){

            protected IDocumentService doCreateAdapter(Class<? extends IDocumentService> adapterType, IDocument document) {
                if (adapterType == IDocumentLocalizationContext.class || adapterType == IDocumentLocalizationContextWorkingCopy.class) {
                    return new JSPDocumentLocalizationContext(document, JSPTechnologyExtension.this.getTechExtDescriptor().getTechnologyIdentifier(), JSPTechnologyExtension.this.getAppService(IAppLocalizer.class));
                }
                return null;
            }

            public HashingComparator getHashingComparator(Class<? extends IDocumentService> adapterType) {
                return new HashingComparator(){

                    public boolean equals(Object obj, Object obj2) {
                        if (obj instanceof Class && obj2 instanceof Class && IDocumentLocalizationContext.class.isAssignableFrom((Class)obj) && IDocumentLocalizationContext.class.isAssignableFrom((Class)obj2)) {
                            return true;
                        }
                        return super.equals(obj, obj2);
                    }

                    public int hashCode(Class<?> adapterType) {
                        if (IDocumentLocalizationContext.class.isAssignableFrom(adapterType)) {
                            return IDocumentLocalizationContext.class.hashCode();
                        }
                        return super.hashCode(adapterType);
                    }
                };
            }
        };
    }

    private class DocumentContentProviderForJSP
    extends AbstractDocumentService
    implements IDocumentContentProvider {
        public DocumentContentProviderForJSP(IDocument doc) {
            super(doc);
        }

        public int getPriority() {
            return 2;
        }

        public List<EnumVarGenerator> getEnumVarGenerators(ValueReference valRef) {
            return Collections.emptyList();
        }

        public List<FieldsGenerator> getFieldGenerators(ValueReference valRef) {
            ArrayList<FieldsGenerator> ret = new ArrayList<FieldsGenerator>();
            FilePositionContext modelContext = new FilePositionContext(this.getDocument().getFile());
            if (valRef.getType((IModelContext)modelContext).getNumFields((IModelContext)modelContext) <= 1) {
                if (valRef.getVariable() instanceof ArtificialVariable) {
                    ret.add(new JSPGetPropertyFieldGenerator(this.getDocument()));
                } else {
                    ret.add(new JSPExpressionFieldGenerator(this.getDocument()));
                }
            }
            return ret;
        }
    }

    private static class ImplicitVariableProviderForJSP
    extends AbstractDocumentService
    implements IImplicitVariableProvider {
        public ImplicitVariableProviderForJSP(IDocument doc) {
            super(doc);
        }

        public List<Variable> getImplicitVariables() {
            return DefaultImplicitImmediateVariableProvider.getInstance().getSymbols(this.getDocument().getFile(), this.getProject(), (IDatatypeProvider)this.getProject().getAppService(IDatatypeProvider.class));
        }
    }

    public class JSPDocumentLocalizationContext
    extends AbstractJavaAppDocumentLocalizationContext {
        public JSPDocumentLocalizationContext(IDocument doc, ITechnologyExtensionIdentifier id, IAppLocalizer localizer) {
            super(doc, id, localizer);
        }

        public int compareTo(IDocumentLocalizationContext other) {
            if (JSPTechnologyExtension.ID.equals(other.getOwner().getId())) {
                return 0;
            }
            return this.useMeAfter();
        }
    }

    private static class JSPDocumentVersionVisitor
    implements IStructuredXMLModelVisitor {
        private String _version;

        private JSPDocumentVersionVisitor() {
        }

        public boolean visit(IDOMNode node) {
            return false;
        }

        public boolean visit(IDOMElement element) {
            return false;
        }

        public boolean visit(IDOMDocument document) {
            Element root = document.getDocumentElement();
            if (root.getTagName().equals("jsp:root")) {
                this._version = root.getAttribute("version");
                if (this._version != null && this._version.length() == 0) {
                    this._version = null;
                }
            }
            return false;
        }

        public boolean visit(IDOMAttr attribute) {
            return false;
        }

        public String getFoundVersion() {
            return this._version;
        }
    }

    private static class JSPFileVariablesCacheProvider
    implements IFileVariablesCacheProvider {
        private final IDocument document;

        public JSPFileVariablesCacheProvider(IDocument document) {
            this.document = document;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public IFileVariablesCache getCache(boolean useWorkingCopy) {
            return VariablesController.getInstance().getFileCache(this.document.getFile(), useWorkingCopy);
        }
    }

    private class VersionProviderForJSP
    implements IVersionProvider {
        private IDocument _doc;

        public VersionProviderForJSP(IDocument forDocument) {
            this._doc = forDocument;
        }

        public IDocument getDocument() {
            return this._doc;
        }

        public IVersion getVersion(String nsId) {
            if (JSPTechnologyExtension.this._supportedURIs.contains(nsId)) {
                IVisitableDocument doc = (IVisitableDocument)this._doc.getAdapter(IVisitableDocument.class);
                if (doc != null) {
                    JSPDocumentVersionVisitor visitor = new JSPDocumentVersionVisitor();
                    doc.accept((IStructuredXMLModelVisitor)visitor);
                    String version = visitor.getFoundVersion();
                    if (version != null) {
                        return JSPTechnologyExtension.this.getJSPVersion(version);
                    }
                }
                oracle.eclipse.tools.application.common.services.appservices.IVersionProvider vp = JSPTechnologyExtension.this.getAppService(oracle.eclipse.tools.application.common.services.appservices.IVersionProvider.class);
                return vp.getVersion(nsId);
            }
            return null;
        }
    }
}

