/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.tagsupport.mdtypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.application.common.services.documentservices.DOMUtil;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.jsp.tagsupport.mdtypes.Messages;
import oracle.eclipse.tools.xml.model.emfbinding.ExtendedEcoreUtil;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import oracle.eclipse.tools.xml.model.metadata.ossmd.util.EMFMDAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.metadataprocessors.AbstractRootTypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.features.IDefaultValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidationMessage;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class StaticJSPAttributeRuntimeType
extends AbstractRootTypeDescriptor
implements IValidValues,
IDefaultValue,
IPossibleValues {
    protected static final DOMUtil _domUtil = new DOMUtil();
    protected static final EMFMDAdapter _emfMdAdapter = new EMFMDAdapter();
    private final List<IValidationMessage> _messages = new ArrayList<IValidationMessage>();

    public List getValidationMessages() {
        return Collections.unmodifiableList(this._messages);
    }

    public boolean isValidValue(String value) {
        EStructuralFeature feature;
        INamespaceContext namespaceContext;
        this._messages.clear();
        AttributeDescriptor attrDesc = this.getAttributeDescriptor();
        if (attrDesc != null && (namespaceContext = this.getNamespaceContext()) != null && (feature = this.getStructuralFeature(attrDesc)) != null && feature.getEType() instanceof EDataType) {
            try {
                Object convertedValue = EcoreUtil.createFromString((EDataType)((EDataType)feature.getEType()), (String)value);
                Boolean delegatedValue = this.maybeDelegateIsValidValue(convertedValue, (EDataType)feature.getEType(), this._messages);
                if (delegatedValue != null) {
                    return delegatedValue;
                }
                Diagnostician diagnostician = new Diagnostician();
                Diagnostic diag = diagnostician.validate((EDataType)feature.getEType(), convertedValue);
                if (diag.getSeverity() != 0) {
                    if (diag.getChildren().size() > 0) {
                        for (Diagnostic child : diag.getChildren()) {
                            this._messages.add((IValidationMessage)new ValidationMessage(child.getMessage()));
                        }
                    } else {
                        this._messages.add((IValidationMessage)new ValidationMessage(diag.getMessage()));
                    }
                    return false;
                }
            }
            catch (Exception e) {
                ValidationMessage valMessage = e.getLocalizedMessage() != null ? new ValidationMessage(e.getLocalizedMessage()) : new ValidationMessage(String.valueOf(value) + Messages.StaticJSPAttributeRuntimeType_0);
                this._messages.add((IValidationMessage)valMessage);
                return false;
            }
        }
        return true;
    }

    private Boolean maybeDelegateIsValidValue(Object convertedValue, EDataType eDataType, List<IValidationMessage> messages) {
        ITypeDescriptor typeDelegate = _emfMdAdapter.getTypeDelegate(eDataType);
        if (typeDelegate != null) {
            List featureAdapters = typeDelegate.getFeatureAdapters(IPossibleValues.class);
            Boolean isValid = Boolean.TRUE;
            for (IMetaDataEnabledFeature feature : featureAdapters) {
                feature.setMetaDataContext(this.getMetaDataContext());
                feature.setStructuredDocumentContext(this.getStructuredDocumentContext());
                if (!(feature instanceof IValidValues) || ((IValidValues)feature).isValidValue(convertedValue.toString())) continue;
                messages.addAll(((IValidValues)feature).getValidationMessages());
                isValid = Boolean.FALSE;
            }
            return isValid;
        }
        return null;
    }

    protected final INamespaceContext getNamespaceContext() {
        INamespaceContextFactory adapter;
        IDocument document;
        org.eclipse.jface.text.IDocument sdoc;
        IStructuredDocumentContext structuredDocumentContext = this.getStructuredDocumentContext();
        if (structuredDocumentContext != null && (sdoc = structuredDocumentContext.getStructuredDocument()) instanceof IStructuredDocument && (document = _domUtil.getDocumentForStructuredDocument((IStructuredDocument)sdoc)) != null && (adapter = (INamespaceContextFactory)document.getAdapter(INamespaceContextFactory.class)) != null) {
            return adapter.getNamespaceContext(document.getFile());
        }
        return null;
    }

    public String getDefaultValue() {
        Object defaultValue;
        EStructuralFeature feature;
        AttributeDescriptor attrDesc = this.getAttributeDescriptor();
        if (attrDesc != null && (feature = this.getStructuralFeature(attrDesc)) != null && (defaultValue = feature.getDefaultValue()) != null) {
            return EcoreUtil.convertToString((EDataType)((EDataType)feature.getEType()), (Object)defaultValue);
        }
        return null;
    }

    public List getPossibleValues() {
        EDataType eDataType;
        EStructuralFeature feature;
        INamespaceContext namespaceContext;
        ArrayList<IPossibleValue> possibleValues = new ArrayList<IPossibleValue>();
        AttributeDescriptor attrDesc = this.getAttributeDescriptor();
        if (attrDesc != null && (namespaceContext = this.getNamespaceContext()) != null && (feature = this.getStructuralFeature(attrDesc)) != null && feature.getEType() instanceof EDataType && (eDataType = (EDataType)feature.getEType()) != null) {
            if (this.maybeDelegatePossibleValues(eDataType, possibleValues)) {
                return possibleValues;
            }
            if (eDataType instanceof EEnum) {
                EEnum enumeration = (EEnum)eDataType;
                for (EEnumLiteral eLiteral : enumeration.getELiterals()) {
                    possibleValues.add((IPossibleValue)new PossibleValue(eLiteral.getLiteral()));
                }
            } else if (eDataType.isInstance((Object)Boolean.TRUE)) {
                possibleValues.add((IPossibleValue)new PossibleValue("true"));
                possibleValues.add((IPossibleValue)new PossibleValue("false"));
            }
        }
        return possibleValues;
    }

    private boolean maybeDelegatePossibleValues(EDataType eDataType, List<IPossibleValue> values) {
        ITypeDescriptor typeDelegate = _emfMdAdapter.getTypeDelegate(eDataType);
        if (typeDelegate != null) {
            List featureAdapters = typeDelegate.getFeatureAdapters(IPossibleValues.class);
            for (IMetaDataEnabledFeature feature : featureAdapters) {
                if (!(feature instanceof IPossibleValues)) continue;
                values.addAll(((IPossibleValues)feature).getPossibleValues());
            }
            return true;
        }
        return false;
    }

    protected final EStructuralFeature getStructuralFeature(AttributeDescriptor attrDesc) {
        EClass eClass = ExtendedEcoreUtil.INSTANCE.findEClassForElement(attrDesc.getTagName(), attrDesc.getUri());
        if (eClass != null) {
            return ExtendedMetaData.INSTANCE.getAttribute(eClass, null, attrDesc.getAttributeName());
        }
        return null;
    }

    protected final AttributeDescriptor getAttributeDescriptor() {
        Entity attrEntity = this.getMetaDataContext().getEntity();
        if (attrEntity != null) {
            String attrName = attrEntity.getId();
            EObject tagEntity = attrEntity.eContainer();
            if (tagEntity instanceof Entity && "tag".equals(((Entity)tagEntity).getType())) {
                String tagName = ((Entity)tagEntity).getId();
                EObject packageEntity = tagEntity.eContainer();
                if (packageEntity instanceof Model) {
                    String uri = ((Entity)packageEntity).getId();
                    return new AttributeDescriptor(uri, tagName, attrName);
                }
            }
        }
        return null;
    }

    protected final class AttributeDescriptor {
        private final String uri;
        private final String tagName;
        private final String attributeName;

        public AttributeDescriptor(String uri, String tagName, String attributeName) {
            this.uri = uri;
            this.tagName = tagName;
            this.attributeName = attributeName;
        }

        public final String getUri() {
            return this.uri;
        }

        public final String getTagName() {
            return this.tagName;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }
    }
}

