/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.model.jsptagbase.util;

import java.util.Currency;
import java.util.Map;
import oracle.eclipse.tools.webtier.jsp.Activator;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractFaceletsTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractJSPTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.DateTimePatternType;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.DynamicFaceletsTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.DynamicJSPTag;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.JSPDocumentRoot;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.JsptagbasePackage;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.LocaleType;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.Scope;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.UnknownJSPTag;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

public class JsptagbaseValidator
extends EObjectValidator {
    public static final JsptagbaseValidator INSTANCE = new JsptagbaseValidator();
    public static final String DIAGNOSTIC_SOURCE = "oracle.eclipse.tools.webtier.jsp.model.jsptagbase";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return JsptagbasePackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAbstractBaseTag((AbstractBaseTag)value, diagnostics, context);
            }
            case 1: {
                return this.validateAbstractFaceletsTag((AbstractFaceletsTag)value, diagnostics, context);
            }
            case 2: {
                return this.validateAbstractJSPTag((AbstractJSPTag)value, diagnostics, context);
            }
            case 3: {
                return this.validateDynamicFaceletsTag((DynamicFaceletsTag)value, diagnostics, context);
            }
            case 4: {
                return this.validateDynamicJSPTag((DynamicJSPTag)value, diagnostics, context);
            }
            case 5: {
                return this.validateJSPDocumentRoot((JSPDocumentRoot)value, diagnostics, context);
            }
            case 6: {
                return this.validateUnknownJSPTag((UnknownJSPTag)value, diagnostics, context);
            }
            case 7: {
                return this.validateDateTimePatternType((DateTimePatternType)((Object)value), diagnostics, context);
            }
            case 8: {
                return this.validateLocaleType((LocaleType)((Object)value), diagnostics, context);
            }
            case 9: {
                return this.validateScope((Scope)((Object)value), diagnostics, context);
            }
            case 10: {
                return this.validateISOCurrency((String)value, diagnostics, context);
            }
            case 11: {
                return this.validateJavaIdentifier((String)value, diagnostics, context);
            }
            case 12: {
                return this.validateOptionalDouble((String)value, diagnostics, context);
            }
            case 13: {
                return this.validateOptionalInteger((String)value, diagnostics, context);
            }
            case 14: {
                return this.validateOptionalLong((String)value, diagnostics, context);
            }
            case 15: {
                return this.validateScopeObject((Scope)((Object)value), diagnostics, context);
            }
            case 16: {
                return this.validateBooleanObjectPlusEL(value, diagnostics, context);
            }
            case 17: {
                return this.validateDateTimePatternUnionType(value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAbstractBaseTag(AbstractBaseTag abstractBaseTag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractBaseTag, diagnostics, context);
    }

    public boolean validateAbstractFaceletsTag(AbstractFaceletsTag abstractFaceletsTag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractFaceletsTag, diagnostics, context);
    }

    public boolean validateJSPDocumentRoot(JSPDocumentRoot jspDocumentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(jspDocumentRoot, diagnostics, context);
    }

    public boolean validateAbstractJSPTag(AbstractJSPTag abstractJSPTag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(abstractJSPTag, diagnostics, context);
    }

    public boolean validateDynamicFaceletsTag(DynamicFaceletsTag dynamicFaceletsTag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dynamicFaceletsTag, diagnostics, context);
    }

    public boolean validateDynamicJSPTag(DynamicJSPTag dynamicJSPTag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dynamicJSPTag, diagnostics, context);
    }

    public boolean validateUnknownJSPTag(UnknownJSPTag unknownJSPTag, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(unknownJSPTag, diagnostics, context);
    }

    public boolean validateDateTimePatternType(DateTimePatternType dateTimePatternType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateLocaleType(LocaleType localeType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateScope(Scope scope, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateOptionalInteger(String optionalInteger, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (optionalInteger == null || optionalInteger.length() == 0) {
            return true;
        }
        if (optionalInteger.contains("#{") || optionalInteger.contains("${")) {
            return true;
        }
        try {
            Integer.valueOf(optionalInteger);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_ValueIsNotAValidNumber", new Object[]{JsptagbaseValidator.getValueLabel((EDataType)JsptagbasePackage.Literals.OPTIONAL_INTEGER, (Object)optionalInteger, context), "integer"}, new Object[]{optionalInteger}, context));
            }
            return false;
        }
    }

    public boolean validateOptionalLong(String optionalLong, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateOptionalDouble(String optionalDouble, DiagnosticChain diagnostics, Map<Object, Object> context) {
        throw new UnsupportedOperationException();
    }

    public boolean validateScopeObject(Scope scopeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateBooleanObjectPlusEL(Object booleanObjectPlusEL, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateBooleanObjectPlusEL_MemberTypes(booleanObjectPlusEL, diagnostics, context);
        return result;
    }

    public boolean validateBooleanObjectPlusEL_MemberTypes(Object booleanObjectPlusEL, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (XMLTypePackage.Literals.BOOLEAN_OBJECT.isInstance(booleanObjectPlusEL) && this.xmlTypeValidator.validateBooleanObject((Boolean)booleanObjectPlusEL, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.STRING.isInstance(booleanObjectPlusEL) && this.xmlTypeValidator.validateString((String)booleanObjectPlusEL, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (XMLTypePackage.Literals.BOOLEAN_OBJECT.isInstance(booleanObjectPlusEL) && this.xmlTypeValidator.validateBooleanObject((Boolean)booleanObjectPlusEL, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.STRING.isInstance(booleanObjectPlusEL) && this.xmlTypeValidator.validateString((String)booleanObjectPlusEL, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateDateTimePatternUnionType(Object dateTimePatternUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateDateTimePatternUnionType_MemberTypes(dateTimePatternUnionType, diagnostics, context);
        return result;
    }

    public boolean validateDateTimePatternUnionType_MemberTypes(Object dateTimePatternUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (JsptagbasePackage.Literals.DATE_TIME_PATTERN_TYPE.isInstance(dateTimePatternUnionType) && this.validateDateTimePatternType((DateTimePatternType)((Object)dateTimePatternUnionType), (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else if (JsptagbasePackage.Literals.DATE_TIME_PATTERN_TYPE.isInstance(dateTimePatternUnionType) && this.validateDateTimePatternType((DateTimePatternType)((Object)dateTimePatternUnionType), null, context)) {
            return true;
        }
        return false;
    }

    public boolean validateISOCurrency(String isoCurrency, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateISOCurrency_MustBeISOCurrency(isoCurrency, diagnostics, context);
        return result;
    }

    public boolean validateISOCurrency_MustBeISOCurrency(String isoCurrency, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (isoCurrency == null) {
            return true;
        }
        try {
            Currency.getInstance(isoCurrency);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_ValueIsNotAValidISOCurrency", new Object[]{JsptagbaseValidator.getValueLabel((EDataType)JsptagbasePackage.Literals.ISO_CURRENCY, (Object)isoCurrency, context)}, new Object[]{isoCurrency}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateJavaIdentifier(String javaIdentifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateJavaIdentifier_MustBeJavaIdentifier(javaIdentifier, diagnostics, context);
        return result;
    }

    public boolean validateJavaIdentifier_MustBeJavaIdentifier(String javaIdentifier, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String message = null;
        int invalidCharNum = 0;
        char firstInvalidChar = ' ';
        if (javaIdentifier == null || javaIdentifier.trim().length() == 0) {
            message = "_UI_IdentifierMustNotBeEmpty";
        } else {
            char firstChar = javaIdentifier.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                message = "_UI_CharacterAtOffsetIsNotAValidJavaIdentifierPart";
                invalidCharNum = 1;
                firstInvalidChar = firstChar;
            } else {
                int i = 1;
                while (i < javaIdentifier.length()) {
                    char curChar = javaIdentifier.charAt(i);
                    if (!Character.isJavaIdentifierPart(curChar)) {
                        message = "_UI_CharacterAtOffsetIsNotAValidJavaIdentifierPart";
                        invalidCharNum = i + 1;
                        firstInvalidChar = curChar;
                    }
                    ++i;
                }
            }
        }
        if (message != null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, message, new Object[]{JsptagbaseValidator.getValueLabel((EDataType)JsptagbasePackage.Literals.JAVA_IDENTIFIER, (Object)javaIdentifier, context)}, new Object[]{javaIdentifier, Character.valueOf(firstInvalidChar), invalidCharNum}, context));
            }
            return false;
        }
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return Activator.getDefault().getResourceLocator();
    }
}

