/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.model.jsp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AlignType implements Enumerator
{
    TOP(0, "top", "top"),
    MIDDLE(1, "middle", "middle"),
    BOTTOM(2, "bottom", "bottom"),
    LEFT(3, "left", "left"),
    RIGHT(4, "right", "right");

    public static final int TOP_VALUE = 0;
    public static final int MIDDLE_VALUE = 1;
    public static final int BOTTOM_VALUE = 2;
    public static final int LEFT_VALUE = 3;
    public static final int RIGHT_VALUE = 4;
    private static final AlignType[] VALUES_ARRAY;
    public static final List<AlignType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AlignType[]{TOP, MIDDLE, BOTTOM, LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AlignType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignType get(int value) {
        switch (value) {
            case 0: {
                return TOP;
            }
            case 1: {
                return MIDDLE;
            }
            case 2: {
                return BOTTOM;
            }
            case 3: {
                return LEFT;
            }
            case 4: {
                return RIGHT;
            }
        }
        return null;
    }

    private AlignType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

