/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.document;

import oracle.eclipse.tools.application.common.services.documentservices.AbstractScriptHandler;
import oracle.eclipse.tools.application.common.services.variables.DataType;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import org.eclipse.jst.jsf.context.IModelContext;

public class JSPScriptHandler
extends AbstractScriptHandler {
    public static final String JSP_EXPRESSION = "jsp-expression";
    private static final String SCRIPT_PREFIX = "<%= ";
    private static final String SCRIPT_SUFFIX = " %>";

    public JSPScriptHandler(IModelContext context) {
        super(context);
    }

    public String getScriptPrefix() {
        return SCRIPT_PREFIX;
    }

    public String getScriptSuffix() {
        return SCRIPT_SUFFIX;
    }

    public String getScriptId() {
        return JSP_EXPRESSION;
    }

    public String computeExpression(ValueReference valRef) {
        return this.computeExpression(valRef, true);
    }

    public String computeExpression(ValueReference valRef, boolean includeSuffixAndPrefix) {
        StringBuffer expr = new StringBuffer(includeSuffixAndPrefix ? this.getScriptPrefix() : "");
        expr.append(this.doComputeVarExpr(valRef));
        if (includeSuffixAndPrefix) {
            expr.append(this.getScriptSuffix());
        }
        return expr.toString();
    }

    protected String doComputeVarExpr(ValueReference valRef) {
        Variable var = valRef.getVariable();
        String value = var.getName();
        DataType.Field[] fields = valRef.getFieldPath(this._context);
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                DataType.Field fld = fields[i];
                String getter = ".get" + fld.getName().substring(0, 1).toUpperCase() + fld.getName().substring(1) + "()";
                value = String.valueOf(value) + getter;
                ++i;
            }
        }
        return value;
    }
}

