/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.document;

import oracle.eclipse.tools.application.common.services.documentservices.DeferredELScriptHandler;
import oracle.eclipse.tools.application.common.services.documentservices.ELScriptHandler;
import oracle.eclipse.tools.application.common.services.documentservices.IScriptHandler;
import oracle.eclipse.tools.application.common.services.resource.ResourceBundleKeyPair;
import oracle.eclipse.tools.application.common.services.variables.JDTDataType;
import oracle.eclipse.tools.application.common.services.variables.MethodReference;
import oracle.eclipse.tools.application.common.services.variables.ResolutionTime;
import oracle.eclipse.tools.application.common.services.variables.ScriptingVariable;
import oracle.eclipse.tools.application.common.services.variables.ValueReference;
import oracle.eclipse.tools.application.common.services.variables.Variable;
import oracle.eclipse.tools.common.services.document.FilePositionContext;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.webtier.html.model.xhtml.XhtmlPackage;
import oracle.eclipse.tools.webtier.jsp.document.AbstractDocumentBindingService;
import oracle.eclipse.tools.webtier.jsp.document.JSPScriptHandler;
import oracle.eclipse.tools.webtier.jsp.model.jsptagbase.AbstractBaseTag;
import org.eclipse.jst.jsf.context.IModelContext;

public class JSPBinder
extends AbstractDocumentBindingService {
    private static final int SORT_PRIORITY = 8;
    private IScriptHandler _immediateScriptingHandler;
    private IScriptHandler _deferredScriptingHandler;
    private IScriptHandler _jspScriptingHandler;
    private boolean _isJspScriptletVar;
    private boolean _jspScripting;
    private boolean _immediateScript;
    private boolean _isRTExprValue;
    private ResolutionTime _varResolutionTime;
    private ResolutionTime _expectedResTime;

    public JSPBinder(IDocument doc) {
        this(doc, (IScriptHandler)new ELScriptHandler((IModelContext)new FilePositionContext(doc.getFile())), (IScriptHandler)new DeferredELScriptHandler((IModelContext)new FilePositionContext(doc.getFile())), (IScriptHandler)new JSPScriptHandler((IModelContext)new FilePositionContext(doc.getFile())));
    }

    protected JSPBinder(IDocument doc, IScriptHandler immediateScriptHandler, IScriptHandler deferredScriptHandler, IScriptHandler jspScriptHandler) {
        super(doc);
        this._immediateScriptingHandler = immediateScriptHandler;
        this._deferredScriptingHandler = deferredScriptHandler;
        this._jspScriptingHandler = jspScriptHandler;
    }

    public String getPluginType() {
        return "jsp";
    }

    protected boolean canBindToValRef(ValueReference valRef) {
        if (valRef == null) {
            return true;
        }
        if (XhtmlPackage.eINSTANCE.getNsURI().equals(this.getTag().eClass().getEPackage().getNsURI())) {
            return false;
        }
        this.computeContext(valRef);
        switch (this._varResolutionTime) {
            case PAGE_RUN: {
                return this.isPageRunBinding(valRef);
            }
            case PAGE_COMPILE: {
                if (!this.isPageCompileBinding(valRef)) break;
                return true;
            }
            case PAGE_RUN_OR_COMPILE: {
                if (!this._expectedResTime.isRuntimeVisible() && !this._expectedResTime.isCompileTimeVisible()) break;
                return true;
            }
        }
        return true;
    }

    private boolean isPageCompileBinding(ValueReference valRef) {
        this._jspScripting = this.canBeJSPExpression(valRef);
        this._immediateScript = this.canBeJSPELExpression(valRef);
        return this._jspScripting || this._immediateScript;
    }

    private boolean isPageRunBinding(ValueReference valRef) {
        switch (valRef.getVariable().getScope()) {
            case REQUEST_SCOPE: 
            case SESSION_SCOPE: 
            case APPLICATION_SCOPE: 
            case NESTED_SCOPE: {
                return this._expectedResTime.isRuntimeVisible();
            }
        }
        return false;
    }

    private boolean canBeJSPELExpression(ValueReference valRef) {
        if (!this._isRTExprValue) {
            return false;
        }
        Variable var = valRef.getVariable();
        return var.getType() instanceof JDTDataType && var.isScriptable();
    }

    protected final void computeContext(ValueReference valRef) {
        this._varResolutionTime = valRef.getVariable().getResolutionType();
        this._isJspScriptletVar = valRef.getVariable() instanceof ScriptingVariable;
        this._isRTExprValue = this.isRuntimeExprValue();
        this._expectedResTime = this.getExpectedResolutionTime();
    }

    protected boolean canBindToMethodRef(MethodReference methodRef) {
        if (methodRef == null || methodRef.getValueReference() == null) {
            return true;
        }
        this.computeContext(methodRef.getValueReference());
        if (this._varResolutionTime.isRuntimeVisible()) {
            return this.canBindToValRef(methodRef.getValueReference());
        }
        return false;
    }

    @Override
    protected boolean canBindToResourceBundleKeyPair(ResourceBundleKeyPair pair) {
        return true;
    }

    protected IScriptHandler getScriptHandler() {
        if (this._varResolutionTime == ResolutionTime.PAGE_RUN) {
            return this._deferredScriptingHandler;
        }
        if (this._varResolutionTime == ResolutionTime.PAGE_RUN_OR_COMPILE) {
            switch (this._expectedResTime) {
                case PAGE_RUN: 
                case PAGE_RUN_OR_COMPILE: {
                    return this._deferredScriptingHandler;
                }
            }
        }
        if (this._isJspScriptletVar && this._jspScripting) {
            return this._jspScriptingHandler;
        }
        return this._immediateScriptingHandler;
    }

    @Override
    protected boolean isSupportedTag(AbstractBaseTag tagElement) {
        return true;
    }

    private boolean canBeJSPExpression(ValueReference valRef) {
        if (!this._isRTExprValue) {
            return false;
        }
        Variable var = valRef.getVariable();
        return var instanceof ScriptingVariable;
    }

    public int getPriority() {
        return 8;
    }
}

