/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.collection;

import java.util.Collection;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.include.model.IMergedModelNode;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.IMergedModel;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.MergedModelManager;
import oracle.eclipse.tools.webtier.common.services.jsp.include.model.ResourceReferenceInfo;
import oracle.eclipse.tools.webtier.jsp.collection.AbstractJSPCollector;
import oracle.eclipse.tools.webtier.jsp.collection.JSPTagCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class JSPIncludeReferenceCollector
extends AbstractJSPCollector {
    private static final String ID = "JSP-Includes";

    public JSPIncludeReferenceCollector() {
        this(ID, JSPTagCollector.JSP_CONTENT_TYPES);
    }

    protected JSPIncludeReferenceCollector(String id, Set<String> contentTypes) {
        super(id, contentTypes);
    }

    @Override
    public boolean visit(IDOMDocument domDocument) {
        IMergedModelNode mmNode;
        if (this.isCollectable() && (mmNode = (IMergedModelNode)domDocument.getAdapterFor(IMergedModelNode.class)) != null) {
            ResourceArtifact referantArtifact = this.structuredContext.ensureResourceArtifact(this.getCurrentResource());
            IFile file = mmNode.getBaseSourceFile();
            if (file != null) {
                IMergedModel mergedModel = null;
                try {
                    mergedModel = MergedModelManager.getInstance().getMergedModel(file);
                    Collection refs = mergedModel.getIncludeResourceReferences();
                    for (ResourceReferenceInfo ref : refs) {
                        this.structuredContext.addReferencedResource((IArtifact)referantArtifact, ref.getRefereeResource(), true, ref.getReferenceLocation(), (byte)0, this.getID());
                    }
                }
                finally {
                    if (mergedModel != null) {
                        mergedModel.release();
                    }
                }
            }
        }
        return false;
    }
}

