/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.webtier.jsp.collection;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.eclipse.tools.application.common.services.collection.AbstractArtifactCollector;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentCollectionContext;
import oracle.eclipse.tools.application.common.services.collection.IStructuredDocumentResourceCollectionContext;
import oracle.eclipse.tools.common.services.dependency.artifact.IResourceContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public abstract class AbstractJSPCollector
extends AbstractArtifactCollector {
    protected static final String CTYPE_JSPSOURCE = "org.eclipse.jst.jsp.core.jspsource";
    protected static final String CTYPE_JSPFRAGMENTSOURCE = "org.eclipse.jst.jsp.core.jspfragmentsource";
    protected static final String CTYPE_HTMLSOURCE = "org.eclipse.wst.html.core.htmlsource";
    public static final Set<String> JSP_CONTENT_TYPES;
    private IPath wkspaceRelativePath = null;
    private boolean isCollectable = false;
    private IResource currentResource = null;

    static {
        LinkedHashSet<String> types = new LinkedHashSet<String>(3, 1.0f);
        types.add(CTYPE_JSPSOURCE);
        types.add(CTYPE_JSPFRAGMENTSOURCE);
        types.add(CTYPE_HTMLSOURCE);
        JSP_CONTENT_TYPES = Collections.unmodifiableSet(types);
    }

    protected AbstractJSPCollector(String id, Set<String> contentTypes) {
        super(id, contentTypes);
    }

    public void beginResource(IStructuredDocumentResourceCollectionContext resourceContext, IProgressMonitor monitor) {
        super.beginResource(resourceContext, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.currentResource = resourceContext.getResource();
        this.isCollectable = this.currentResource.isAccessible() && this.currentResource.getType() == 1 && this.wkspaceRelativePath != null && this.wkspaceRelativePath.isPrefixOf(this.currentResource.getFullPath().makeAbsolute()) && this.getFilter().match((IResourceContext)resourceContext);
    }

    public void startCollecting(IStructuredDocumentCollectionContext context, IProgressMonitor monitor) {
        super.startCollecting(context, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        IProject prj = context.getProject();
        if (prj != null && prj.isAccessible()) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)prj);
            if (component != null) {
                IVirtualFolder container = component.getRootFolder();
                this.wkspaceRelativePath = container.getWorkspaceRelativePath().makeAbsolute();
            } else {
                throw new AssertionError((Object)"Calling startCollecting on a project with no web root");
            }
        }
    }

    public boolean visit(IDOMNode node) {
        return false;
    }

    public boolean visit(IDOMAttr attribute) {
        return false;
    }

    public boolean visit(IDOMElement element) {
        return false;
    }

    public boolean visit(IDOMDocument document) {
        return false;
    }

    public IPath getWkspaceRelativePath() {
        return this.wkspaceRelativePath;
    }

    protected boolean isCollectable() {
        return this.isCollectable;
    }

    protected IResource getCurrentResource() {
        return this.currentResource;
    }
}

