/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.whitelist;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.server.internal.CheckResult;
import oracle.eclipse.tools.cloud.server.internal.IWhitelistScanner;
import oracle.eclipse.tools.cloud.server.internal.NuviaqToolsFactory;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.whitelist.IReporter;
import oracle.eclipse.tools.whitelist.JSPWhitelistValidator;
import oracle.eclipse.tools.whitelist.JavaSourceVisitor;
import oracle.eclipse.tools.whitelist.ProjectDependencyVisitor;
import oracle.eclipse.tools.whitelist.internal.DeploymentDescriptorProblemQuickFixer;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.validation.ReporterHelper;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;

public final class WhitelistBuilder
extends IncrementalProjectBuilder
implements IReporter {
    public static final String BUILDER_ID = "oracle.eclipse.tools.cloud.whitelist";
    public static final String PROBLEM_MARKER_ID = "oracle.eclipse.tools.cloud.whitelist.problem";
    private static IContentType fJSPContentType = null;
    private static Set<IProject> cloudPorjects = new HashSet<IProject>();
    private static IResourceChangeListener projectChangeListener = null;

    public static boolean isWhitelistBuilderInstalled(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        List<ICommand> commands = WhitelistBuilder.list(desc.getBuildSpec());
        boolean found = false;
        for (ICommand command : commands) {
            String builder = command.getBuilderName();
            if (builder == null || !builder.equals(BUILDER_ID)) continue;
            found = true;
            break;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDeployToCloud(IProject proj) {
        Set<IProject> set = cloudPorjects;
        synchronized (set) {
            if (cloudPorjects.size() == 0) {
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    try {
                        if (WhitelistBuilder.isWhitelistBuilderInstalled(p)) {
                            ProjectDependencyVisitor visitor = new ProjectDependencyVisitor(p){

                                @Override
                                protected void processProject(IProject refProj, IProgressMonitor monitor) throws CoreException {
                                    cloudPorjects.add(refProj);
                                }
                            };
                            visitor.visit((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
                WhitelistBuilder.addProjectChangeListener();
            }
        }
        return cloudPorjects.contains(proj);
    }

    private static void addProjectChangeListener() {
        if (projectChangeListener == null) {
            projectChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta = event.getDelta();
                    if (delta != null) {
                        try {
                            IResourceDelta[] changeDeltas;
                            IResourceDelta[] projDeltas;
                            IResourceDelta[] newProjDeltas;
                            IResourceDelta[] iResourceDeltaArray = newProjDeltas = delta.getAffectedChildren(1);
                            int n = newProjDeltas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResourceDelta newProj = iResourceDeltaArray[n2];
                                if (newProj.getResource() instanceof IProject) {
                                    cloudPorjects.clear();
                                    return;
                                }
                                ++n2;
                            }
                            IResourceDelta[] iResourceDeltaArray2 = projDeltas = delta.getAffectedChildren(2);
                            int n3 = projDeltas.length;
                            n = 0;
                            while (n < n3) {
                                IResourceDelta removeProj = iResourceDeltaArray2[n];
                                if (removeProj.getResource() instanceof IProject) {
                                    cloudPorjects.clear();
                                    return;
                                }
                                ++n;
                            }
                            IResourceDelta[] iResourceDeltaArray3 = changeDeltas = delta.getAffectedChildren(4);
                            int n4 = changeDeltas.length;
                            n3 = 0;
                            while (n3 < n4) {
                                IResourceDelta d = iResourceDeltaArray3[n3];
                                IResourceDelta fileDelta = d.findMember((IPath)new Path("/.settings/org.eclipse.wst.common.component"));
                                if (fileDelta != null) {
                                    cloudPorjects.clear();
                                    return;
                                }
                                ++n3;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(projectChangeListener);
        }
    }

    public static void install(IProject project) throws CoreException {
        boolean found = WhitelistBuilder.isWhitelistBuilderInstalled(project);
        if (!found) {
            IProjectDescription desc = project.getDescription();
            List<ICommand> commands = WhitelistBuilder.list(desc.getBuildSpec());
            int pos = 0;
            int count = commands.size();
            while (pos < count) {
                ICommand command = commands.get(pos);
                String builder = command.getBuilderName();
                if (builder != null && builder.equals("org.eclipse.jdt.core.javabuilder")) {
                    ++pos;
                    break;
                }
                ++pos;
            }
            ICommand command = desc.newCommand();
            command.setBuilderName(BUILDER_ID);
            commands.add(pos, command);
            desc.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
            project.setDescription(desc, null);
        }
    }

    public static void uninstall(IProject project) throws CoreException {
        IProjectDescription desc;
        try {
            desc = project.getDescription();
        }
        catch (ResourceException resourceException) {
            return;
        }
        List<ICommand> commands = WhitelistBuilder.list(desc.getBuildSpec());
        boolean found = false;
        Iterator<ICommand> itr = commands.iterator();
        while (itr.hasNext()) {
            ICommand command = itr.next();
            String builder = command.getBuilderName();
            if (builder == null || !builder.equals(BUILDER_ID)) continue;
            found = true;
            itr.remove();
        }
        if (found) {
            desc.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
            project.setDescription(desc, null);
            IMarker[] iMarkerArray = project.findMarkers(PROBLEM_MARKER_ID, true, 2);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
        }
    }

    private static <T> List<T> list(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    protected IProject[] build(final int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        final IProject proj = this.getProject();
        ProjectDependencyVisitor dependVisitor = new ProjectDependencyVisitor(proj){

            @Override
            protected void processProject(IProject refProj, IProgressMonitor monitor) throws CoreException {
                if (refProj == proj) {
                    IResourceDelta delta = WhitelistBuilder.this.getDelta(proj);
                    WhitelistBuilder.this.scanJavaFiles(kind, proj, delta, monitor);
                    WhitelistBuilder.this.scanJspLibExeXmlFiles(kind, proj, delta, monitor);
                } else {
                    WhitelistBuilder.this.scanJavaFiles(kind, refProj, null, monitor);
                    WhitelistBuilder.this.scanJspLibExeXmlFiles(kind, refProj, null, monitor);
                }
            }
        };
        dependVisitor.visit(monitor);
        this.checkMissingDescriptorFiles(proj);
        return null;
    }

    private void checkMissingDescriptorFiles(IProject proj) throws CoreException {
        WebArtifactEdit edit = WebArtifactEdit.getWebArtifactEditForRead((IProject)proj);
        if (edit != null) {
            File weblogicXml;
            IMarker[] iMarkerArray = proj.findMarkers(PROBLEM_MARKER_ID, true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String s = "" + marker.getAttribute("message");
                if (s.startsWith(Resources.missingFile1)) {
                    marker.delete();
                }
                ++n2;
            }
            IPath p = edit.getDeploymentDescriptorPath();
            File webXml = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(p).toFile();
            if (!webXml.exists()) {
                this.warnMissingFile(proj, webXml);
            }
            if (!(weblogicXml = new File(webXml.getParentFile(), "weblogic.xml")).exists()) {
                this.warnMissingFile(proj, weblogicXml);
            }
        }
    }

    private void warnMissingFile(IProject proj, File file) throws CoreException {
        IMarker marker;
        String msg = String.valueOf(Resources.missingFile1) + file.getName();
        IMarker[] iMarkerArray = proj.findMarkers(PROBLEM_MARKER_ID, true, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            marker = iMarkerArray[n2];
            String s = "" + marker.getAttribute("message");
            if (s.startsWith(msg)) {
                return;
            }
            ++n2;
        }
        marker = proj.createMarker(PROBLEM_MARKER_ID);
        marker.setAttribute("message", (Object)(String.valueOf(msg) + Resources.missingFile2));
        marker.setAttribute("severity", 1);
    }

    private IProject[] scanJavaFiles(int kind, IProject proj, IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        final IJavaProject jproj = JavaCore.create((IProject)proj);
        if (!jproj.isOpen()) {
            return null;
        }
        if (delta == null || kind == 6 || kind == 15) {
            IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                int cpeKind = cpe.getEntryKind();
                if (cpeKind == 3) {
                    IPath sourceFolderPath = cpe.getPath().makeRelative().removeFirstSegments(1);
                    final IFolder sourceFolder = proj.getFolder(sourceFolderPath);
                    sourceFolder.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) throws CoreException {
                            IFile file;
                            String extension;
                            if (resource instanceof IFile && (extension = (file = (IFile)resource).getFileExtension()) != null && extension.equals("java")) {
                                WhitelistBuilder.this.scan(jproj, sourceFolder, (IFile)resource);
                            }
                            return true;
                        }
                    });
                }
                ++n2;
            }
        } else {
            IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n3 = 0;
            while (n3 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n3];
                int cpeKind = cpe.getEntryKind();
                if (cpeKind == 3) {
                    IPath sourceFolderPath = cpe.getPath().makeRelative().removeFirstSegments(1);
                    final IFolder sourceFolder = proj.getFolder(sourceFolderPath);
                    IResourceDelta sourceFolderDelta = delta.findMember(sourceFolderPath);
                    if (sourceFolderDelta != null) {
                        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                IResource resource;
                                int kind = delta.getKind();
                                if ((kind == 1 || kind == 4) && (resource = delta.getResource()) instanceof IFile) {
                                    WhitelistBuilder.this.scan(jproj, sourceFolder, (IFile)resource);
                                }
                                return true;
                            }
                        };
                        sourceFolderDelta.accept(visitor);
                    }
                }
                ++n3;
            }
        }
        return null;
    }

    private IProject[] scanJspLibExeXmlFiles(final int kind, final IProject proj, final IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        final IWhitelistScanner whitelistScanner = NuviaqToolsFactory.getInstance().createWhitelistScanner(proj);
        if (whitelistScanner == null) {
            return null;
        }
        JSPWhitelistValidator validator = new JSPWhitelistValidator();
        IProjectValidationContext helper = new IProjectValidationContext(){

            public IProject getProject() {
                return proj;
            }

            public Object loadModel(String symbolicName) {
                return null;
            }

            public Object loadModel(String symbolicName, Object[] parms) {
                return null;
            }

            public String[] getURIs() {
                J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(proj);
                final ArrayList jspFiles = new ArrayList();
                IContainer[] iContainerArray = deployable.getResourceFolders();
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer c = iContainerArray[n2];
                    if (delta == null || kind == 6 || kind == 15) {
                        try {
                            c.accept(new IResourceVisitor(){

                                public boolean visit(IResource resource) throws CoreException {
                                    if (resource instanceof IFile) {
                                        IFile file = (IFile)resource;
                                        String extension = file.getFileExtension();
                                        IContentType jspContentType = WhitelistBuilder.this.getJSPContentType();
                                        if (jspContentType.isAssociatedWith(file.getName()) || "jsf".equals(extension)) {
                                            jspFiles.add(file);
                                        }
                                        if ("xml".equals(extension)) {
                                            IMarker[] iMarkerArray = file.findMarkers(WhitelistBuilder.PROBLEM_MARKER_ID, true, 0);
                                            int n = iMarkerArray.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IMarker marker = iMarkerArray[n2];
                                                marker.delete();
                                                ++n2;
                                            }
                                            WhitelistBuilder.this.checkXmlFile(whitelistScanner, file);
                                        }
                                        WhitelistBuilder.this.checkFilePath(whitelistScanner, file);
                                    }
                                    return true;
                                }
                            });
                        }
                        catch (CoreException ce) {
                            ce.printStackTrace();
                        }
                    } else {
                        IPath path = c.getFullPath().removeFirstSegments(1);
                        IResourceDelta sourceFolderDelta = delta.findMember(path);
                        if (sourceFolderDelta != null) {
                            try {
                                sourceFolderDelta.accept(new IResourceDeltaVisitor(){

                                    public boolean visit(IResourceDelta delta) throws CoreException {
                                        IResource resource;
                                        int deltaKind = delta.getKind();
                                        if ((deltaKind == 1 || deltaKind == 4) && (resource = delta.getResource()) instanceof IFile) {
                                            IMarker marker;
                                            int n;
                                            int n2;
                                            IMarker[] iMarkerArray;
                                            IFile file = (IFile)resource;
                                            String extension = file.getFileExtension();
                                            if (extension == null) {
                                                return true;
                                            }
                                            if (WhitelistBuilder.this.getJSPContentType().isAssociatedWith(file.getName()) || extension.equals("jsf")) {
                                                jspFiles.add(file);
                                                iMarkerArray = file.findMarkers(WhitelistBuilder.PROBLEM_MARKER_ID, true, 0);
                                                n2 = iMarkerArray.length;
                                                n = 0;
                                                while (n < n2) {
                                                    marker = iMarkerArray[n];
                                                    marker.delete();
                                                    ++n;
                                                }
                                            }
                                            if (extension.equals("xml")) {
                                                iMarkerArray = file.findMarkers(WhitelistBuilder.PROBLEM_MARKER_ID, true, 0);
                                                n2 = iMarkerArray.length;
                                                n = 0;
                                                while (n < n2) {
                                                    marker = iMarkerArray[n];
                                                    marker.delete();
                                                    ++n;
                                                }
                                                WhitelistBuilder.this.checkXmlFile(whitelistScanner, file);
                                            }
                                            WhitelistBuilder.this.checkFilePath(whitelistScanner, file);
                                        }
                                        return true;
                                    }
                                });
                            }
                            catch (CoreException ce) {
                                ce.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
                String[] ret = new String[jspFiles.size()];
                int i = 0;
                for (IFile f : jspFiles) {
                    ret[i++] = f.getFullPath().toString();
                }
                return ret;
            }
        };
        ReporterHelper reporter = new ReporterHelper(monitor);
        try {
            validator.validate((IValidationContext)helper, (org.eclipse.wst.validation.internal.provisional.core.IReporter)reporter);
            reporter.makeMarkers();
        }
        catch (ValidationException validationException) {}
        return null;
    }

    private IContentType getJSPContentType() {
        if (fJSPContentType == null) {
            fJSPContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP);
        }
        return fJSPContentType;
    }

    private void checkXmlFile(IWhitelistScanner whitelistScanner, IFile file) {
        String filePah = file.getLocation().toPortableString();
        if (whitelistScanner != null) {
            List<CheckResult> results = whitelistScanner.checkXMLFileConfiguration(filePah);
            for (CheckResult result : results) {
                if (CheckResult.PASSED == result) continue;
                int severity = result.getSeverity() == CheckResult.Severity.ERROR ? 2 : 1;
                WhitelistBuilder.reportProblem(file, null, result.getMessage(), result.getLineNumber(), severity);
            }
        }
    }

    private void checkFilePath(IWhitelistScanner whitelistScanner, IFile file) {
        CheckResult result;
        String filePah = file.getLocation().toPortableString();
        if (whitelistScanner != null && CheckResult.PASSED != (result = whitelistScanner.checkFilePath(filePah))) {
            int severity = result.getSeverity() == CheckResult.Severity.ERROR ? 2 : 1;
            WhitelistBuilder.reportProblem(file, null, result.getMessage(), -1, severity);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        IProject proj = this.getProject();
        try {
            ProjectDependencyVisitor dependVisitor = new ProjectDependencyVisitor(proj){

                @Override
                protected void processProject(IProject refProj, IProgressMonitor monitor) throws CoreException {
                    IMarker[] iMarkerArray = refProj.findMarkers(WhitelistBuilder.PROBLEM_MARKER_ID, true, 2);
                    int n = iMarkerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker marker = iMarkerArray[n2];
                        marker.delete();
                        ++n2;
                    }
                }
            };
            dependVisitor.visit(monitor);
        }
        catch (CoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
    }

    void scan(IJavaProject project, IFolder sourceFolder, IFile sourceFile) {
        try {
            IMarker[] iMarkerArray = sourceFile.findMarkers(PROBLEM_MARKER_ID, true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                marker.delete();
                ++n2;
            }
            IPath path = sourceFile.getFullPath().makeRelativeTo(sourceFolder.getFullPath());
            ICompilationUnit unit = (ICompilationUnit)project.findElement(path);
            if (unit == null) {
                return;
            }
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setKind(8);
            parser.setSource(unit);
            parser.setResolveBindings(true);
            CompilationUnit root = (CompilationUnit)parser.createAST(null);
            root.accept((ASTVisitor)new JavaSourceVisitor(sourceFile, this));
        }
        catch (CoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
    }

    @Override
    public void reportTypeAccessProblem(IFile file, ASTNode node, ITypeBinding binding, String message, CheckResult.Severity severity) {
        int markerSeverity = severity == CheckResult.Severity.ERROR ? 2 : 1;
        WhitelistBuilder.reportProblem(file, node, message, -1, markerSeverity);
    }

    @Override
    public void reportMethodAccessProblem(IFile file, ASTNode node, IMethodBinding binding, String message, CheckResult.Severity severity) {
        WhitelistBuilder.reportProblem(file, node, message, -1);
    }

    @Override
    public void reportFieldAccessProblem(IFile file, ASTNode node, IVariableBinding binding, String message, CheckResult.Severity severity) {
        WhitelistBuilder.reportProblem(file, node, message, -1);
    }

    private static void reportProblem(IFile file, ASTNode node, String message, int lineNumber) {
        WhitelistBuilder.reportProblem(file, node, message, lineNumber, 1);
    }

    private static void reportProblem(IFile file, ASTNode node, String message, int lineNumber, int severity) {
        try {
            if (node != null) {
                IMarker[] markers;
                CompilationUnit unit = (CompilationUnit)node.getRoot();
                int charStart = node.getStartPosition();
                int charEnd = charStart + node.getLength();
                int line = unit.getLineNumber(charStart);
                MarkerManager markerMan = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
                IMarker[] iMarkerArray = markers = markerMan.findMarkers((IResource)file, PROBLEM_MARKER_ID, false, 1);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    int n3 = m.getAttribute("lineNumber", -1);
                    String msg = m.getAttribute("message", "");
                    if (msg.equals(message) && n3 == line) {
                        return;
                    }
                    ++n2;
                }
                IMarker marker = file.createMarker(PROBLEM_MARKER_ID);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                marker.setAttribute("lineNumber", line);
                marker.setAttribute("charStart", charStart);
                marker.setAttribute("charEnd", charEnd);
            } else {
                IMarker marker = file.createMarker(PROBLEM_MARKER_ID);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", severity);
                marker.setAttribute("lineNumber", lineNumber);
            }
        }
        catch (CoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
    }

    public static void addCloudProjectQuickFixListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    IResourceDelta[] newProjDeltas;
                    IResourceDelta[] iResourceDeltaArray = newProjDeltas = delta.getAffectedChildren(1);
                    int n = newProjDeltas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject newProject;
                        IResourceDelta newProj = iResourceDeltaArray[n2];
                        if (newProj.getResource() instanceof IProject && OracleCloudTools.isTargetToCloudRuntime(newProject = (IProject)newProj.getResource()) && WtpProjectUtil.isDynamicWebProject((IProject)newProject)) {
                            WorkspaceJob quickFix = new WorkspaceJob(""){

                                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                    try {
                                        DeploymentDescriptorProblemQuickFixer.addUniqueCookiePath(newProject);
                                        DeploymentDescriptorProblemQuickFixer.addVerbose(newProject);
                                        DeploymentDescriptorProblemQuickFixer.addLoginConfig(newProject);
                                    }
                                    catch (ResourceStoreException e) {
                                        return CloudPlugin.createWarningStatus("Failed to update weblogic.xml with unique cookie path", (Exception)((Object)e));
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            quickFix.schedule(1000L);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    static final class Resources
    extends NLS {
        public static String typeAccessProblem;
        public static String methodAccessProblem;
        public static String fieldAccessProblem;
        public static String missingFile1;
        public static String missingFile2;

        static {
            Resources.initializeMessages((String)WhitelistBuilder.class.getName(), Resources.class);
        }

        Resources() {
        }
    }
}

