/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.whitelist;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.server.internal.CheckResult;
import oracle.eclipse.tools.whitelist.IReporter;
import oracle.eclipse.tools.whitelist.JavaSourceVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.CompilationUnitHelper;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationExtension;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;

public class JSPWhitelistScanner
extends JSPTranslationExtension
implements IReporter {
    private List<IProblem> fWhitelistProblems = new ArrayList<IProblem>();

    public JSPWhitelistScanner(IDocument jspDocument, IDocument javaDocument, IJavaProject javaProj, JSPTranslator translator) {
        super(jspDocument, javaDocument, javaProj, translator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileCompilationUnit() {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu != null) {
            super.reconcileCompilationUnit();
            try {
                ICompilationUnit iCompilationUnit = cu;
                synchronized (iCompilationUnit) {
                    cu.reconcile(0, true, this.getWorkingCopyOwner(), (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException e) {
                Logger.logException((Throwable)e);
            }
            this.doWhitelistScan(cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWhitelistScan(ICompilationUnit cu) {
        try {
            ICompilationUnit iCompilationUnit = cu;
            synchronized (iCompilationUnit) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(cu.getPath());
                WorkingCopyOwner owner = CompilationUnitHelper.getInstance().getWorkingCopyOwner();
                ICompilationUnit workingCopy = cu.getWorkingCopy(owner, (IProgressMonitor)new NullProgressMonitor());
                CompilationUnit root = this.getAST3(workingCopy);
                root.accept((ASTVisitor)new JavaSourceVisitor(file, this));
            }
        }
        catch (JavaModelException e) {
            Logger.logException((Throwable)e);
        }
    }

    public CompilationUnit getAST3(ICompilationUnit workingCopy) throws JavaModelException {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setCompilerOptions(workingCopy.getJavaProject().getOptions(true));
        if (JavaProject.hasJavaNature((IProject)workingCopy.getJavaProject().getProject())) {
            parser.setResolveBindings(true);
        }
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(true);
        parser.setSource(workingCopy);
        parser.setIgnoreMethodBodies(false);
        return (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void reportMethodAccessProblem(IFile file, ASTNode node, IMethodBinding binding, String message, CheckResult.Severity severity) {
        CompilationUnit unit = (CompilationUnit)node.getRoot();
        int charStart = node.getStartPosition();
        int charEnd = charStart + node.getLength();
        int lineNumber = unit.getLineNumber(charStart);
        int columnNumber = unit.getColumnNumber(charStart);
        int problemSeverity = severity == CheckResult.Severity.ERROR ? 1 : 0;
        DefaultProblem problem = new DefaultProblem(file.getLocation().toString().toCharArray(), message, 67108965, new String[0], problemSeverity, charStart, charEnd, lineNumber, columnNumber);
        this.fWhitelistProblems.add((IProblem)problem);
    }

    @Override
    public void reportTypeAccessProblem(IFile file, ASTNode node, ITypeBinding binding, String message, CheckResult.Severity severity) {
        CompilationUnit unit = (CompilationUnit)node.getRoot();
        int charStart = node.getStartPosition();
        int charEnd = charStart + node.getLength();
        int lineNumber = unit.getLineNumber(charStart);
        int columnNumber = unit.getColumnNumber(charStart);
        int problemSeverity = severity == CheckResult.Severity.ERROR ? 1 : 0;
        DefaultProblem problem = new DefaultProblem(file.getLocation().toString().toCharArray(), message, 67108965, new String[0], problemSeverity, charStart, charEnd, lineNumber, columnNumber);
        this.fWhitelistProblems.add((IProblem)problem);
    }

    @Override
    public void reportFieldAccessProblem(IFile file, ASTNode node, IVariableBinding binding, String message, CheckResult.Severity severity) {
        CompilationUnit unit = (CompilationUnit)node.getRoot();
        int charStart = node.getStartPosition();
        int charEnd = charStart + node.getLength();
        int lineNumber = unit.getLineNumber(charStart);
        int columnNumber = unit.getColumnNumber(charStart);
        DefaultProblem problem = new DefaultProblem(file.getLocation().toString().toCharArray(), message, 67108965, new String[0], 1, charStart, charEnd, lineNumber, columnNumber);
        this.fWhitelistProblems.add((IProblem)problem);
    }

    public List getProblems() {
        return this.fWhitelistProblems;
    }
}

