/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.modules;

import oracle.cloud.paas.model.Library;
import oracle.cloud.paas.model.LibraryDeployType;
import oracle.eclipse.tools.cloud.server.modules.CloudSharedLibraries;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.server.modules.JavaEEModule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.server.core.IServer;

public abstract class CloudSharedLibrary
extends JavaEEModule
implements IWorkbenchAdapter {
    private final CloudSharedLibraries libraries;
    private Library library = null;

    public CloudSharedLibrary(CloudSharedLibraries libraries, Library lib, IServer server) {
        super(lib.getName(), lib.getType().name(), server);
        this.setSharedLibrary(true);
        this.libraries = libraries;
        this.library = lib;
    }

    public CloudSharedLibraries libraries() {
        return this.libraries;
    }

    public String getName() {
        return this.library.getName();
    }

    public String getDeployType() {
        return this.library.getDeployType() != null ? this.library.getDeployType().name() : "";
    }

    public String getSpecVersion() {
        return this.library.getSpecVersion();
    }

    public String getImplVersion() {
        return this.library.getImplVersion();
    }

    public String getState() {
        return this.library.getState().name();
    }

    public boolean isReadOnly() {
        return this.library.getDeployType() == LibraryDeployType.READONLY;
    }

    public Library getLibrary() {
        return this.library;
    }

    public LibraryModule local() {
        String spec = this.getSpecVersion();
        String impl = this.getImplVersion();
        LibraryModuleRef ref = new LibraryModuleRef(this.library.getName(), spec == null ? null : new Version(spec), impl == null ? null : new Version(impl), false);
        try {
            return LibraryModulesSvc.getRegistry().resolve(ref);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String label() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        String spec = this.getSpecVersion();
        String impl = this.getImplVersion();
        if (spec != null && impl != null) {
            buf.append(" [");
            if (spec != null) {
                buf.append(spec);
                if (impl != null) {
                    buf.append(", ");
                }
            }
            if (impl != null) {
                buf.append(impl);
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        CloudSharedLibrary lib = (CloudSharedLibrary)((Object)o);
        return lib.label();
    }

    public Object getParent(Object o) {
        return null;
    }
}

