/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.ICloudDeploymentListener;
import oracle.eclipse.tools.cloud.IOracleCloudTargetConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.java.sdk.JavaCloudServiceSdk;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.common.util.StringInputStream;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WhitelistScanToolRunner {
    private static final String LOG_RECORD_MESSAGE_XPATH = "/log/record/message";
    private OracleCloudRuntime cloudRuntime = null;
    private File archiveFile;
    private IProject project;
    private String scanOutput;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public WhitelistScanToolRunner(OracleCloudRuntime rt, WeblogicServerRuntime wlsRt, IProject sourceProj, String archive) {
        this.cloudRuntime = rt;
        this.archiveFile = new File(archive);
        this.project = sourceProj;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Oracle Cloud Whitelist Scan", 100);
            MarkerManager markerMan = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager();
            IMarker[] markers = markerMan.findMarkers((IResource)this.project, "oracle.eclipse.tools.cloud.whitelist.problem", false, 2);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                try {
                    m.delete();
                }
                catch (CoreException coreException) {}
                ++n2;
            }
            monitor.worked(10);
            this.project.build(6, monitor);
            monitor.worked(10);
            List<String> cmdLine = this.createCommandLine();
            int ret = this.executeScanner(cmdLine);
            markers = markerMan.findMarkers((IResource)this.project, "oracle.eclipse.tools.cloud.whitelist.problem", false, 2);
            monitor.worked(50);
            if (markers.length > 0 || ret != 0 || this.scanOutput.indexOf("[WARNING]") >= 0) {
                this.createProblemMarkers(ret);
                for (ICloudDeploymentListener listener : CloudPlugin.getDeploymentListener()) {
                    listener.revealWhitelistProblemView();
                }
                if (ret != 0) {
                    return CloudPlugin.createErrorStatus(String.format(Resources.errScanApp, this.archiveFile.getName()), null);
                }
                return CloudPlugin.createWarningStatus(String.format(Resources.errScanApp, this.archiveFile.getName()), null);
            }
        }
        catch (FileNotFoundException e) {
            return CloudPlugin.createErrorStatus(Resources.errExecScan, e);
        }
        catch (CoreException e) {
            return CloudPlugin.createErrorStatus(Resources.errExecScan, (Exception)((Object)e));
        }
        return Status.OK_STATUS;
    }

    private void createProblemMarkers(int returnCode) {
        String msg = this.scanOutput;
        try {
            if (msg == null || msg.length() == 0 || msg.indexOf("<log>") < 0) {
                if (msg != null && msg.length() > 65535) {
                    msg = msg.substring(0, 65000);
                }
                IMarker marker = this.project.createMarker("oracle.eclipse.tools.cloud.whitelist.problem");
                marker.setAttribute("severity", returnCode == 0 ? 1 : 2);
                marker.setAttribute("message", (Object)(String.valueOf(Resources.errorFoundOnProj) + "  \n" + msg));
                return;
            }
            if (!(msg = msg.substring(msg.indexOf("<log>"))).endsWith("</log>")) {
                msg = String.valueOf(msg) + "</log>";
            }
            Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)new StringInputStream(msg));
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPathExpression xPathExpression = xPath.compile(LOG_RECORD_MESSAGE_XPATH);
            NodeList nodes = (NodeList)xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
            int j = nodes.getLength();
            int i = 0;
            while (i < j) {
                String line = nodes.item(i).getTextContent();
                if (!line.startsWith("The Content validation on the file") || line.indexOf(".jar") >= 0) {
                    try {
                        IResource res = this.findResourceInProject(this.project, line);
                        if (res == null) {
                            res = this.project;
                        }
                        IMarker marker = res.createMarker("oracle.eclipse.tools.cloud.whitelist.problem");
                        marker.setAttribute("severity", 2);
                        marker.setAttribute("message", (Object)line);
                    }
                    catch (CoreException e) {
                        CloudPlugin.log((Exception)((Object)e));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            CloudPlugin.log(e);
        }
    }

    private IResource findResourceInProject(IProject proj, String msg) {
        int n = msg.indexOf("the file \"");
        if (n >= 0) {
            String fileName = msg.substring(n + "the file \"".length());
            int n2 = (fileName = fileName.substring(0, fileName.indexOf(34))).lastIndexOf(47);
            if (n2 > 0) {
                fileName = fileName.substring(n2 + 1);
                fileName = fileName.replaceAll(".class", ".java");
            }
            String theFileName = fileName;
            return this.findFile(proj, theFileName);
        }
        if (msg.indexOf(" Manifest ") > 0) {
            return this.findFile(proj, "MANIFEST.MF");
        }
        return proj;
    }

    private IFile findFile(IProject proj, final String theFileName) {
        final IFile[] foundFile = new IFile[]{null};
        try {
            proj.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        IFile f = (IFile)resource;
                        if (f.getName().equals(theFileName)) {
                            foundFile[0] = f;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
        if (foundFile[0] != null) {
            return foundFile[0];
        }
        return null;
    }

    private int executeScanner(List<String> cmdLine) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine);
            StringBuilder commandLineMsg = new StringBuilder();
            for (String s : cmdLine) {
                commandLineMsg.append(String.valueOf(s) + " ");
            }
            File workingDirectory = this.archiveFile.getAbsoluteFile().getParentFile();
            if (!workingDirectory.exists()) {
                throw new FileNotFoundException(String.valueOf(workingDirectory.getAbsolutePath()) + " not found at ");
            }
            processBuilder.directory(workingDirectory);
            Process process = processBuilder.start();
            HashMap<String, String> processAttrs = new HashMap<String, String>();
            processAttrs.put(IProcess.ATTR_PROCESS_TYPE, "java");
            processAttrs.put(IProcess.ATTR_CMDLINE, commandLineMsg.toString());
            String procName = "Oracle Cloud Whitelist Scanner Tool";
            Launch launch = new Launch(null, "run", null);
            launch.setAttribute("org.eclipse.debug.core.capture_output", "true");
            RuntimeProcess runtimeProcess = new RuntimeProcess((ILaunch)launch, process, procName, processAttrs){

                public boolean canTerminate() {
                    return false;
                }
            };
            while (!runtimeProcess.isTerminated()) {
                Thread.sleep(100L);
            }
            this.scanOutput = runtimeProcess.getStreamsProxy().getOutputStreamMonitor().getContents();
            int ret = runtimeProcess.getExitValue();
            return ret;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public String captureProcessOutput(String commandLineMsg, RuntimeProcess runtimeProcess) throws IOException {
        for (ICloudDeploymentListener listener : CloudPlugin.getDeploymentListener()) {
            listener.captureProcessOutput(commandLineMsg, runtimeProcess);
        }
        return "";
    }

    private String getJavaPath() {
        IOracleCloudTargetConfig config = this.cloudRuntime.getConfig();
        Path path = (Path)config.getJavaLocation().content();
        if (path != null && path.toFile().exists()) {
            return path.toPortableString();
        }
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall != null) {
            return vmInstall.getInstallLocation().getAbsolutePath();
        }
        return null;
    }

    private List<String> createCommandLine() throws FileNotFoundException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.getJavaPath() == null) {
            throw new FileNotFoundException(Resources.jreNotFound);
        }
        String javaPath = String.valueOf(this.getJavaPath()) + "/bin/java" + (WhitelistScanToolRunner.isWindows() ? ".exe" : "");
        File javaExe = new File(javaPath);
        if (!javaExe.exists()) {
            throw new FileNotFoundException(Resources.jreNotFound);
        }
        ret.add(javaExe.getAbsolutePath());
        File workingDirectory = this.archiveFile.getAbsoluteFile().getParentFile();
        if (!workingDirectory.exists()) {
            throw new FileNotFoundException(workingDirectory.getAbsolutePath());
        }
        ret.add("-jar");
        File wlscanJar = new File(JavaCloudServiceSdk.location(), "whitelist.jar");
        if (!wlscanJar.exists()) {
            throw new FileNotFoundException(String.valueOf(wlscanJar.getName()) + " not found at " + wlscanJar.getParent());
        }
        ret.add(wlscanJar.getAbsolutePath());
        ret.add(this.archiveFile.getAbsolutePath());
        if (OracleCloudTools.isDebugMode()) {
            for (String s : ret) {
                System.out.println(s);
            }
        }
        return ret;
    }

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static final class Resources
    extends NLS {
        public static String errExecScan;
        public static String errScanApp;
        public static String errorFoundOnProj;
        public static String jreNotFound;

        static {
            Resources.initializeMessages((String)WhitelistScanToolRunner.class.getName(), Resources.class);
        }
    }
}

