/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.server.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.IWhitelistScanner;
import oracle.eclipse.tools.cloud.server.internal.NuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.cloud.server.internal.WhitelistScanner;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;

public class NuviaqToolsFactory {
    private static NuviaqToolsFactory factory = null;
    private Map<OracleCloudRuntime, IWhitelistScanner> scannerCache = new HashMap<OracleCloudRuntime, IWhitelistScanner>();

    private NuviaqToolsFactory() {
    }

    public static synchronized NuviaqToolsFactory getInstance() {
        if (factory == null) {
            factory = new NuviaqToolsFactory();
        }
        return factory;
    }

    public IWhitelistScanner createWhitelistScanner(OracleCloudRuntime runtime) throws CoreException {
        try {
            if (this.scannerCache.get((Object)runtime) != null) {
                return this.scannerCache.get((Object)runtime);
            }
            WhitelistScanner ret = new WhitelistScanner(runtime);
            this.scannerCache.put(runtime, ret);
            return ret;
        }
        catch (Exception e) {
            String msg = "Error finding Cloud SDK classes";
            throw new CoreException(CloudPlugin.createErrorStatus(msg, e));
        }
        catch (Throwable e) {
            String msg = "Oracle Cloud SDK location specified in runtime properties is no longer valid";
            throw new CoreException(CloudPlugin.createErrorStatus(msg, new Exception(e.getMessage())));
        }
    }

    public IWhitelistScanner createWhitelistScanner(IProject project) throws CoreException {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt : facetedProject.getTargetedRuntimes()) {
            OracleCloudRuntime runtime;
            IRuntime srt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt);
            if (srt == null || (runtime = (OracleCloudRuntime)((Object)srt.loadAdapter(OracleCloudRuntime.class, (IProgressMonitor)new NullProgressMonitor()))) == null) continue;
            return this.createWhitelistScanner(runtime);
        }
        return null;
    }

    public synchronized INuviaqDeployer createDeployer() {
        return new NuviaqDeployer();
    }

    protected static Path getPluginPath(Bundle bundle) {
        try {
            URL installURL = bundle.getEntry("/");
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new Path(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static IPath getJarredPluginPath(Bundle bundle) {
        try {
            File file = FileLocator.getBundleFile((Bundle)bundle);
            return new Path(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void dispose(OracleCloudRuntime crt) {
        this.scannerCache.remove((Object)crt);
    }
}

