/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import org.eclipse.core.runtime.IProgressMonitor;

public class OPC131PortalWebUIParser {
    public static List<ServiceDesc> parse(CloudConnection connection, String responseBody, IProgressMonitor mon) {
        ICloudProfile profile = connection.profile();
        ArrayList<ServiceDesc> ret = new ArrayList<ServiceDesc>();
        int beginIndex = responseBody.indexOf("<table class=\"mysListReport\"");
        String serviceDetail = responseBody.substring(beginIndex);
        int endIndex = serviceDetail.indexOf("</table>");
        serviceDetail = serviceDetail.substring(0, endIndex);
        if (OracleCloudTools.isDebugCloudPortal()) {
            System.out.println(serviceDetail);
        }
        String baseUrl = (String)profile.getBaseUrl().content();
        String identityDoamin = (String)profile.getIdentityDomain().content();
        String dataCenter = (String)profile.getDataCenter().content();
        baseUrl = baseUrl.replace(".", "\\.");
        String serviceLinkPattern = String.format("https://console\\.%s\\." + baseUrl + "/em/faces/javaservice\\?serviceName=[\\w]*&identityGroup=%s", dataCenter, identityDoamin);
        Pattern emConsoleLink = Pattern.compile(serviceLinkPattern);
        Pattern serviceNamePattern = Pattern.compile("serviceName=[\\w]*&");
        Matcher linkMatch = emConsoleLink.matcher(serviceDetail);
        while (linkMatch.find()) {
            String linkText = linkMatch.group();
            Matcher jcsNameMatcher = serviceNamePattern.matcher(linkText);
            if (!jcsNameMatcher.find()) continue;
            String s = jcsNameMatcher.group();
            String name = s.substring("serviceName=".length(), s.length() - 1);
            if (OracleCloudTools.isDebugCloudPortal()) {
                System.err.println(name);
            }
            ret.add(new JavaServiceDesc(connection, name, linkText));
        }
        mon.worked(100);
        String dbBaseUrl = "oraclecloudapps\\.com";
        if (!baseUrl.equals("cloud\\.oracle\\.com")) {
            dbBaseUrl = baseUrl;
        }
        String apexLinkPattern = String.format("https://[\\w]*-%s\\.db\\.%s\\." + dbBaseUrl + "/apex/", identityDoamin, dataCenter);
        Pattern apexPattern = Pattern.compile(apexLinkPattern);
        Matcher dbNameMatcher = apexPattern.matcher(serviceDetail);
        while (dbNameMatcher.find()) {
            String linkText = dbNameMatcher.group();
            String name = linkText.substring("https://".length(), linkText.indexOf(45));
            if (OracleCloudTools.isDebugCloudPortal()) {
                System.err.println(name);
            }
            ret.add(new ServiceDesc(connection, name, ServiceDesc.TYPE.DB, linkText));
        }
        return ret;
    }
}

