/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudProfileUtils;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ConnectionState;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.util.MutableReference;

public class NewCloudProfileOpMethods {
    public static Status execute(final ICloudProfile op, final ProgressMonitor monitor) {
        final MutableReference status = new MutableReference();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor mon) throws CoreException {
                status.set((Object)NewCloudProfileOpMethods.runOps(op, monitor));
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            ws.run(wr, null, 1, ProgressMonitorBridge.create((ProgressMonitor)monitor));
        }
        catch (CoreException e) {
            return StatusBridge.create((IStatus)e.getStatus());
        }
        return (Status)status.get();
    }

    private static Status runOps(ICloudProfile newProfile, ProgressMonitor mon) {
        if (mon == null) {
            mon = new ProgressMonitor();
        }
        try {
            mon.worked(1);
            if (newProfile.parent() == null) {
                CloudConnection connection = OracleCloudTools.connect();
                ICloudProfile profile = connection.profile();
                profile.copy(newProfile);
                profile.setConnectionState(ConnectionState.CONNECTED);
                String newPassword = (String)newProfile.getPassword().content();
                profile.setPassword(newPassword);
                CloudProfileUtils.saveSecurePassword(profile, newPassword);
                profile.resource().save();
                connection.services().fetch(false, null);
            } else {
                newProfile.resource().save();
                String newPassword = (String)newProfile.getPassword().content();
                CloudProfileUtils.saveSecurePassword(newProfile, newPassword);
            }
            mon.done();
        }
        catch (Exception e) {
            return Status.createErrorStatus((Throwable)e);
        }
        return Status.createOkStatus();
    }
}

