/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import oracle.eclipse.tools.cloud.Debuggable;
import oracle.eclipse.tools.cloud.profile.CloudProfileConfigServices;
import oracle.eclipse.tools.cloud.profile.ConnectionState;
import oracle.eclipse.tools.cloud.profile.NewCloudProfileOpMethods;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ExecutableElement;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.DependsOn;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public interface ICloudProfile
extends Debuggable,
ExecutableElement {
    public static final ElementType TYPE = new ElementType(ICloudProfile.class);
    @Documentation(content="Unique Id of the Oracle Cloud connection")
    @Required
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, "Id");
    @Documentation(content="Name of the connection to the Oracle Cloud")
    @Label(standard="&connection name")
    @Required
    @DefaultValue(text="${ IdentityDomain }")
    public static final ValueProperty PROP_CONNECTION_NAME = new ValueProperty(TYPE, "ConnectionName");
    @Label(standard="&data center")
    @Required
    @Services(value={@Service(impl=CloudProfileConfigServices.DataCenterValueLabelService.class), @Service(impl=CloudProfileConfigServices.DataCenterPossibleValuesService.class)})
    @Documentation(content="The name of the Oracle Cloud data center. ")
    public static final ValueProperty PROP_DATA_CENTER = new ValueProperty(TYPE, "DataCenter");
    @Label(standard="&identity domain")
    @Required
    @Documentation(content="Identity Domains control authentication and authorization, i.e. who can login and what they can access once they login. ")
    public static final ValueProperty PROP_IDENTITY_DOMAIN = new ValueProperty(TYPE, "IdentityDomain");
    @Label(standard="&user name")
    @Required
    @Service(impl=CloudProfileConfigServices.UniqueConnectionalidationService.class)
    public static final ValueProperty PROP_USER = new ValueProperty(TYPE, "User");
    @Label(standard="&password")
    @Required
    @SensitiveData
    @DependsOn(value={"IdentityDomain", "User"})
    @CustomXmlValueBinding(impl=CloudProfileConfigServices.CloudPasswdDerivedValueService.class)
    public static final ValueProperty PROP_PASSWORD = new ValueProperty(TYPE, "Password");
    @Label(standard="&base url")
    @Required
    @DefaultValue(text="cloud.oracle.com")
    public static final ValueProperty PROP_BASE_URL = new ValueProperty(TYPE, "BaseUrl");
    @Label(standard="JCS administrative &endpoint")
    @Required
    @Service(impl=CloudProfileConfigServices.AdminUrlDefaultValueService.class)
    public static final ValueProperty PROP_ADMIN_URL = new ValueProperty(TYPE, "AdminUrl");
    @Label(standard="&Developer Cloud base url")
    @Required
    @DefaultValue(text="http://developer.us.oracle.com/")
    public static final ValueProperty PROP_DEV_CLOUD_BASE_URL = new ValueProperty(TYPE, "DevCloudBaseUrl");
    @Label(standard="Cloud porta&l URL")
    @Required
    @Service(impl=CloudProfileConfigServices.CloudPortalUrlDefaultValueService.class)
    public static final ValueProperty PROP_CLOUD_PORTAL_URL = new ValueProperty(TYPE, "CloudPortalUrl");
    @Label(standard="&state")
    @DefaultValue(text="UNKNOWN")
    @Type(base=ConnectionState.class)
    public static final ValueProperty PROP_CONNECTION_STATE = new ValueProperty(TYPE, "ConnectionState");

    public Value<String> getId();

    public void setId(String var1);

    public Value<String> getConnectionName();

    public void setConnectionName(String var1);

    public Value<String> getDataCenter();

    public void setDataCenter(String var1);

    public Value<String> getIdentityDomain();

    public void setIdentityDomain(String var1);

    public Value<String> getUser();

    public void setUser(String var1);

    public Value<String> getPassword();

    public void setPassword(String var1);

    public Value<String> getBaseUrl();

    public void setBaseUrl(String var1);

    public Value<String> getAdminUrl();

    public void setAdminUrl(String var1);

    public Value<String> getDevCloudBaseUrl();

    public void setDevCloudBaseUrl(String var1);

    public Value<String> getCloudPortalUrl();

    public void setCloudPortalUrl(String var1);

    public Value<ConnectionState> getConnectionState();

    public void setConnectionState(String var1);

    public void setConnectionState(ConnectionState var1);

    @DelegateImplementation(value=NewCloudProfileOpMethods.class)
    public Status execute(ProgressMonitor var1);
}

