/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import oracle.eclipse.tools.cloud.ApacheHttpClient;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.ServiceDesc;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.modeling.Status;

public abstract class CloudServiceClient {
    public static final String ERROR_UNSUPPORTED_VERSION = "Oracle.Cloud.UnsupportedVersion";
    String OAM_LOGON_URL = "/oam/server/auth_cred_submit";
    ApacheHttpClient client = null;
    protected CloudConnection connection;
    protected String user;
    protected String passwd;
    protected String identityDoamin;
    protected String dataCenter = "us1";

    public CloudServiceClient(ICloudProfile profile) {
        this.user = (String)profile.getUser().content();
        this.passwd = (String)profile.getPassword().content();
        this.identityDoamin = (String)profile.getIdentityDomain().content();
        this.dataCenter = (String)profile.getDataCenter().content();
    }

    public CloudServiceClient(CloudConnection connection) {
        this(connection.profile());
        this.connection = connection;
    }

    public abstract List<ServiceDesc> getServices(IProgressMonitor var1);

    public abstract Status validate(IProgressMonitor var1);

    protected ApacheHttpClient.ResponseData login(String cloudPortalUrl) {
        Proxy proxy = null;
        try {
            List<Proxy> proxyList = ProxySelector.getDefault().select(new URI(cloudPortalUrl));
            if (proxyList != null && proxyList.size() > 0) {
                proxy = proxyList.get(0);
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.client = new ApacheHttpClient(this.user, this.passwd, proxy);
        ApacheHttpClient.ResponseData rd = this.client.doGet(cloudPortalUrl);
        if (rd.statusCode != 200) {
            return rd;
        }
        String responseBody = rd.bodyText;
        if (OracleCloudTools.isDebugCloudPortal()) {
            System.out.println("\n" + responseBody);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", this.user);
        params.put("password", this.passwd);
        params.put("tenantName", this.identityDoamin);
        this.client.setRedirect();
        String loginUrl = String.valueOf(rd.redirectedHost) + this.OAM_LOGON_URL;
        rd = this.client.doPost(loginUrl, params);
        responseBody = rd.bodyText;
        if (responseBody.indexOf("form name=\"loginForm\" action=\"/oam/server/auth_cred_submit\"") > 0) {
            rd.statusCode = 401;
            return rd;
        }
        if (OracleCloudTools.isDebugCloudPortal()) {
            System.out.println("[Cloud Portal login succeeded]\n" + responseBody);
        }
        return rd;
    }
}

