/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.profile;

import java.util.Set;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.DataCenter;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.RemoteDataPossibleValuesService;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.services.ValueLabelService;

public final class CloudProfileConfigServices {

    public static final class AdminUrlDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    AdminUrlDefaultValueService.this.refresh();
                }
            };
            ICloudProfile config = (ICloudProfile)this.context(ICloudProfile.class);
            config.getDataCenter().attach((Listener)listener);
            config.getBaseUrl().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            String baseUrl;
            ICloudProfile config = (ICloudProfile)this.context(ICloudProfile.class);
            if (config.getDataCenter().content() == null) {
                return new DefaultValueServiceData("");
            }
            String dataCenter = config.getDataCenter().text();
            String baseAdminUrl = baseUrl = config.getBaseUrl().text();
            if (baseUrl.endsWith(config.getBaseUrl().getDefaultText())) {
                baseAdminUrl = "cloud.oracle.com";
            }
            String adminUrl = "https://javaservices." + dataCenter + "." + baseAdminUrl;
            return new DefaultValueServiceData(adminUrl);
        }
    }

    public static final class CloudPasswdDerivedValueService
    extends ValuePropertyBinding {
        String password = null;

        public String read() {
            return this.password;
        }

        public void write(String newPasswd) {
            this.password = newPasswd;
        }
    }

    public static final class CloudPortalUrlDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    CloudPortalUrlDefaultValueService.this.refresh();
                }
            };
            ICloudProfile config = (ICloudProfile)this.context(ICloudProfile.class);
            config.getDataCenter().attach((Listener)listener);
            config.getBaseUrl().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            ICloudProfile config = (ICloudProfile)this.context(ICloudProfile.class);
            String dataCenter = config.getDataCenter().text();
            if (dataCenter == null) {
                return new DefaultValueServiceData("");
            }
            String baseUrl = config.getBaseUrl().text();
            String pattern = "https://myservices.%s.%s/mycloud/f?p=my_services";
            String url = String.format(pattern, dataCenter, baseUrl);
            return new DefaultValueServiceData(url);
        }
    }

    public static final class DataCenterPossibleValuesService
    extends RemoteDataPossibleValuesService<Set<DataCenter>> {
        @Override
        protected RemoteData<Set<DataCenter>> remote() {
            return OracleCloudTools.getDataCenters();
        }

        @Override
        protected void fillPossibleValues(RemoteData<Set<DataCenter>> rd, Set<String> values) {
            for (DataCenter datacenter : rd.content()) {
                values.add(datacenter.id());
            }
        }
    }

    public static final class DataCenterValueLabelService
    extends ValueLabelService {
        public String provide(String value) {
            RemoteData<Set<DataCenter>> datacenters = OracleCloudTools.getDataCenters();
            if (datacenters.available()) {
                for (DataCenter datacenter : datacenters.content()) {
                    if (!datacenter.id().equals(value)) continue;
                    return datacenter.name();
                }
            }
            return value;
        }
    }

    public static final class UniqueConnectionalidationService
    extends ValidationService {
        protected Status compute() {
            ICloudProfile config = (ICloudProfile)this.context(ICloudProfile.class);
            if (config.getId().content() != null && config.getIdentityDomain().content() != null && config.getUser().content() != null) {
                for (CloudConnection connection : OracleCloudTools.connections()) {
                    ICloudProfile p = connection.profile();
                    if (p == config || p.getId().content() == null || ((String)p.getId().content()).equals(config.getId().content())) continue;
                    String idDomain = (String)p.getIdentityDomain().content();
                    String userName = (String)p.getUser().content();
                    if (!((String)config.getIdentityDomain().content()).equals(idDomain) || !((String)config.getUser().content()).equals(userName)) continue;
                    return Status.createErrorStatus((String)"An Oracle Cloud connection with specified user already exists for the selected identity domain");
                }
            }
            return Status.createOkStatus();
        }

        protected void initValidationService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    UniqueConnectionalidationService.this.refresh();
                }
            };
            ICloudProfile config = (ICloudProfile)this.context(ICloudProfile.class);
            config.getIdentityDomain().attach((Listener)listener);
        }
    }
}

