/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.maven.config;

import java.io.File;
import oracle.eclipse.tools.cloud.maven.MavenRunner;
import oracle.eclipse.tools.cloud.maven.config.IMavenSettingsModel;
import oracle.eclipse.tools.cloud.maven.config.IServer;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.FileResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class MavenSettingsModelFactory {
    public static IMavenSettingsModel getMavenProjectModel() {
        IMavenSettingsModel model = null;
        try {
            File m2Settings = MavenRunner.getUserMavenSettings();
            model = MavenSettingsModelFactory.load(m2Settings);
            if (!m2Settings.exists()) {
                model.resource().save();
            }
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
        return model;
    }

    public static IMavenSettingsModel load(File file) throws ResourceStoreException {
        return MavenSettingsModelFactory.load(new XmlResourceStore((ByteArrayResourceStore)new FileResourceStore(file)));
    }

    public static IMavenSettingsModel loadWorkspaceFile(IFile file) throws ResourceStoreException {
        return MavenSettingsModelFactory.load(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
    }

    public static IMavenSettingsModel load(XmlResourceStore resourceStore) {
        return (IMavenSettingsModel)IMavenSettingsModel.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
    }

    public static String getAuthProfileId(ICloudProfile devCloudTarget) {
        ICloudProfile config = devCloudTarget;
        String userName = (String)config.getUser().content();
        IMavenSettingsModel settingsModel = MavenSettingsModelFactory.getMavenProjectModel();
        ElementList<IServer> servers = settingsModel.getServers();
        for (IServer s : servers) {
            String user2;
            String user1 = (String)s.getUsername().content();
            if (!user1.equals(user2 = userName)) continue;
            return (String)s.getId().content();
        }
        IServer newServer = (IServer)servers.insert();
        String conn = (String)devCloudTarget.getConnectionName().content();
        conn = conn.replace(' ', '_');
        conn = conn.replace('/', '_');
        conn = conn.replace('\\', '_');
        conn = conn.replace(':', '_');
        newServer.setId(conn);
        newServer.setUsername((String)devCloudTarget.getUser().content());
        File securitySettingFile = MavenRunner.getMavenSecuritySettings();
        String passwd = (String)devCloudTarget.getPassword().content();
        if (!securitySettingFile.exists()) {
            newServer.setPassword(passwd);
        } else {
            String encryptedPasswd = MavenRunner.encryptPassword(passwd);
            newServer.setPassword(encryptedPasswd);
        }
        try {
            settingsModel.resource().save();
            return conn;
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

