/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import org.apache.maven.cli.MavenCli;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntime;

public class MavenRunner {
    private static Map<String, MavenRunner> runnersMap = new HashMap<String, MavenRunner>();
    private MavenCli cli = new MavenCli();
    private static final String WEB_DAV_POM_FILE = "webDav.pom";
    private static final String MAVEN_SETTINGS_XML_FILE = "settings.xml";
    private static final String MAVEN_SECURITY_SETTINGS_XML_FILE = "settings-security.xml";
    private static String MAVEN_SECURITY_SETTINGS_XML = "<settingsSecurity><master>%s</master></settingsSecurity>";

    public static synchronized MavenRunner getMavenRunner(IRuntime rt) {
        String id = rt != null ? rt.getId() : "DEFAULT";
        MavenRunner runner = runnersMap.get(id);
        if (runner == null) {
            runner = new MavenRunner();
            runnersMap.put(id, runner);
        }
        return runner;
    }

    public void install(IFile pomFile) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("clean");
        arguments.add("install");
        arguments.add("-Dproject.build.sourceEncoding=UTF-8");
        arguments.add("-DskipTests=true");
        this.run(arguments, pomFile.getParent().getLocation().toFile());
    }

    public void installFile(File file, String groupId, String jarId, String version) {
        List<String> arguments = this.getInstallCommand(file, groupId, jarId, version);
        this.run(arguments, file.getParentFile());
    }

    public int deployJar(File jarFile, String groupId, String jarId, String version, String remoteRepoUrl, String remoteRepoId) {
        List<String> arguments = this.getDeployJarCommand(jarFile, groupId, jarId, version, remoteRepoUrl, remoteRepoId);
        File webDavPom = MavenRunner.getWebDavPomXml();
        if (webDavPom != null && webDavPom.exists()) {
            File workingDir = webDavPom.getParentFile();
            return this.run(arguments, workingDir);
        }
        CloudPlugin.log(new Exception("Error: webDav POM not found"));
        return -1;
    }

    public List<String> getInstallCommand(File file, String groupId, String artifactId, String version) {
        String packageType = "jar";
        if (file.getName().endsWith(".xml")) {
            packageType = "pom";
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install:install-file");
        arguments.add("-Dfile=" + file.getAbsolutePath());
        arguments.add("-DgroupId=" + groupId);
        arguments.add("-DartifactId=" + artifactId.replace('.', '-'));
        arguments.add("-Dversion=" + version);
        arguments.add("-Dpackaging=" + packageType);
        return arguments;
    }

    public List<String> getDeployJarCommand(File file, String groupId, String artifactId, String version, String remoteRepoUrl, String remoteRepoId) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("deploy:deploy-file");
        arguments.add("-Dfile=" + file.getAbsolutePath());
        arguments.add("-DgroupId=" + groupId);
        arguments.add("-DartifactId=" + artifactId.replace('.', '-'));
        arguments.add("-Dversion=" + version);
        String packaging = file.getName().endsWith(".xml") ? "pom" : "jar";
        arguments.add("-Dpackaging=" + packaging);
        arguments.add("-Durl=" + remoteRepoUrl);
        arguments.add("-DrepositoryId=" + remoteRepoId);
        return arguments;
    }

    public int run(List<String> arguments, File workingDirectory) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            int n;
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.addAll(arguments);
            cmdLine.add("-B");
            String[] cmd = cmdLine.toArray(new String[cmdLine.size()]);
            StringBuilder cmdLineMsg = new StringBuilder();
            String[] stringArray = cmd;
            int n2 = cmd.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                cmdLineMsg.append(s);
                cmdLineMsg.append(" ");
                ++n3;
            }
            IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
            PrintStream os = new PrintStream(adapter.newMessageOutputStream(), false, Charset.defaultCharset().name());
            PrintStream es = new PrintStream(adapter.newMessageErrorStream(), false, Charset.defaultCharset().name());
            es.println("\n*******************************************************************************\n");
            es.printf("mvn %s%n", cmdLineMsg);
            es.println("\n*******************************************************************************\n");
            Thread.currentThread().setContextClassLoader(MavenCli.class.getClassLoader());
            int n4 = n = this.cli.doMain(cmd, workingDirectory.getAbsolutePath(), os, es);
            return n4;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return -1;
    }

    public static String generateMasterPassword() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.add("--encrypt-master-password");
            cmdLine.add("Welcome1");
            String[] cmd = cmdLine.toArray(new String[cmdLine.size()]);
            ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
            ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
            PrintStream os = new PrintStream((OutputStream)bos1, false, Charset.defaultCharset().name());
            PrintStream es = new PrintStream((OutputStream)bos2, false, Charset.defaultCharset().name());
            Thread.currentThread().setContextClassLoader(MavenCli.class.getClassLoader());
            File workDir = CloudPlugin.state().toFile();
            MavenCli cli = new MavenCli();
            cli.doMain(cmd, workDir.getAbsolutePath(), os, es);
            String string = new String(bos1.toByteArray(), Charset.defaultCharset());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return null;
    }

    public static String encryptPassword(String passwd) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ArrayList<String> cmdLine = new ArrayList<String>();
            cmdLine.add("--encrypt-password");
            cmdLine.add(passwd);
            String[] cmd = cmdLine.toArray(new String[cmdLine.size()]);
            ByteArrayOutputStream bos1 = new ByteArrayOutputStream();
            ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
            PrintStream os = new PrintStream((OutputStream)bos1, false, Charset.defaultCharset().name());
            PrintStream es = new PrintStream((OutputStream)bos2, false, Charset.defaultCharset().name());
            Thread.currentThread().setContextClassLoader(MavenCli.class.getClassLoader());
            File workDir = CloudPlugin.state().toFile();
            MavenCli cli = new MavenCli();
            cli.doMain(cmd, workDir.getAbsolutePath(), os, es);
            String string = new String(bos1.toByteArray(), Charset.defaultCharset());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        return null;
    }

    public static File getWebDavPomXml() {
        IPath path = CloudPlugin.state();
        File f = path.append("maven").append("webDav").toFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        File webDavPom = new File(f, "pom.xml");
        return MavenRunner.getSettingXml(webDavPom, WEB_DAV_POM_FILE);
    }

    public static File getUserMavenSettings() {
        String userHome = System.getProperty("user.home");
        File m2 = new File(userHome, ".m2");
        File mvnSetting = new File(m2, MAVEN_SETTINGS_XML_FILE);
        return MavenRunner.getSettingXml(mvnSetting, MAVEN_SETTINGS_XML_FILE);
    }

    public static File getSettingXml(File targetFile, String template) {
        try {
            if (!targetFile.exists()) {
                String packagePath = MavenRunner.class.getPackage().getName().replace('.', '/');
                ClassLoader cl = MavenRunner.class.getClassLoader();
                InputStream inputStream = cl.getResourceAsStream(String.valueOf(packagePath) + '/' + template);
                if (inputStream != null) {
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    try {
                        byte[] buf = new byte[256];
                        int n = inputStream.read(buf);
                        while (n > 0) {
                            fos.write(buf, 0, n);
                            n = inputStream.read(buf);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return targetFile;
        }
        catch (IOException e) {
            CloudPlugin.log(e);
            return null;
        }
    }

    public static File getMavenSecuritySettings() {
        String userHome = System.getProperty("user.home");
        File m2 = new File(userHome, ".m2");
        File mvnSecuritySetting = new File(m2, MAVEN_SECURITY_SETTINGS_XML_FILE);
        if (!mvnSecuritySetting.exists()) {
            String masterPasswd = MavenRunner.generateMasterPassword();
            String contents = String.format(MAVEN_SECURITY_SETTINGS_XML, masterPasswd);
            try {
                FileUtil.writeTextFile((File)mvnSecuritySetting, (String)contents);
                String msg = "Maven security setting file generated in user home directory:~/.m2/settings-security.xml";
                CloudPlugin.logInfo(msg);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return mvnSecuritySetting;
    }
}

