/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.log;

import java.io.File;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.log.IJobsLogQueryCriteria;
import oracle.eclipse.tools.cloud.log.IStatusEnumItem;
import oracle.eclipse.tools.cloud.log.Status;
import org.eclipse.core.resources.IFile;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class JobsLogQueryCriteriaFactory {
    public static IJobsLogQueryCriteria getInstance() {
        IJobsLogQueryCriteria logQueryCriteria = null;
        File stateLoc = CloudPlugin.state().toFile();
        try {
            File f = new File(stateLoc, "cloud-jobs-log-query-criteria.xml");
            logQueryCriteria = JobsLogQueryCriteriaFactory.load(f);
            if (!f.exists()) {
                logQueryCriteria.setLimit(100);
                Status[] statusArray = Status.values();
                int n = statusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Status sts = statusArray[n2];
                    IStatusEnumItem item = (IStatusEnumItem)logQueryCriteria.getStatus().insert();
                    item.setItem(sts);
                    ++n2;
                }
                logQueryCriteria.resource().save();
            }
        }
        catch (ResourceStoreException e) {
            CloudPlugin.log((Exception)((Object)e));
        }
        return logQueryCriteria;
    }

    public static IJobsLogQueryCriteria load(File file) throws ResourceStoreException {
        return JobsLogQueryCriteriaFactory.load(new XmlResourceStore(file));
    }

    public static IJobsLogQueryCriteria load(IFile file) throws ResourceStoreException {
        return JobsLogQueryCriteriaFactory.load(new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(file)));
    }

    public static IJobsLogQueryCriteria load(XmlResourceStore resourceStore) {
        return (IJobsLogQueryCriteria)IJobsLogQueryCriteria.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
    }
}

