/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java.internal;

import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.java.internal.HttpException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SSLProtocolSocketFactory;
import org.apache.commons.io.IOUtils;
import org.eclipse.sapphire.modeling.Path;

public class RestClientJCSCustomerScratch {
    private HttpClient httpClient = new HttpClient();
    private Proxy proxy = null;
    private String userName;
    private String passwd;
    private String proxyUserName = null;
    private String proxyPassword = null;
    private static final int MAX_RETRY = 5;
    private static final int WAIT_INTERVAL = 10000;
    private static final int CONNNECT_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 180000;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static ProtocolSocketFactory sslSocketFactory = new SSLProtocolSocketFactory();
    private static ProtocolSocketFactory socketFactory = new DefaultProtocolSocketFactory();
    private static final BitSet doNotEncode = new BitSet(256);
    private static final String HEXES = "0123456789ABCDEF";

    static {
        int i = 97;
        while (i <= 122) {
            doNotEncode.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            doNotEncode.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            doNotEncode.set(i);
            ++i;
        }
        doNotEncode.set(45);
        doNotEncode.set(95);
        doNotEncode.set(46);
        doNotEncode.set(42);
    }

    public RestClientJCSCustomerScratch(String userName, String passwd) {
        this.userName = userName;
        this.passwd = passwd;
    }

    private static void configureHttpClientConnectionManager(HttpClient client) {
        client.getHttpConnectionManager().getParams().setSoTimeout(180000);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        client.getHttpConnectionManager().getParams().setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 100);
        client.getHttpConnectionManager().getParams().setMaxTotalConnections(1000);
    }

    private static String getHost(String repositoryUrl) {
        String result = repositoryUrl;
        int colonSlashSlash = repositoryUrl.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = repositoryUrl.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    private static boolean isRepositoryHttps(String repositoryUrl) {
        return repositoryUrl.matches("https.*");
    }

    private static int getPort(String repositoryUrl) {
        int colonSlashSlash = repositoryUrl.indexOf("://");
        int firstSlash = repositoryUrl.indexOf("/", colonSlashSlash + 3);
        int colonPort = repositoryUrl.indexOf(58, colonSlashSlash + 1);
        if (firstSlash == -1) {
            firstSlash = repositoryUrl.length();
        }
        if (colonPort < 0 || colonPort > firstSlash) {
            return RestClientJCSCustomerScratch.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        int requestPath = repositoryUrl.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? repositoryUrl.length() : requestPath;
        String port = repositoryUrl.substring(colonPort + 1, end);
        if (port.length() == 0) {
            return RestClientJCSCustomerScratch.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        return Integer.parseInt(port);
    }

    private HostConfiguration createHostConfiguration(HttpClient client, String url) {
        Protocol protocol;
        String host = RestClientJCSCustomerScratch.getHost(url);
        int port = RestClientJCSCustomerScratch.getPort(url);
        RestClientJCSCustomerScratch.configureHttpClientConnectionManager(client);
        try {
            List<Proxy> proxyList = ProxySelector.getDefault().select(new URI(url));
            if (proxyList != null && proxyList.size() > 0) {
                this.proxy = proxyList.get(0);
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        client.getParams().setAuthenticationPreemptive(true);
        if (this.userName != null) {
            AuthScope authScope = new AuthScope(host, port, AuthScope.ANY_REALM);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.userName, this.passwd);
            client.getState().setCredentials(authScope, (Credentials)credentials);
        }
        HostConfiguration hostConfig = new HostConfiguration();
        if (this.proxy != null && !Proxy.NO_PROXY.equals(this.proxy)) {
            InetSocketAddress address = (InetSocketAddress)this.proxy.address();
            hostConfig.setProxy(address.getHostName(), address.getPort());
            if (this.proxyUserName != null) {
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUserName, this.proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                client.getState().setProxyCredentials(proxyAuthScope, (Credentials)proxyCredentials);
            }
        } else {
            hostConfig.setProxyHost(null);
        }
        if (RestClientJCSCustomerScratch.isRepositoryHttps(url)) {
            protocol = new Protocol("https", sslSocketFactory, 443);
            hostConfig.setHost(host, port, protocol);
        } else {
            protocol = new Protocol("http", socketFactory, 80);
            hostConfig.setHost(host, port, protocol);
        }
        return hostConfig;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] doGet(URI url, String type, String tenantName, Map<String, String> requestParams) throws HttpException {
        try {
            HostConfiguration hostConfig = this.createHostConfiguration(this.httpClient, url.toString());
            GetMethod method = new GetMethod(url.toString());
            method.setDoAuthentication(true);
            method.setRequestHeader("Content-Type", type);
            method.setRequestHeader("X-ID-TENANT-NAME", tenantName);
            try {
                byte[] byArray;
                int statusCode;
                if (requestParams != null && requestParams.size() > 0) {
                    ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                    for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                        params.add(new NameValuePair(entry.getKey(), entry.getValue()));
                    }
                    method.setQueryString(params.toArray(new NameValuePair[params.size()]));
                }
                if ((statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method)) != 200) {
                    int retry = 0;
                    while (statusCode == 409 && retry < 5) {
                        Thread.sleep(10000L);
                        ++retry;
                        statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                    }
                    if (statusCode != 200) {
                        throw new HttpException(method.getStatusLine().toString());
                    }
                }
                InputStream in = method.getResponseBodyAsStream();
                try {
                    byArray = IOUtils.toByteArray((InputStream)in);
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
                in.close();
                return byArray;
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doPost(URI url, String tenantName, Map<String, String> requestParams) throws HttpException {
        try {
            HostConfiguration hostConfig = this.createHostConfiguration(this.httpClient, url.toString());
            PostMethod method = new PostMethod(url.toString());
            method.setDoAuthentication(true);
            method.setRequestHeader("X-ID-TENANT-NAME", tenantName);
            ArrayList<StringPart> partsList = new ArrayList<StringPart>();
            if (requestParams != null && requestParams.size() > 0) {
                for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                    partsList.add(new StringPart(entry.getKey(), entry.getValue()));
                }
            }
            if (partsList.size() > 0) {
                Part[] parts = partsList.toArray(new Part[partsList.size()]);
                MultipartRequestEntity entity = new MultipartRequestEntity(parts, method.getParams());
                method.setRequestEntity((RequestEntity)entity);
            }
            try {
                int statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                if (statusCode != 201) {
                    int retry = 0;
                    while (true) {
                        if (statusCode != 409 || retry >= 5) {
                            if (statusCode == 201) break;
                            throw new HttpException(method.getStatusLine().toString());
                        }
                        Thread.sleep(10000L);
                        ++retry;
                        statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                    }
                }
                Header[] headerArray = method.getResponseHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return null;
                    }
                    Header header = headerArray[n2];
                    if ("Location".equals(header.getName())) {
                        String string = header.getValue();
                        return string;
                    }
                    ++n2;
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadContent(URI url, byte[] content, String tenantName) throws HttpException {
        try {
            HostConfiguration hostConfig = this.createHostConfiguration(this.httpClient, url.toString());
            PostMethod method = new PostMethod(url.toString());
            method.setDoAuthentication(true);
            method.setRequestHeader("X-ID-TENANT-NAME", tenantName);
            Part[] parts = new Part[]{new FilePart("file", (PartSource)new ByteArrayPartSource("file", content))};
            MultipartRequestEntity entity = new MultipartRequestEntity(parts, method.getParams());
            method.setRequestEntity((RequestEntity)entity);
            try {
                int statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                if (statusCode != 201) {
                    int retry = 0;
                    while (true) {
                        if (statusCode != 409 || retry >= 5) {
                            if (statusCode == 201) break;
                            throw new HttpException(method.getStatusLine().toString());
                        }
                        Thread.sleep(10000L);
                        ++retry;
                        statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                    }
                }
                Header[] headerArray = method.getResponseHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        throw new HttpException("Failed to create file " + url.toString());
                    }
                    Header header = headerArray[n2];
                    if ("Location".equals(header.getName())) {
                        String string = header.getValue();
                        return string;
                    }
                    ++n2;
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadFile(URI url, File file, String tenantName) throws HttpException {
        try {
            HostConfiguration hostConfig = this.createHostConfiguration(this.httpClient, url.toString());
            PostMethod method = new PostMethod(url.toString());
            method.setDoAuthentication(true);
            method.setRequestHeader("X-ID-TENANT-NAME", tenantName);
            FilePart filePart = new FilePart("file", file.getName(), file);
            Part[] parts = new Part[]{filePart};
            MultipartRequestEntity entity = new MultipartRequestEntity(parts, method.getParams());
            method.setRequestEntity((RequestEntity)entity);
            try {
                int statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                if (statusCode != 201) {
                    int retry = 0;
                    while (true) {
                        if (statusCode != 409 || retry >= 5) {
                            if (statusCode == 201) break;
                            throw new HttpException(method.getStatusLine().toString());
                        }
                        Thread.sleep(10000L);
                        ++retry;
                        statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                    }
                }
                Header[] headerArray = method.getResponseHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        throw new HttpException("Failed to create file " + url.toString());
                    }
                    Header header = headerArray[n2];
                    if ("Location".equals(header.getName())) {
                        String string = header.getValue();
                        return string;
                    }
                    ++n2;
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        catch (HttpException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpException(e);
        }
    }

    public String doDelete(URI url, String tenantName) throws HttpException {
        return this.doDelete(url, tenantName, true);
    }

    public String doDelete(URI url, String tenantName, boolean force) throws HttpException {
        DeleteMethod method;
        block8: {
            HostConfiguration hostConfig = this.createHostConfiguration(this.httpClient, url.toString());
            method = new DeleteMethod(url.toString());
            method.setDoAuthentication(true);
            method.setRequestHeader("X-ID-TENANT-NAME", tenantName);
            if (force) {
                NameValuePair p = new NameValuePair("recursive", "true");
                method.setQueryString(new NameValuePair[]{p});
            }
            try {
                int statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                if (statusCode == 204) break block8;
                while (statusCode == 409) {
                    Thread.sleep(30000L);
                    statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                }
                if (statusCode == 204) break block8;
                String msg = String.valueOf(method.getStatusLine().toString()) + "\n" + method.getResponseBodyAsString();
                throw new HttpException(msg);
            }
            catch (Throwable throwable) {
                try {
                    method.releaseConnection();
                    throw throwable;
                }
                catch (HttpException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new HttpException(e);
                }
            }
        }
        method.releaseConnection();
        return null;
    }

    public String doPut(URI url, String tenantName, Map<String, String> requestParams) throws HttpException {
        PutMethod method;
        block10: {
            HostConfiguration hostConfig = this.createHostConfiguration(this.httpClient, url.toString());
            method = new PutMethod(url.toString());
            method.setDoAuthentication(true);
            method.setRequestHeader("X-ID-TENANT-NAME", tenantName);
            ArrayList<StringPart> partsList = new ArrayList<StringPart>();
            if (requestParams != null && requestParams.size() > 0) {
                for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                    partsList.add(new StringPart(entry.getKey(), entry.getValue()));
                }
            }
            if (partsList.size() > 0) {
                Part[] parts = partsList.toArray(new Part[partsList.size()]);
                MultipartRequestEntity entity = new MultipartRequestEntity(parts, method.getParams());
                method.setRequestEntity((RequestEntity)entity);
            }
            try {
                int statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                if (statusCode == 201) break block10;
                while (statusCode == 409) {
                    Thread.sleep(30000L);
                    statusCode = this.httpClient.executeMethod(hostConfig, (HttpMethod)method);
                }
                if (statusCode == 201) break block10;
                throw new HttpException(method.getStatusLine().toString());
            }
            catch (Throwable throwable) {
                try {
                    method.releaseConnection();
                    throw throwable;
                }
                catch (HttpException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new HttpException(e);
                }
            }
        }
        method.releaseConnection();
        return null;
    }

    public byte[] getContent(String url, String tenant, String path, String type, Map<String, String> map) {
        try {
            URI uri = new URI(String.valueOf(url) + (path != null ? path : ""));
            byte[] content = this.doGet(uri, type, tenant, map);
            return content;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (HttpException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String encode(Path path) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = path.segmentCount();
        while (i < n) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(RestClientJCSCustomerScratch.encode(path.segment(i)));
            ++i;
        }
        return buf.toString();
    }

    public static String encode(String string) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = string.length();
        while (i < n) {
            char ch = string.charAt(i);
            if (doNotEncode.get(ch)) {
                buf.append(ch);
            } else {
                buf.append('%');
                byte[] byArray = String.valueOf(ch).getBytes(StandardCharsets.UTF_8);
                int n2 = byArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    byte b = byArray[n3];
                    buf.append(HEXES.charAt((b & 0xF0) >> 4));
                    buf.append(HEXES.charAt(b & 0xF));
                    ++n3;
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

