/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.java.WorkspaceFile;
import oracle.eclipse.tools.cloud.java.WorkspaceFolder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.util.ListFactory;

public abstract class WorkspaceContainer
extends FolderFacade {
    private final IContainer base;

    protected WorkspaceContainer(WorkspaceContainer parent, IContainer base) {
        super(parent, base.getName(), null);
        this.base = base;
    }

    public IContainer base() {
        return this.base;
    }

    @Override
    protected Members createMembers() {
        return new Members(this);
    }

    @Override
    protected final void renameResource(String newName) {
        try {
            this.base.move(this.base.getLocation().removeFirstSegments(1).append(newName), true, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() {
        for (ResourceFacade member : (List)this.members().content()) {
            member.delete();
        }
        try {
            this.base.delete(true, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.parent().members().fetch();
    }

    private static final class Members
    extends FolderFacade.Members {
        private Map<String, ResourceFacade> cache;

        public Members(WorkspaceContainer folder) {
            super(folder, null);
        }

        @Override
        protected List<ResourceFacade> read() throws Exception {
            WorkspaceContainer folder = (WorkspaceContainer)this.folder();
            ListFactory membersListFactory = ListFactory.start();
            HashMap<String, ResourceFacade> newCache = new HashMap<String, ResourceFacade>();
            IResource[] iResourceArray = folder.base().members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                String name = child.getName();
                ResourceFacade resource = null;
                if (this.cache != null) {
                    resource = this.cache.get(name);
                }
                if (child instanceof IFolder) {
                    if (!(resource instanceof WorkspaceContainer)) {
                        resource = new WorkspaceFolder(folder, (IFolder)child);
                    }
                } else if (!(resource instanceof WorkspaceFile)) {
                    resource = new WorkspaceFile(folder, (IFile)child);
                }
                membersListFactory.add((Object)resource);
                newCache.put(name, resource);
                ++n2;
            }
            this.flush(newCache);
            return membersListFactory.result();
        }

        private void flush(Map<String, ResourceFacade> newCache) {
            if (this.cache != null) {
                for (Map.Entry<String, ResourceFacade> entry : this.cache.entrySet()) {
                    String name = entry.getKey();
                    ResourceFacade resource = entry.getValue();
                    if (resource == newCache.get(name)) continue;
                    resource.dispose();
                }
            }
            this.cache = newCache;
        }
    }
}

