/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.java.FolderFacade;
import oracle.eclipse.tools.cloud.java.JavaServiceFile;
import oracle.eclipse.tools.cloud.java.JavaServiceFileSystem;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import oracle.eclipse.tools.cloud.java.internal.RestClientJCSCustomerScratch;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import oracle.eclipse.tools.common.util.DomUtil;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.util.ListFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaServiceFolder
extends FolderFacade {
    JavaServiceFolder(JavaServiceFolder parent, String name, String modified) {
        super(parent, name, modified);
    }

    @Override
    protected Members createMembers() {
        return new Members(this);
    }

    void update(Element metadata) {
        super.update(DomUtil.text((Node)DomUtil.element((Element)metadata, (String)"modifiedOn")));
    }

    @Override
    public JavaServiceFileSystem root() {
        return (JavaServiceFileSystem)super.root();
    }

    @Override
    protected void createFolder(String name) {
        Path path = this.path().append(name);
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(path));
            fs.client().doPost(uri, fs.tenant(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid folder name \"" + path.toPortableString() + "\"", e);
        }
    }

    @Override
    protected void createFile(String name) {
        Path path = this.path().append(name);
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(path));
            fs.client().uploadContent(uri, new byte[0], fs.tenant());
        }
        catch (Exception e) {
            throw new RuntimeException("Error create file \"" + path.toPortableString() + "\"", e);
        }
    }

    @Override
    protected final void renameResource(String newName) {
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + this.path() + "?dest=" + RestClientJCSCustomerScratch.encode(newName));
            fs.client().doPut(uri, fs.tenant(), null);
        }
        catch (Exception e) {
            throw new RuntimeException("Error renaming file \"" + this.name() + "\". " + e.getMessage(), e);
        }
    }

    @Override
    public void delete() {
        try {
            JavaServiceFileSystem fs = this.root();
            URI uri = new URI(String.valueOf(fs.url()) + RestClientJCSCustomerScratch.encode(this.path()));
            boolean recursive = true;
            fs.client().doDelete(uri, fs.tenant(), recursive);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.parent().members().fetch();
    }

    private static final class Members
    extends FolderFacade.Members {
        private Map<String, ResourceFacade> cache;

        public Members(JavaServiceFolder folder) {
            super(folder, new Serializer());
        }

        @Override
        protected List<ResourceFacade> read() throws Exception {
            JavaServiceFolder folder = (JavaServiceFolder)this.folder();
            JavaServiceFileSystem fs = folder.root();
            ListFactory membersListFactory = ListFactory.start();
            byte[] ret = fs.client().getContent(fs.url(), fs.tenant(), RestClientJCSCustomerScratch.encode(folder.path()), "application/xml", null);
            String xml = new String(ret, StandardCharsets.UTF_8);
            Element root = DomUtil.root((String)xml);
            if (root.getNodeName().equals("Exception")) {
                throw new RuntimeException();
            }
            NodeList list = root.getChildNodes();
            HashMap<String, ResourceFacade> newCache = new HashMap<String, ResourceFacade>();
            int i = 0;
            int n = list.getLength();
            while (i < n) {
                Node node = list.item(i);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    String name = DomUtil.text((Node)DomUtil.element((Element)element, (String)"name"));
                    ResourceFacade resource = null;
                    if (this.cache != null) {
                        resource = this.cache.get(name);
                    }
                    if (DomUtil.text((Node)DomUtil.element((Element)element, (String)"type")).endsWith("application/vnd.opc.directory")) {
                        if (!(resource instanceof JavaServiceFolder)) {
                            resource = new JavaServiceFolder(folder, name, null);
                        }
                        ((JavaServiceFolder)resource).update(element);
                    } else {
                        if (!(resource instanceof JavaServiceFile)) {
                            resource = new JavaServiceFile(folder, name, null, null, -1L);
                        }
                        ((JavaServiceFile)resource).update(element);
                    }
                    membersListFactory.add((Object)resource);
                    newCache.put(name, resource);
                }
                ++i;
            }
            this.flush(newCache);
            return membersListFactory.result();
        }

        private void flush(Map<String, ResourceFacade> newCache) {
            if (this.cache != null) {
                for (Map.Entry<String, ResourceFacade> entry : this.cache.entrySet()) {
                    String name = entry.getKey();
                    ResourceFacade resource = entry.getValue();
                    if (resource == newCache.get(name)) continue;
                    resource.dispose();
                }
            }
            this.cache = newCache;
        }
    }

    private static final class Serializer
    extends RemoteData.Serializer<List<ResourceFacade>> {
        private Serializer() {
        }

        @Override
        public String id() {
            StringBuilder buf = new StringBuilder();
            Members context = (Members)this.context();
            JavaServiceFolder folder = (JavaServiceFolder)context.folder();
            OracleCloudRuntime service = folder.root().service();
            buf.append(service.connection().name());
            buf.append('/');
            buf.append(service.getName());
            buf.append('/');
            buf.append(folder.path().toPortableString());
            return buf.toString();
        }

        @Override
        public List<ResourceFacade> read(InputStream stream) throws Exception {
            Members context = (Members)this.context();
            JavaServiceFolder folder = (JavaServiceFolder)context.folder();
            ObjectInputStream st = new ObjectInputStream(stream);
            ListFactory membersListFactory = ListFactory.start();
            HashMap<String, ResourceFacade> newCache = new HashMap<String, ResourceFacade>();
            int size = st.readInt();
            int i = 0;
            while (i < size) {
                byte kind = st.readByte();
                String name = st.readUTF();
                String modified = st.readUTF();
                ResourceFacade resource = null;
                if (context.cache != null) {
                    resource = (ResourceFacade)context.cache.get(name);
                }
                if (kind == 0) {
                    String fileType = st.readUTF();
                    long fileSize = st.readLong();
                    if (resource instanceof JavaServiceFile) {
                        ((JavaServiceFile)resource).update(modified, fileType, fileSize);
                    } else {
                        resource = new JavaServiceFile(folder, name, modified, fileType, fileSize);
                    }
                } else if (resource instanceof JavaServiceFolder) {
                    ((JavaServiceFolder)resource).update(modified);
                } else {
                    resource = new JavaServiceFolder(folder, name, modified);
                }
                membersListFactory.add((Object)resource);
                newCache.put(name, resource);
                ++i;
            }
            context.flush(newCache);
            return membersListFactory.result();
        }

        @Override
        public void write(List<ResourceFacade> data, OutputStream stream) throws Exception {
            ObjectOutputStream st = new ObjectOutputStream(stream);
            st.writeInt(data.size());
            for (ResourceFacade resource : data) {
                if (resource instanceof JavaServiceFile) {
                    JavaServiceFile file = (JavaServiceFile)resource;
                    st.writeByte(0);
                    st.writeUTF(file.name());
                    st.writeUTF(file.modified());
                    st.writeUTF(file.type());
                    st.writeLong(file.size());
                    continue;
                }
                JavaServiceFolder folder = (JavaServiceFolder)resource;
                st.writeByte(1);
                st.writeUTF(folder.name());
                st.writeUTF(folder.modified());
            }
            st.flush();
        }
    }
}

