/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import oracle.eclipse.tools.cloud.java.JavaServiceFolder;
import oracle.eclipse.tools.cloud.java.internal.RestClientJCSCustomerScratch;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;

public final class JavaServiceFileSystem
extends JavaServiceFolder {
    private final OracleCloudRuntime runtime;
    private final String url;

    public JavaServiceFileSystem(OracleCloudRuntime runtime) {
        super(null, "", null);
        this.runtime = runtime;
        String adminUrl = runtime.getAdminUrl();
        if (!adminUrl.endsWith("/")) {
            adminUrl = String.valueOf(adminUrl) + '/';
        }
        this.url = String.valueOf(adminUrl) + "paas/java/v13.2/" + runtime.getTenantName() + "/" + runtime.getServiceName() + "/files/";
    }

    public OracleCloudRuntime service() {
        return this.runtime;
    }

    String url() {
        return this.url;
    }

    String tenant() {
        return this.runtime.getTenantName();
    }

    RestClientJCSCustomerScratch client() {
        return new RestClientJCSCustomerScratch(this.runtime.getUserName(), this.runtime.getPassword());
    }

    @Override
    public JavaServiceFileSystem root() {
        return this;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

