/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.util.List;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.java.JavaServiceDataSource;
import oracle.eclipse.tools.cloud.server.internal.INuviaqDeployer;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public final class JavaServiceDataSources
extends RemoteData<List<JavaServiceDataSource>> {
    private final OracleCloudRuntime cloudRuntime;

    public JavaServiceDataSources(OracleCloudRuntime runtime) {
        super("data sources");
        this.cloudRuntime = runtime;
    }

    public IServer getServer() {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getRuntime() == this.cloudRuntime.getRuntime()) {
                return server;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected List<JavaServiceDataSource> read() throws Exception {
        ListFactory membersListFactory = ListFactory.start();
        try {
            INuviaqDeployer deployer = this.cloudRuntime.getNuviaqDeployer();
            List<String> dataSources = deployer.listDataSources();
            for (String name : dataSources) {
                JavaServiceDataSource m = new JavaServiceDataSource(name, this);
                membersListFactory.add((Object)m);
            }
        }
        catch (Exception exception) {}
        return membersListFactory.result();
    }
}

