/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.java;

import java.util.List;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.java.ConflictResolver;
import oracle.eclipse.tools.cloud.java.FileFacade;
import oracle.eclipse.tools.cloud.java.ResourceFacade;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class FolderFacade
extends ResourceFacade {
    private final Members members = this.createMembers();

    protected FolderFacade(FolderFacade parent, String name, String modified) {
        super(parent, name, modified);
    }

    public final Members members() {
        return this.members;
    }

    public final ResourceFacade member(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        for (ResourceFacade member : (List)this.members().content()) {
            if (!member.name().equals(name)) continue;
            return member;
        }
        return null;
    }

    protected abstract Members createMembers();

    public final boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        for (ResourceFacade member : (List)this.members().content()) {
            if (!member.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final FolderFacade folder(String name) {
        return this.folder(name, false);
    }

    public final FolderFacade folder(String name, boolean createIfNecessary) {
        FolderFacade folder = null;
        for (ResourceFacade resource : (List)this.members().content()) {
            if (!resource.name().equals(name)) continue;
            if (resource instanceof FolderFacade) {
                folder = (FolderFacade)resource;
                break;
            }
            throw new IllegalArgumentException("File " + name + " already exists.");
        }
        if (folder == null && createIfNecessary) {
            if (name.length() > 0) {
                this.createFolder(name);
            }
            this.members().fetch();
            folder = name.length() > 0 ? this.folder(name, false) : this;
        }
        return folder;
    }

    protected abstract void createFolder(String var1);

    public final FileFacade file(String name) {
        return this.file(name, false);
    }

    public final FileFacade file(String name, boolean createIfNecessary) {
        FileFacade file = null;
        for (ResourceFacade resource : (List)this.members().content()) {
            if (!resource.name().equals(name)) continue;
            if (resource instanceof FileFacade) {
                file = (FileFacade)resource;
                break;
            }
            throw new IllegalArgumentException("Folder " + name + " already exists.");
        }
        if (file == null && createIfNecessary) {
            this.createFile(name);
            this.members().fetch();
            file = this.file(name, false);
        }
        return file;
    }

    protected abstract void createFile(String var1);

    @Override
    public final FolderFacade copy(FolderFacade destination, String name, ConflictResolver conflictResolver, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new RuntimeException("Copy operation is canceled");
        }
        if (destination == null) {
            throw new IllegalArgumentException();
        }
        if (conflictResolver == null) {
            conflictResolver = new ConflictResolver();
        }
        destination.members().fetch();
        if (monitor.isCanceled()) {
            throw new RuntimeException("Copy operation is canceled");
        }
        String n = name == null ? this.name() : name;
        ResourceFacade existing = destination.member(n);
        if (existing != null) {
            ConflictResolver.Resolution resolution = conflictResolver.resolve(destination.path().append(n));
            if (resolution == ConflictResolver.Resolution.SKIP || resolution == ConflictResolver.Resolution.ABORT) {
                return null;
            }
            if (resolution == ConflictResolver.Resolution.OVERWRITE) {
                if (existing instanceof FileFacade) {
                    existing.delete();
                }
            } else {
                throw new IllegalStateException();
            }
        }
        this.members.fetch();
        FolderFacade folder = destination.folder(n, true);
        for (ResourceFacade child : (List)this.members.content()) {
            if (monitor.isCanceled()) {
                return folder;
            }
            monitor.setTaskName("Copying " + child.name());
            child.copy(folder, conflictResolver, monitor);
            if (!conflictResolver.aborted()) continue;
            return folder;
        }
        return folder;
    }

    @Override
    public void dispose() {
        this.members.dispose();
    }

    public static abstract class Members
    extends RemoteData<List<ResourceFacade>> {
        private final FolderFacade folder;

        protected Members(FolderFacade folder, RemoteData.Serializer<List<ResourceFacade>> serializer) {
            super("folder members", serializer);
            this.folder = folder;
        }

        public final FolderFacade folder() {
            return this.folder;
        }
    }
}

