/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudProfileUtils;
import oracle.eclipse.tools.cloud.IOracleCloudTargetConfig;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.cloud.profile.JavaServiceDesc;
import oracle.eclipse.tools.cloud.server.internal.OracleCloudRuntime;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.DerivedValueServiceData;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.wst.server.core.IRuntime;

public final class OracleCloudTargetConfigServices {

    public static final class CloudProfileJavaVersionValidationService
    extends ValidationService {
        protected Status compute() {
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            if (config.getJavaLocation().content() == null) {
                return Status.createErrorStatus((String)"Oracle Java Cloud Service supports up to Java 6. Please specify a supported Java location.");
            }
            return Status.createOkStatus();
        }

        public void updateDropdownList() {
            this.refresh();
        }
    }

    public static final class CloudProfileLabelService1
    extends ValueLabelService {
        public String provide(String value) {
            for (CloudConnection connection : OracleCloudTools.connections()) {
                ICloudProfile p = connection.profile();
                if (!((String)p.getId().content()).equals(value)) continue;
                String connName = (String)p.getConnectionName().content();
                String idDomain = (String)p.getIdentityDomain().content();
                String user = (String)p.getUser().content();
                if (connName.contains("[" + idDomain + "." + user + "]")) {
                    return String.valueOf(connName) + " [" + idDomain + "." + user + "]";
                }
                return connName;
            }
            return null;
        }
    }

    public static final class CloudProfileValueService
    extends PossibleValuesService {
        protected void fillPossibleValues(Set<String> values) {
            for (CloudConnection connection : OracleCloudTools.connections()) {
                String id = (String)connection.profile().getId().content();
                values.add(id);
            }
        }

        public void updateDropdownList() {
            this.broadcast();
        }
    }

    public static final class DebugModeDerivedValueService
    extends DerivedValueService {
        protected DerivedValueServiceData compute() {
            return new DerivedValueServiceData(String.valueOf(OracleCloudTools.isDebugMode()));
        }
    }

    public static final class JavaServiceNameDefaultValueService
    extends DefaultValueService {
        protected DefaultValueServiceData compute() {
            String jcsName = System.getProperty("Oracle.Cloud.JavaInstanceName");
            if (jcsName != null) {
                String[] val = jcsName.split(",");
                return new DefaultValueServiceData(val[0]);
            }
            return new DefaultValueServiceData("");
        }
    }

    public static final class JavaServiceNameValueService
    extends PossibleValuesService {
        protected void init() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)JavaServiceNameValueService.this.context(IOracleCloudTargetConfig.class);
                    config.setService(null);
                    JavaServiceNameValueService.this.broadcast();
                }
            };
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            config.getProfileId().attach((Listener)listener);
        }

        protected void fillPossibleValues(Set<String> values) {
            CloudConnection connection;
            IOracleCloudTargetConfig config;
            String profileId;
            values.clear();
            String jcsName = System.getProperty("Oracle.Cloud.JavaInstanceName");
            if (jcsName != null) {
                String[] stringArray = jcsName.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    values.add(s);
                    ++n2;
                }
            }
            if ((profileId = (config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class)).getProfileId().text()) != null && profileId.length() > 0 && (connection = OracleCloudTools.connection(profileId)) != null) {
                try {
                    for (Object service : (List)connection.services().content()) {
                        if (!(service instanceof JavaServiceDesc)) continue;
                        values.add(((JavaServiceDesc)service).getName());
                    }
                }
                catch (Exception exception) {}
            }
        }

        public void updateDropdownList() {
            this.broadcast();
        }
    }

    public static final class NameDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    NameDefaultValueService.this.refresh();
                }
            };
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            config.getService().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            CloudConnection connection = OracleCloudTools.connection(config.getProfileId().text());
            if (connection == null) {
                return new DefaultValueServiceData("");
            }
            String tenant = connection.profile().getIdentityDomain().text();
            String service = config.getService().text();
            String name = OracleCloudTools.RUNTIME_TYPE.getName();
            if (service != null || tenant != null) {
                name = String.valueOf(name) + " (" + tenant + "-" + service + ")";
            }
            return new DefaultValueServiceData(name);
        }
    }

    public static final class ProfileNameDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    ProfileNameDefaultValueService.this.refresh();
                }
            };
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            config.getService().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            String name = "";
            Iterator<CloudConnection> iterator = OracleCloudTools.connections().iterator();
            if (iterator.hasNext()) {
                CloudConnection connection = iterator.next();
                ICloudProfile p = connection.profile();
                String connName = (String)p.getConnectionName().content();
                String idDomain = (String)p.getIdentityDomain().content();
                name = String.valueOf(connName) + " [" + idDomain + "]";
                return new DefaultValueServiceData(name);
            }
            return new DefaultValueServiceData(name);
        }
    }

    public static final class ServiceUrlDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    ServiceUrlDefaultValueService.this.refresh();
                }
            };
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            config.getService().attach((Listener)listener);
        }

        protected DefaultValueServiceData compute() {
            IOracleCloudTargetConfig config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class);
            CloudConnection connection = OracleCloudTools.connection(config.getProfileId().text());
            if (connection == null) {
                return new DefaultValueServiceData("");
            }
            ICloudProfile profile = connection.profile();
            String baseUrl = (String)profile.getBaseUrl().content();
            if (baseUrl == null) {
                return new DefaultValueServiceData("");
            }
            String dataCenter = profile.getDataCenter().text();
            String tenant = profile.getIdentityDomain().text();
            String service = config.getService().text();
            String name = "https://" + (service == null ? "" : service) + "-" + tenant + ".java." + dataCenter + '.' + baseUrl;
            return new DefaultValueServiceData(name);
        }

        public void refreshControl() {
            this.refresh();
        }
    }

    public static final class UniqueJcsInstanceValidationService
    extends ValidationService {
        protected Status compute() {
            OracleCloudRuntime.ConfigResource res;
            IOracleCloudTargetConfig config;
            String profileId;
            IRuntime runtime;
            Value name = (Value)this.context(Value.class);
            if (name.text() != null && (runtime = CloudProfileUtils.findServerRuntimeForProfile(profileId = (config = (IOracleCloudTargetConfig)this.context(IOracleCloudTargetConfig.class)).getProfileId().text(), name.text())) != null && (res = (OracleCloudRuntime.ConfigResource)config.resource()).getRuntimeWorkingCopy().getOriginal() != runtime) {
                return Status.createErrorStatus((String)"A server runtime for the specified Oracle Cloud Java Service already exists.");
            }
            return Status.createOkStatus();
        }
    }
}

