/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Set;
import oracle.eclipse.tools.cloud.DataCenter;
import oracle.eclipse.tools.cloud.RemoteData;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.util.SetFactory;

public final class DataCenters
extends RemoteData<Set<DataCenter>> {
    @Text(value="data centers")
    private static LocalizableText label;

    static {
        LocalizableText.init(DataCenters.class);
    }

    public DataCenters() {
        super(label.text(), new DataCentersSerializer());
    }

    @Override
    protected Set<DataCenter> read() throws Exception {
        XmlResourceStore store;
        URL url = new URL("https://cloud.oracle.com/datacenters.xml");
        InputStream stream = url.openStream();
        try {
            store = new XmlResourceStore(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        XmlElement root = new XmlElement(store, store.getDomDocument().getDocumentElement());
        SetFactory dataCentersSetFactory = SetFactory.start();
        for (XmlElement element : root.getChildElements("DataCenter")) {
            String id = element.getChildNodeText("ShortName");
            String name = element.getChildNodeText("LongName");
            String version = element.getChildNodeText("Services/Portal/@version");
            if (!version.equals("13.2") || id.length() <= 0 || name.length() <= 0) continue;
            dataCentersSetFactory.add((Object)new DataCenter(id, name));
        }
        return dataCentersSetFactory.result();
    }

    private static final class DataCentersSerializer
    extends RemoteData.Serializer<Set<DataCenter>> {
        private DataCentersSerializer() {
        }

        @Override
        public String id() {
            return "datacenters";
        }

        @Override
        public Set<DataCenter> read(InputStream stream) throws Exception {
            ObjectInputStream st = new ObjectInputStream(stream);
            SetFactory dataCentersSetFactory = SetFactory.start();
            int size = st.readInt();
            int i = 0;
            while (i < size) {
                String id = st.readUTF();
                String name = st.readUTF();
                dataCentersSetFactory.add((Object)new DataCenter(id, name));
                ++i;
            }
            return dataCentersSetFactory.result();
        }

        @Override
        public void write(Set<DataCenter> datacenters, OutputStream stream) throws Exception {
            ObjectOutputStream st = new ObjectOutputStream(stream);
            st.writeInt(datacenters.size());
            for (DataCenter datacenter : datacenters) {
                st.writeUTF(datacenter.id());
                st.writeUTF(datacenter.name());
            }
            st.flush();
        }
    }
}

