/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.internal;

import oracle.eclipse.tools.cloud.ICreateProjectOp;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.ValidationService;

public final class CreateProjectOpServices {

    public static final class LocationDefaultValueService
    extends DefaultValueService {
        protected void initDefaultValueService() {
            ((ICreateProjectOp)this.context(ICreateProjectOp.class)).getName().attach((Listener)new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    LocationDefaultValueService.this.refresh();
                }
            });
        }

        protected DefaultValueServiceData compute() {
            IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            ICreateProjectOp op = (ICreateProjectOp)this.context(ICreateProjectOp.class);
            String name = op.getName().text();
            if (name != null) {
                path = path.append(name);
            }
            return new DefaultValueServiceData(path.toOSString());
        }
    }

    public static final class NameValidationService
    extends ValidationService {
        protected Status compute() {
            String name = ((Value)this.context(Value.class)).text();
            if (name != null) {
                if (name.indexOf(32) >= 0) {
                    return Status.createErrorStatus((String)Resources.spaceInName);
                }
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (proj.exists()) {
                    return Status.createErrorStatus((String)Resources.projExisting);
                }
                IStatus st = ResourcesPlugin.getWorkspace().validateName(name, 4);
                return StatusBridge.create((IStatus)st);
            }
            return Status.createOkStatus();
        }
    }

    private static final class Resources
    extends NLS {
        public static String spaceInName;
        public static String projExisting;

        static {
            Resources.initializeMessages((String)CreateProjectOpServices.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

