/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.internal;

import oracle.eclipse.tools.cloud.ICreateProjectOp;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public final class CreateProjectOpMethods {
    public static Status execute(ICreateProjectOp op, ProgressMonitor monitor) {
        ProgressMonitor mon = monitor;
        if (mon == null) {
            mon = new ProgressMonitor();
        }
        mon.beginTask("", 2);
        mon.setTaskName(Resources.taskName);
        try {
            try {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                String pjname = op.getName().text();
                IProjectDescription pjdesc = ws.newProjectDescription(pjname);
                Value<Path> location = op.getLocation();
                if (!((Path)location.getDefaultContent()).equals(location.content())) {
                    pjdesc.setLocation(PathBridge.create((Path)((Path)location.content())));
                }
                IProject pj = ws.getRoot().getProject(pjname);
                pj.create(pjdesc, (IProgressMonitor)new NullProgressMonitor());
                mon.worked(1);
                pj.open((IProgressMonitor)new NullProgressMonitor());
                mon.worked(1);
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                mon.done();
                return status;
            }
        }
        finally {
            mon.done();
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String taskName;

        static {
            Resources.initializeMessages((String)CreateProjectOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

