/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.hudson;

import com.tasktop.c2c.server.common.service.HttpStatusCodeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.cloud.ApacheHttpClient;
import oracle.eclipse.tools.cloud.AuthenticationException;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IHudsonConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.maven.MavenRunner;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.StringInputStream;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;

public class HudsonClient {
    static String CREATE_JOB_REST_API_URL = "/createItem?name=%s";
    static String PERFORM_BUILD_REST_API_URL = "/job/%s/build";
    static final String XPATH_OWNSTREAM_JOBS = "/project/project-properties/entry/external-property/originalValue/childProjects/text()";
    private static final String HUDSON_CONFIG_TEMPLATE_FILE = "config.xml";
    private static String POST_BUILD_TRIGGER_SECTION = "\n<entry>\n\t<string>hudson-tasks-BuildTrigger</string>\n\t<external-property>\n\t<originalValue class=\"hudson.tasks.BuildTrigger\">\n\t<childProjects>%s</childProjects>\n\t<threshold>\n\t<name>SUCCESS</name>\n\t<ordinal>0</ordinal>\n\t<color>BLUE</color>\n\t</threshold>\n\t</originalValue>\n\t<propertyOverridden>false</propertyOverridden>\n\t<modified>true</modified>\n\t</external-property>\n</entry>";

    public static void createJob(IHudsonConfig hudsonCfg, ICloudProfile devCloudTarget, String devCloudBaseUrl, String devCloudProjName, IProject proj, IProject parentProj, IProgressMonitor mon) {
        File configTemplate = HudsonClient.getConfigXmlTempalte();
        try {
            String projName = proj.getName();
            String jobName = String.valueOf(projName) + "-build";
            String configXmlTemplate = FileUtil.readTextFile((File)configTemplate);
            IPushProjectsToCloudOp op = (IPushProjectsToCloudOp)hudsonCfg.parent().element();
            String buildFilePath = String.valueOf(projName) + "/pom.xml";
            boolean buildWithRootPom = false;
            if (buildWithRootPom && WtpProjectUtil.isEarProject((IProject)proj)) {
                buildFilePath = String.valueOf(projName) + "/.maven.build/pom.xml";
            }
            IGitConfig gitConfig = op.getGitConfig();
            String gitUrl = (String)gitConfig.getRemoteUrl().content();
            URL url = new URL(gitUrl);
            String hostname = url.getHost();
            if (devCloudBaseUrl.endsWith("/")) {
                devCloudBaseUrl = devCloudBaseUrl.substring(0, devCloudBaseUrl.length() - 1);
            }
            String hudsonUrl = (String)hudsonCfg.getHudsonUrl().content();
            hudsonUrl = hudsonUrl.replace("/s2/", "/s/");
            mon.subTask("checking existing Hudson build job");
            String jobConfigXmlUrl = String.valueOf(devCloudBaseUrl) + "/s/" + devCloudProjName + "/hudson/job/" + devCloudProjName + "." + jobName + "/config.xml";
            String jobConfigXml = HudsonClient.doGet(devCloudTarget, jobConfigXmlUrl);
            String gitPath = url.getPath();
            String includedRegions = String.valueOf(proj.getName()) + "/.*";
            String childProjectProperty = "";
            if (parentProj != null && parentProj != proj) {
                String parentJobName;
                StringBuffer parentHudsonJobIds = new StringBuffer();
                if (jobConfigXml != null) {
                    String existingParentIds = HudsonClient.findDownStreamJobIds(jobConfigXml);
                    parentHudsonJobIds.append(existingParentIds);
                }
                if (parentHudsonJobIds.indexOf(parentJobName = String.valueOf(devCloudProjName) + "." + parentProj.getName() + "-build") < 0) {
                    if (parentHudsonJobIds.length() > 0) {
                        parentHudsonJobIds.append(", ");
                    }
                    parentHudsonJobIds.append(parentJobName);
                }
                childProjectProperty = String.format(POST_BUILD_TRIGGER_SECTION, parentHudsonJobIds.toString());
            }
            String configXmlContent = String.format(configXmlTemplate, buildFilePath, projName, gitPath, hostname, includedRegions, childProjectProperty, System.currentTimeMillis());
            String branchName = (String)op.getGitConfig().getBranchName().content();
            if (!"master".equals(branchName)) {
                configXmlContent = configXmlContent.replace("master", branchName);
            }
            if (url.getProtocol().equals("https")) {
                configXmlContent = configXmlContent.replace("<scheme>http</scheme>", "<scheme>https</scheme>");
            }
            if (OracleCloudTools.isDevCloudDebugMode()) {
                File file = new File(CloudPlugin.state().toFile(), "config" + System.currentTimeMillis() + ".xml");
                FileUtil.writeTextFile((File)file, (String)configXmlContent);
                if (OracleCloudTools.isDebugMode()) {
                    CloudPlugin.logInfo(String.format("Hudson job config.xml created for project %s at %s ", proj.getName(), file.getAbsolutePath()));
                }
            }
            if (jobConfigXml == null || jobConfigXml.length() == 0) {
                mon.subTask("creating Hudson build job " + jobName);
                String createJobUrl = String.valueOf(hudsonUrl) + String.format("createItem?name=%s", jobName);
                String result = HudsonClient.doPostXML(devCloudTarget, createJobUrl, configXmlContent);
                if (OracleCloudTools.isDevCloudDebugMode()) {
                    System.out.println(result);
                }
            } else if (((Boolean)hudsonCfg.getCreateHudsonBuildJob().content()).booleanValue()) {
                mon.subTask("updating Hudson build job " + jobName);
                String resp = HudsonClient.doPostXML(devCloudTarget, jobConfigXmlUrl, configXmlContent);
                if (OracleCloudTools.isDevCloudDebugMode()) {
                    System.out.println(resp);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ae) {
            ae.printStackTrace();
        }
    }

    private static String findDownStreamJobIds(String jobConfigXml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse((InputStream)new StringInputStream(jobConfigXml));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile(XPATH_OWNSTREAM_JOBS);
            String ret = expr.evaluate(doc, XPathConstants.STRING).toString();
            return ret;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void startBuild(IHudsonConfig hudsonCfg, ICloudProfile devCloudTarget, String dcsProjectName, IProject project, IProgressMonitor monitor) throws Exception {
        String hudsonUrl = (String)hudsonCfg.getHudsonUrl().content();
        if (hudsonUrl.endsWith("/")) {
            hudsonUrl = hudsonUrl.substring(0, hudsonUrl.length() - 1);
        }
        hudsonUrl = hudsonUrl.replace("/s2/", "/s/");
        String projName = project.getName();
        String jobName = String.valueOf(dcsProjectName) + "." + projName + "-build";
        monitor.subTask("starting Hudson build job " + jobName);
        String startBuildUrl = String.valueOf(hudsonUrl) + String.format(PERFORM_BUILD_REST_API_URL, jobName);
        HudsonClient.doGet(devCloudTarget, startBuildUrl);
    }

    public static String doGet(ICloudProfile devCloudTarget, String urlStr) throws Exception {
        ICloudProfile config = devCloudTarget;
        try {
            String userName = (String)config.getUser().content();
            String passwd = (String)config.getPassword().content();
            ApacheHttpClient client = new ApacheHttpClient(userName, passwd);
            return client.doGet((String)urlStr).bodyText;
        }
        catch (HttpStatusCodeException httpStatusCodeException) {
            return null;
        }
    }

    public static String doPostXML(ICloudProfile devCloudTarget, String urlStr, String body) throws AuthenticationException, MalformedURLException {
        ICloudProfile config = devCloudTarget;
        try {
            String userName = (String)config.getUser().content();
            String passwd = (String)config.getPassword().content();
            ApacheHttpClient client = new ApacheHttpClient(userName, passwd);
            return client.doPost((String)urlStr, (String)body, (String)"application/xml").bodyText;
        }
        catch (HttpStatusCodeException httpStatusCodeException) {
            return null;
        }
    }

    public static File getConfigXmlTempalte() {
        IPath path = CloudPlugin.state();
        File f = path.append("hudson").toFile();
        if (!f.exists()) {
            f.mkdirs();
        }
        try {
            File configXmlTemplate = new File(f, HUDSON_CONFIG_TEMPLATE_FILE);
            configXmlTemplate.delete();
            if (!configXmlTemplate.exists()) {
                String packagePath = HudsonClient.class.getPackage().getName().replace('.', '/');
                ClassLoader cl = MavenRunner.class.getClassLoader();
                InputStream inputStream = cl.getResourceAsStream(String.valueOf(packagePath) + '/' + HUDSON_CONFIG_TEMPLATE_FILE);
                if (inputStream != null) {
                    FileOutputStream fos = new FileOutputStream(configXmlTemplate);
                    try {
                        byte[] buf = new byte[256];
                        int n = inputStream.read(buf);
                        while (n > 0) {
                            fos.write(buf, 0, n);
                            n = inputStream.read(buf);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return configXmlTemplate;
        }
        catch (IOException e) {
            CloudPlugin.log(e);
            return null;
        }
    }
}

