/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.internal;

import java.util.Set;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.IGitConfig;
import oracle.eclipse.tools.cloud.dev.IHudsonConfig;
import oracle.eclipse.tools.cloud.dev.IMavenConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.dev.internal.GitCommitOpMethods;
import oracle.eclipse.tools.cloud.dev.internal.HudsonJobCreateOpMethods;
import oracle.eclipse.tools.cloud.dev.internal.MavenConfigOpMethods2;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.ComponentCore;

public class PushProjectsToCloudOpMethods {
    public static org.eclipse.sapphire.modeling.Status execute(final IPushProjectsToCloudOp op, final ProgressMonitor monitor) {
        final MutableReference status = new MutableReference();
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor mon) throws CoreException {
                status.set((Object)PushProjectsToCloudOpMethods.runOps(op, monitor));
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, ProgressMonitorBridge.create((ProgressMonitor)monitor));
        }
        catch (CoreException e) {
            return StatusBridge.create((IStatus)e.getStatus());
        }
        if (((org.eclipse.sapphire.modeling.Status)status.get()).ok()) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    String msg = "Project(s) successfully synchronized with Oracle Cloud.";
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Success", (String)msg);
                    return Status.OK_STATUS;
                }
            };
            job.schedule(500L);
        }
        return (org.eclipse.sapphire.modeling.Status)status.get();
    }

    private static org.eclipse.sapphire.modeling.Status runOps(IPushProjectsToCloudOp op, ProgressMonitor mon) {
        if (mon == null) {
            mon = new ProgressMonitor();
        }
        mon.beginTask("Push projects to Cloud", 3);
        try {
            Set projectsToPush = (Set)op.getProjectsToPush().content();
            for (IProject p : projectsToPush) {
                IMavenConfig mavenCfg = op.getMavenBuildArtifactsGenConfig();
                boolean isJavaEEProject = ComponentCore.createComponent((IProject)p) != null;
                boolean isJavaProject = false;
                try {
                    isJavaProject = p.isNatureEnabled("org.eclipse.jdt.core.javanature");
                }
                catch (Exception exception) {}
                if (!isJavaEEProject && !isJavaProject) continue;
                org.eclipse.sapphire.modeling.Status ret = null;
                ret = MavenConfigOpMethods2.execute(mavenCfg, p, mon);
                if (ret.ok()) continue;
                org.eclipse.sapphire.modeling.Status status = ret;
                return status;
            }
            mon.worked(1);
            if (mon.isCanceled()) {
                org.eclipse.sapphire.modeling.Status status = StatusBridge.create((IStatus)CloudPlugin.createErrorStatus("Pushing projects to Cloud is canceled", null));
                return status;
            }
            IGitConfig gitCfg = op.getGitConfig();
            org.eclipse.sapphire.modeling.Status sts = GitCommitOpMethods.execute(gitCfg, projectsToPush, mon);
            if (!sts.ok()) {
                org.eclipse.sapphire.modeling.Status status = sts;
                return status;
            }
            mon.worked(1);
            if (mon.isCanceled()) {
                org.eclipse.sapphire.modeling.Status status = StatusBridge.create((IStatus)CloudPlugin.createErrorStatus("Pushing projects to Cloud is canceled", null));
                return status;
            }
            for (IProject p : projectsToPush) {
                IHudsonConfig hudsonCfg;
                boolean isJavaEEProject = ComponentCore.createComponent((IProject)p) != null;
                boolean isJavaProject = false;
                try {
                    isJavaProject = p.isNatureEnabled("org.eclipse.jdt.core.javanature");
                }
                catch (Exception exception) {}
                if (!isJavaEEProject && !isJavaProject || !((Boolean)(hudsonCfg = op.getHudsonConfig()).getCreateHudsonBuildJob().content()).booleanValue()) continue;
                org.eclipse.sapphire.modeling.Status ret = HudsonJobCreateOpMethods.execute(hudsonCfg, p, mon);
                if (!ret.ok()) {
                    org.eclipse.sapphire.modeling.Status status = ret;
                    return status;
                }
                mon.worked(1);
            }
        }
        finally {
            mon.done();
        }
        return org.eclipse.sapphire.modeling.Status.createOkStatus();
    }
}

