/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.cloud.ApacheHttpClient;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.IMavenConfig;
import oracle.eclipse.tools.cloud.dev.IModulePomGenConfig;
import oracle.eclipse.tools.cloud.dev.IPushProjectsToCloudOp;
import oracle.eclipse.tools.cloud.maven.MavenRunner;
import oracle.eclipse.tools.cloud.maven.config.MavenSettingsModelFactory;
import oracle.eclipse.tools.cloud.maven.pom.IDependency;
import oracle.eclipse.tools.cloud.maven.pom.IMavenProjectModel;
import oracle.eclipse.tools.cloud.maven.pom.IModule;
import oracle.eclipse.tools.cloud.maven.pom.PomModelFactory;
import oracle.eclipse.tools.cloud.maven.pom.ScopeType;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class MavenConfigOpMethods2 {
    private static final String OEPE_SYNTHESIZED_LIB_GROUP_ID = "oepe-synth";
    private static ICloudProfile devCloudTarget = null;
    private static String mavenAuthProfileId = null;
    private static String MVN_WEBDAV_BUILD_EXT_SECTION = "%n\t<extensions>%n\t\t<extension>%n\t\t\t<artifactId>wagon-webdav-jackrabbit</artifactId>%n\t\t\t<groupId>org.apache.maven.wagon</groupId>%n\t\t\t<version>2.2</version>%n\t\t</extension>%n\t</extensions>%n";
    private static String EAR_PROJ_BUILD_SECTION = "<build>%n <plugins>%n  <plugin>%n    <artifactId>maven-ear-plugin</artifactId>%n    <version>2.7</version>%n    <configuration>%n      <earSourceDirectory>EarContent</earSourceDirectory>%n      <earSourceExcludes>META-INF/application.xml</earSourceExcludes>%n      <version>5</version>%n    </configuration>%n  </plugin>%n </plugins>%n" + MVN_WEBDAV_BUILD_EXT_SECTION + "</build>%n";
    private static String RESOURCE_ELEMENT = " <resource>%n    <directory>%s</directory>%n    <excludes>%n      <exclude>**/*.java</exclude>%n    </excludes>%n  </resource>%n";
    private static String WEB_PROJ_BUILD_SECTION = "<build>%n<sourceDirectory>%s</sourceDirectory>%n<resources>%n%s</resources>%n<plugins>%n  <plugin>%n    <artifactId>maven-war-plugin</artifactId>%n    <version>2.2</version>%n    <configuration>%n      <warSourceDirectory>WebContent</warSourceDirectory>%n      <failOnMissingWebXml>false</failOnMissingWebXml>%n    </configuration>%n  </plugin>%n%s</plugins>%n" + MVN_WEBDAV_BUILD_EXT_SECTION + "</build>%n";
    private static String EJB_PROJ_BUILD_SECTION = "<build>%n<sourceDirectory>%s</sourceDirectory>%n<resources>%n%s</resources>%n<plugins>%n  <plugin>%n  <artifactId>maven-ejb-plugin</artifactId>%n  \t<configuration>%n         <ejbVersion>3.0</ejbVersion>         <archive>%n  \t\t\t<manifest>%n               <addClasspath>true</addClasspath>%n            </manifest>%n     </archive> %n  \t</configuration>%n  </plugin>%n%s</plugins>%n" + MVN_WEBDAV_BUILD_EXT_SECTION + "</build>%n";
    private static String MULTI_SOURCE_DIRECTORY_SECTION = " <plugin>%n    <groupId>org.codehaus.mojo</groupId>%n    <artifactId>build-helper-maven-plugin</artifactId>%n    <version>1.7</version>%n   <executions>%n    <execution>%n     <id>add-source</id>%n    <phase>generate-sources</phase>%n\t   <goals>%n    <goal>add-source</goal>%n  </goals>%n  <configuration>%n    <sources>%s%n    </sources>%n  </configuration>%n  </execution>%n </executions>%n</plugin>%n";
    private static String UTIL_PROJ_BUILD_SECTION = "<build>%n<sourceDirectory>%s</sourceDirectory>%n<resources>%n%s</resources>%n%s" + MVN_WEBDAV_BUILD_EXT_SECTION + "</build>%n";
    private static String DIST_MANAGEMENT_SECTION = "<distributionManagement>%n<repository>%n\t<uniqueVersion>false</uniqueVersion>%n\t<id>DeveloperCloud</id>%n\t<name>Developer Cloud Repository</name>%n\t<url>dav:%s</url>%n\t<layout>default</layout>%n</repository>%n</distributionManagement>%n";
    private static String DEV_CLOUD_MAVEN_REPO_SECTION = "%n<repositories>%n\t<repository>%n     <!-- Server credentail ID defined in $HOME/.m2/settings.xml -->\t  <id>%s</id>%n\t  <url>%s</url>%n\t</repository>%n</repositories>%n";

    private static Map<String, String> getArtifactIdMap(IMavenConfig op) {
        HashMap<String, String> artifactIdMap = new HashMap<String, String>();
        for (IModulePomGenConfig pm : op.getProjectModules()) {
            artifactIdMap.put((String)pm.getProjectName().content(), (String)pm.getArtifactId().content());
        }
        return artifactIdMap;
    }

    public static Status execute(final IMavenConfig op, final IProject project, ProgressMonitor monitor) {
        final MutableReference status = new MutableReference();
        IPushProjectsToCloudOp op1 = (IPushProjectsToCloudOp)op.parent().element();
        devCloudTarget = DevCloudCore.findConnection((String)op1.getConnectionName().content());
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                status.set((Object)MavenConfigOpMethods2.generateMavenArtifacts(op, project, monitor));
            }
        };
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        try {
            try {
                ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, ProgressMonitorBridge.create((ProgressMonitor)monitor));
            }
            catch (CoreException e) {
                Status status2 = StatusBridge.create((IStatus)e.getStatus());
                mavenAuthProfileId = null;
                return status2;
            }
        }
        finally {
            mavenAuthProfileId = null;
        }
        return (Status)status.get();
    }

    private static String getRemoteMavenAuthProfileId() {
        if (mavenAuthProfileId == null) {
            mavenAuthProfileId = MavenSettingsModelFactory.getAuthProfileId(devCloudTarget);
        }
        return mavenAuthProfileId;
    }

    /*
     * Exception decompiling
     */
    private static Status generateMavenArtifacts(IMavenConfig op, IProject project, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getShortName(File jarFile) {
        String nameString = jarFile.getName().replace('.', '-');
        if ((nameString = nameString.substring(0, nameString.length() - 4)).startsWith("com-bea-core")) {
            nameString = nameString.replace("com-bea-core", "c-b-c");
        }
        if (nameString.length() > 20) {
            nameString = nameString.substring(0, 20);
        }
        return nameString;
    }

    /*
     * Unable to fully structure code
     */
    private static void generatePomForProject(IMavenConfig op, String defaultGroupId, IProject p, Set<String> childModules, Map<String, File> libJarsMap, IProgressMonitor monitor) {
        try {
            artifactIdMap = MavenConfigOpMethods2.getArtifactIdMap(op);
            packaging = MavenConfigOpMethods2.getProjectType(p);
            pom = p.getFile("pom.xml");
            existingGroupId = null;
            existingAtifactId = null;
            if (pom.exists()) {
                try {
                    pomModel = PomModelFactory.loadWorkspaceFile(pom);
                    existingGroupId = (String)pomModel.getGroupId().content();
                    existingAtifactId = (String)pomModel.getArtifactId().content();
                    pomModel.dispose();
                }
                catch (ResourceStoreException v0) {}
                pom.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            monitor.subTask("generate Maven Pom for " + p.getName());
            artifactId = artifactIdMap.get(p.getName());
            artifactId = existingAtifactId != null ? existingAtifactId : (artifactId != null ? artifactId : p.getName());
            model = PomModelFactory.getMavenProjectModel(pom, existingGroupId != null ? existingGroupId : defaultGroupId, artifactId, packaging);
            sharedLibMap = new HashMap<String, LibraryModuleRef>();
            for (LibraryModuleRef ref : LibraryModulesSvc.getClasspathReferences((IProject)p)) {
                sharedLibMap.put(ref.getName(), ref);
            }
            comp = ComponentCore.createComponent((IProject)p);
            if (comp != null) {
                var19_18 = refs = comp.getReferences();
                var18_19 = refs.length;
                var17_21 = 0;
                while (var17_21 < var18_19) {
                    ref = var19_18[var17_21];
                    vcomp = ref.getReferencedComponent();
                    if (!(vcomp instanceof VirtualArchiveComponent) && !childModules.contains((childProj = vcomp.getProject()).getName())) {
                        compName = artifactIdMap.get(vcomp.getName());
                        MavenConfigOpMethods2.addChildProject(model, defaultGroupId, childProj, compName, false);
                        childModules.add(childProj.getName());
                        MavenConfigOpMethods2.generatePomForProject(op, defaultGroupId, childProj, childModules, libJarsMap, monitor);
                    }
                    ++var17_21;
                }
            }
            jproj = JavaCore.create((IProject)p);
            var19_18 = jproj.getRawClasspath();
            var18_19 = var19_18.length;
            var17_21 = 0;
            while (var17_21 < var18_19) {
                block28: {
                    cpe = var19_18[var17_21];
                    if (cpe.getEntryKind() != 5) break block28;
                    manager = JavaModelManager.getJavaModelManager();
                    cc = manager.getClasspathContainer(cpe.getPath(), jproj);
                    v1 = ccPath = cc != null ? cc.getPath().toPortableString() : cpe.getPath().toString();
                    if (ccPath.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER/")) break block28;
                    var26_31 = cc.getClasspathEntries();
                    var25_30 = var26_31.length;
                    var24_29 = 0;
                    while (var24_29 < var25_30) {
                        block29: {
                            wlsCpe = var26_31[var24_29];
                            if (wlsCpe.getEntryKind() != 1 || !(jarFile = wlsCpe.getPath().toFile()).exists() || jarFile.isDirectory()) break block29;
                            sha1Checksum = OracleCloudTools.getSHA1CheckSum(jarFile);
                            if (libJarsMap.containsKey(sha1Checksum)) ** GOTO lbl69
                            jar = libJarsMap.get(sha1Checksum);
                            if (jar == null) ** GOTO lbl67
                            if (jar.equals(jarFile)) break block29;
                            if (jar.getName().equals(jarFile.getName())) {
                                CloudPlugin.logInfo("Found two JAR files with same checksum at different locations: " + jar.getAbsolutePath() + " " + jarFile.getAbsolutePath());
                            } else {
                                CloudPlugin.logWarning("Found two JAR files with same checksum but different names: " + jar.getAbsolutePath() + " " + jarFile.getAbsolutePath(), null);
lbl67:
                                // 2 sources

                                libJarsMap.put(sha1Checksum, jarFile);
lbl69:
                                // 2 sources

                                wlsCpeDep = (IDependency)model.getDependencies().insert();
                                wlsCpeDep.setGroupId("oepe-synth");
                                artifactId = String.valueOf(MavenConfigOpMethods2.getShortName(jarFile)) + "-" + sha1Checksum;
                                wlsCpeDep.setArtifactId(artifactId);
                                wlsCpeDep.setVersion("1.0");
                                wlsCpeDep.setType("jar");
                                if (MavenConfigOpMethods2.isWeblogicProvidedLibary((IClasspathEntry)cpe)) {
                                    wlsCpeDep.setScope(ScopeType.PROVIDED);
                                }
                            }
                        }
                        ++var24_29;
                    }
                }
                ++var17_21;
            }
            if (packaging.equals("war")) {
                javaeeDep = (IDependency)model.getDependencies().insert();
                javaeeDep.setGroupId("javax");
                javaeeDep.setArtifactId("javaee-web-api");
                javaeeDep.setVersion("6.0");
                javaeeDep.setScope(ScopeType.PROVIDED);
            }
            try {
                model.resource().save();
                text = FileUtil.readTextFile((File)pom.getLocation().toFile());
                n = text.indexOf("</project>");
                buf = new StringBuffer(text.substring(0, n));
                buf.append("\n<!-- ************************* -->\n");
                if (packaging.equals("war")) {
                    content = MavenConfigOpMethods2.generateBuildSectionFor(jproj, MavenConfigOpMethods2.WEB_PROJ_BUILD_SECTION);
                    buf.append(content);
                } else if (packaging.equals("ejb")) {
                    content = MavenConfigOpMethods2.generateBuildSectionFor(jproj, MavenConfigOpMethods2.EJB_PROJ_BUILD_SECTION);
                    buf.append(content);
                } else {
                    content = MavenConfigOpMethods2.generateBuildSectionFor(jproj, MavenConfigOpMethods2.UTIL_PROJ_BUILD_SECTION);
                    buf.append(content);
                }
                repoId = MavenConfigOpMethods2.getRemoteMavenAuthProfileId();
                repoUrl = (String)op.getMavenRepositoryUrl().content();
                if (repoUrl == null) {
                    throw new RuntimeException("Error detect remote Maven URL");
                }
                distMgmtSection = String.format(MavenConfigOpMethods2.DIST_MANAGEMENT_SECTION, new Object[]{repoUrl});
                buf.append(distMgmtSection);
                devCloudMvnRepo = String.format(MavenConfigOpMethods2.DEV_CLOUD_MAVEN_REPO_SECTION, new Object[]{repoId, repoUrl});
                buf.append(devCloudMvnRepo);
                buf.append(text.substring(n));
                FileUtil.writeTextFile((File)pom.getLocation().toFile(), (String)buf.toString());
                pom.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ResourceStoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static boolean isWeblogicProvidedLibary(IClasspathEntry cpe) {
        String path = cpe.getPath().toPortableString();
        return "oracle.eclipse.tools.weblogic.lib.system".equals(path) || path.startsWith("oracle.eclipse.tools.weblogic.lib.shared");
    }

    private static String generateBuildSectionFor(IJavaProject jproj, String tempalte) throws JavaModelException {
        ArrayList<String> javaSrcPathList = new ArrayList<String>();
        String projPathPrefix = jproj.getPath() + "/";
        IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getEntryKind() == 3) {
                String s = cpe.getPath().toPortableString();
                javaSrcPathList.add(s.substring(projPathPrefix.length()));
            }
            ++n2;
        }
        StringBuilder sb1 = new StringBuilder();
        for (String s : javaSrcPathList) {
            String res1 = String.format(RESOURCE_ELEMENT, s);
            sb1.append(res1);
        }
        String resourcesElements = sb1.toString();
        String multiSourceElement = "";
        if (javaSrcPathList.size() > 1) {
            StringBuilder sb = new StringBuilder();
            int i = 1;
            while (i < javaSrcPathList.size()) {
                sb.append("\n         <source>" + (String)javaSrcPathList.get(i) + "</source>\n");
                ++i;
            }
            multiSourceElement = String.format(MULTI_SOURCE_DIRECTORY_SECTION, sb.toString());
        }
        String firstSrcPath = (String)javaSrcPathList.get(0);
        String content = String.format(tempalte, firstSrcPath, resourcesElements, multiSourceElement);
        return content;
    }

    private static void installLibraryJarToLocalRepo(IMavenConfig op, MavenRunner mvnRunner, String containerId, File libFile, String groupId, String artifactId, String version, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask("install library on local Maven repo:" + artifactId);
        String repoPath = OEPE_SYNTHESIZED_LIB_GROUP_ID.replace('.', '/');
        String userHome = System.getProperty("user.home");
        File wlsSysLibRepoDir = new File(String.valueOf(userHome) + "/.m2/repository/" + repoPath + "/" + artifactId + "/" + version);
        if (wlsSysLibRepoDir.exists()) {
            File[] fileArray = wlsSysLibRepoDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".jar")) {
                    return;
                }
                ++n2;
            }
        }
        monitor.subTask("execute 'mvn install " + libFile.getName() + "'");
        mvnRunner.installFile(libFile, groupId, artifactId, version);
    }

    private static void deployLibraryToRemoteRepo(IMavenConfig mvnCfg, MavenRunner mvnRunner, StringBuffer installJarFilesCmds, File libFile, String groupId, String artifactId, String version, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String mavenModuleUrl = (String)mvnCfg.getMavenRepositoryUrl().content();
        if (mavenModuleUrl == null) {
            throw new CoreException(CloudPlugin.createErrorStatus("Invalid Maven remote repository URL", null));
        }
        mavenModuleUrl = String.valueOf(mavenModuleUrl) + groupId.replace('.', '/');
        mavenModuleUrl = String.valueOf(mavenModuleUrl) + "/" + artifactId;
        mavenModuleUrl = String.valueOf(mavenModuleUrl) + "/" + version;
        monitor.subTask("checking remote repository for dependency: " + libFile.getName());
        ICloudProfile config = devCloudTarget;
        try {
            String user = (String)config.getUser().content();
            String passwd = (String)config.getPassword().content();
            ApacheHttpClient client = new ApacheHttpClient(user, passwd);
            String response = client.doGet((String)mavenModuleUrl).bodyText;
            if (response != null && response.contains(".jar")) {
                return;
            }
        }
        catch (Exception e) {
            CloudPlugin.log(e);
            return;
        }
        monitor.subTask("deploy to remote repository: " + libFile.getName());
        String remoteRepoId = MavenConfigOpMethods2.getRemoteMavenAuthProfileId();
        String remoteRepoUrl = "dav:" + (String)mvnCfg.getMavenRepositoryUrl().content();
        int n = mvnRunner.deployJar(libFile, groupId, artifactId, version, remoteRepoUrl, remoteRepoId);
        if (n != 0) {
            String msg = "Errror deploy library to remote Maven repo: " + libFile.getName();
            msg = String.valueOf(msg) + "\nPlease see Eclipse Console view for more detail.";
            msg = String.valueOf(msg) + "\nIf your network requires proxy, please follow " + "Maven guide to configure a proxy in your Maven settings.xml file " + "(usually ${user.home}/.m2/settings.xml).";
            throw new CoreException(CloudPlugin.createErrorStatus(msg, null));
        }
        if (OracleCloudTools.isDebugMode()) {
            installJarFilesCmds.append("cmd /c \"");
            for (String s : mvnRunner.getDeployJarCommand(libFile, groupId, artifactId, version, remoteRepoUrl, remoteRepoId)) {
                installJarFilesCmds.append(String.valueOf(s) + " ");
            }
            installJarFilesCmds.append("\"\n");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void generatePomForEarProject(IMavenConfig op, String groupId, IProject earProject, Set<String> childModules, Map<String, File> libJarsMap, IProgressMonitor monitor) {
        try {
            artifactIdMap = MavenConfigOpMethods2.getArtifactIdMap(op);
            pom = earProject.getFile("/pom.xml");
            if (pom.exists()) {
                pom.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            monitor.subTask("generating Maven Pom for " + earProject.getName());
            artifactId = artifactIdMap.get(earProject.getName());
            artifactId = artifactId != null ? artifactId : earProject.getName();
            model = PomModelFactory.getMavenProjectModel(pom, groupId, artifactId, "ear");
            earComp = ComponentCore.createComponent((IProject)earProject);
            var14_14 = earComp.getReferences();
            var13_15 = var14_14.length;
            var12_17 = 0;
            while (var12_17 < var13_15) {
                block9: {
                    block10: {
                        ref = var14_14[var12_17];
                        if (ref.getDependencyType() != 0) break block9;
                        childComp = ref.getReferencedComponent();
                        if (!(childComp instanceof VirtualArchiveComponent)) break block10;
                        path = ((VirtualArchiveComponent)childComp).getArchivePath();
                        jarFile = path.toFile();
                        if (!jarFile.exists()) {
                            file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                            jarFile = file.getLocation().toFile();
                        }
                        if ((jar = libJarsMap.get(checksum = OracleCloudTools.getSHA1CheckSum(jarFile))) == null) ** GOTO lbl29
                        if (jar.getName().equals(jarFile.getName())) {
                            CloudPlugin.logInfo("Found two JAR files with same checksum: " + jar.getAbsolutePath() + " " + jarFile.getAbsolutePath());
                        } else {
                            CloudPlugin.logWarning("Found two JAR files with same checksum but different names: " + jar.getAbsolutePath() + " " + jarFile.getAbsolutePath(), null);
lbl29:
                            // 2 sources

                            libJarsMap.put(checksum, jarFile);
                        }
                        break block9;
                    }
                    childProj = childComp.getProject();
                    compName = artifactIdMap.get(childComp.getName());
                    MavenConfigOpMethods2.addChildProject(model, groupId, childProj, compName, true);
                    MavenConfigOpMethods2.generatePomForProject(op, groupId, childProj, childModules, libJarsMap, monitor);
                    childModules.add(childProj.getName());
                }
                ++var12_17;
            }
            model.resource().save();
            text = FileUtil.readTextFile((File)pom.getLocation().toFile());
            n = text.indexOf("</project>");
            buf = new StringBuffer(text.substring(0, n));
            buf.append(MavenConfigOpMethods2.EAR_PROJ_BUILD_SECTION);
            repoId = MavenSettingsModelFactory.getAuthProfileId(MavenConfigOpMethods2.devCloudTarget);
            repoUrl = (String)op.getMavenRepositoryUrl().content();
            distMgmtSection = String.format(MavenConfigOpMethods2.DIST_MANAGEMENT_SECTION, new Object[]{repoUrl});
            buf.append(distMgmtSection);
            devCloudMvnRepo = String.format(MavenConfigOpMethods2.DEV_CLOUD_MAVEN_REPO_SECTION, new Object[]{repoId, repoUrl});
            buf.append(devCloudMvnRepo);
            buf.append(text.substring(n));
            FileUtil.writeTextFile((File)pom.getLocation().toFile(), (String)buf.toString());
        }
        catch (ResourceStoreException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addChildProject(IMavenProjectModel model, String groupId, IProject childProj, String compName, boolean isInEarProject) {
        IDependency dep = (IDependency)model.getDependencies().insert();
        dep.setGroupId(groupId);
        dep.setArtifactId(compName);
        dep.setVersion("1.0.0-SNAPSHOT");
        String type = MavenConfigOpMethods2.getProjectType(childProj);
        dep.setType(type);
        if (type.equals("ejb") && !isInEarProject) {
            dep.setScope(ScopeType.PROVIDED);
        }
    }

    private static String getProjectType(IProject childProj) {
        String type = "jar";
        try {
            IFacetedProject facetProject = ProjectFacetsManager.create((IProject)childProj);
            if (facetProject != null) {
                if (facetProject.hasProjectFacet(IJ2EEFacetConstants.DYNAMIC_WEB_FACET)) {
                    type = "war";
                }
                if (facetProject.hasProjectFacet(IJ2EEFacetConstants.EJB_FACET)) {
                    type = "ejb";
                }
            }
        }
        catch (CoreException coreException) {}
        return type;
    }

    private static IFolder getMavenRootProjectFolder(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder rootPomProjFolder = project.getFolder(".maven.build");
        if (!rootPomProjFolder.exists()) {
            rootPomProjFolder.create(true, true, monitor);
        }
        return rootPomProjFolder;
    }

    private static void generateMavenRootProjectPom(String groupId, IProject parentProject, Set<String> childModules, IProgressMonitor monitor) throws CoreException, ResourceStoreException {
        IFolder rootPomProjFolder = MavenConfigOpMethods2.getMavenRootProjectFolder(parentProject, monitor);
        IFile pom = rootPomProjFolder.getFile("/pom.xml");
        if (pom.exists()) {
            pom.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        monitor.subTask("generate root pom for building " + parentProject.getName() + " and its dependencies.");
        String artifactId = String.valueOf(parentProject.getName()) + ".maven.build";
        IMavenProjectModel model = PomModelFactory.getMavenProjectModel(pom, groupId, artifactId, "pom");
        IModule module = null;
        for (String s : childModules) {
            module = (IModule)model.getModules().insert();
            module.setName("../../" + s);
        }
        module = (IModule)model.getModules().insert();
        module.setName("../");
        model.resource().save();
        try {
            pom.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IRuntime getWebLogicRuntime(IProject project) throws CoreException {
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt = fp.getPrimaryRuntime();
        if (frt != null) {
            IRuntime rt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
            return rt;
        }
        return null;
    }
}

