/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import com.tasktop.c2c.server.tasks.domain.PredefinedTaskQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.cloud.dev.BuiltInQuery;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.UserDefinedQuery;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.ui.IActionFilter;

public class TaskService
extends CloudProjectService
implements IActionFilter {
    List<BuiltInQuery> buildInQueryList = null;
    List<UserDefinedQuery> userQueries = new ArrayList<UserDefinedQuery>();

    public TaskService(CloudProject cp, ProjectService ps) {
        super(cp, ps);
    }

    @Override
    public boolean isActivated() {
        String dcsProjBaseUrl = this.getProjectService().getUrl();
        return DevCloudCore.findTaskRepository(dcsProjBaseUrl) != null;
    }

    @Override
    public void setActivated(boolean val) {
        if (val) {
            CloudProject cp = this.getCloudProject();
            String url = this.getProjectService().getUrl();
            DevCloudCore.getTaskRepoitory(url, cp);
        } else {
            this.userQueries.clear();
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        Boolean isActivated;
        if (target instanceof TaskService && name.equals("isActivated") && (isActivated = Boolean.valueOf(value)).booleanValue()) {
            return this.isActivated();
        }
        return false;
    }

    public List<BuiltInQuery> getBuiltInQueries() {
        if (this.buildInQueryList == null) {
            this.buildInQueryList = new ArrayList<BuiltInQuery>();
            PredefinedTaskQuery[] predefinedTaskQueryArray = PredefinedTaskQuery.values();
            int n = predefinedTaskQueryArray.length;
            int n2 = 0;
            while (n2 < n) {
                PredefinedTaskQuery query = predefinedTaskQueryArray[n2];
                if (!query.name().equals("ALL")) {
                    BuiltInQuery rq = new BuiltInQuery(this, query);
                    this.buildInQueryList.add(rq);
                }
                ++n2;
            }
        }
        return this.buildInQueryList;
    }

    public BuiltInQuery findBuiltInQuery(String name) {
        if (this.buildInQueryList != null) {
            for (BuiltInQuery bq : this.buildInQueryList) {
                if (!bq.getName().equalsIgnoreCase(name)) continue;
                return bq;
            }
        }
        return null;
    }

    public List<Object> getQueries() {
        ArrayList<Object> allQueries = new ArrayList<Object>();
        HashSet<String> queryNames = new HashSet<String>();
        for (RepositoryQuery rq : DevCloudCore.getRepositoryQueries(this)) {
            boolean found = false;
            for (UserDefinedQuery ud : this.userQueries) {
                if (ud.getRepositoryQuery() != rq) continue;
                found = true;
                break;
            }
            if (!found) {
                UserDefinedQuery newQ = new UserDefinedQuery(this, rq);
                this.userQueries.add(newQ);
            }
            queryNames.add(rq.getSummary());
        }
        allQueries.addAll(this.userQueries);
        for (BuiltInQuery bq : this.getBuiltInQueries()) {
            if (queryNames.contains(bq.getName())) continue;
            allQueries.add(bq);
        }
        return allQueries;
    }

    public void deleteQuery(RepositoryQuery rq) {
        Iterator<UserDefinedQuery> it = this.userQueries.iterator();
        while (it.hasNext()) {
            if (it.next().getRepositoryQuery() != rq) continue;
            it.remove();
        }
    }
}

