/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.SolutionNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class ProjectSolutions {
    GitRepoNode gitRepoNode = null;

    public ProjectSolutions(GitRepoNode gitRepoNode) {
        this.gitRepoNode = gitRepoNode;
    }

    public GitRepoNode getGitRepoNode() {
        return this.gitRepoNode;
    }

    public List<Object> getSolutions() {
        ArrayList<Object> ret = new ArrayList<Object>();
        File gitDir = DevCloudCore.getLocalGitRoot(this.gitRepoNode);
        if (gitDir.exists() && gitDir.listFiles() != null) {
            List<Object> projects = this.getProjectsInGit(gitDir);
            ret.addAll(projects);
        }
        return ret;
    }

    public String toString() {
        return "Eclipse Projects";
    }

    public CloudProject getCloudProject() {
        return this.gitRepoNode.getCloudProjectService().getCloudProject();
    }

    private List<Object> getProjectsInGit(final File directory) {
        final ArrayList<Object> projectRecords = new ArrayList<Object>();
        IRunnableWithProgress prog = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ArrayList files = new ArrayList();
                monitor.worked(10);
                if (directory.isDirectory()) {
                    boolean searchNested = false;
                    boolean found = ProjectUtil.findProjectFiles(files, (File)directory, (boolean)searchNested, (IProgressMonitor)monitor);
                    if (!found) {
                        return;
                    }
                    Iterator filesIterator = files.iterator();
                    monitor.worked(50);
                    monitor.subTask("Scanning projects...");
                    while (filesIterator.hasNext()) {
                        File file = (File)filesIterator.next();
                        IContainer c = ProjectUtil.findProjectOrWorkspaceRoot((File)file);
                        if (c instanceof IProject) {
                            projectRecords.add(c);
                            continue;
                        }
                        ProjectRecord pr = new ProjectRecord(file);
                        projectRecords.add(new SolutionNode(ProjectSolutions.this, pr));
                    }
                    if (files.isEmpty()) {
                        return;
                    }
                } else {
                    monitor.worked(60);
                }
                monitor.done();
            }
        };
        ProgressMonitorDialog pd = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            pd.run(false, false, prog);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return projectRecords;
    }
}

