/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import com.tasktop.c2c.server.scm.domain.ScmRepository;
import java.io.File;
import oracle.eclipse.tools.cloud.ActivationStateFilter;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.ProjectSolutions;
import org.eclipse.jgit.lib.Repository;

public class GitRepoNode
implements ActivationStateFilter {
    private CloudProjectService cloudProjectService = null;
    private CloudRepositoryNode repositoryNode = null;
    private ScmRepository scmRepository = null;
    private boolean isCloned = false;
    private ProjectSolutions projectSolution = null;

    public GitRepoNode(CloudProjectService cps, ScmRepository scmRepo) {
        this.cloudProjectService = cps;
        this.scmRepository = scmRepo;
        this.projectSolution = new ProjectSolutions(this);
    }

    public ProjectSolutions getProjectSolutions() {
        return this.projectSolution;
    }

    public boolean isCloned() {
        File localGitRoot = DevCloudCore.getLocalGitRoot(this);
        File gitDir = new File(localGitRoot, ".git");
        Repository repo = DevCloudCore.findRepository(gitDir);
        this.isCloned = repo != null;
        return this.isCloned;
    }

    public String getLabel() {
        return "Git repo [" + this.scmRepository.getName() + "]";
    }

    public CloudProjectService getCloudProjectService() {
        return this.cloudProjectService;
    }

    public String getUrl() {
        return this.scmRepository.getUrl();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.cloudProjectService == null ? 0 : this.cloudProjectService.hashCode());
        result = 31 * result + (this.scmRepository == null ? 0 : this.scmRepository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitRepoNode other = (GitRepoNode)obj;
        if (this.cloudProjectService == null ? other.cloudProjectService != null : !this.cloudProjectService.equals(other.cloudProjectService)) {
            return false;
        }
        return !(this.scmRepository == null ? other.scmRepository != null : !this.scmRepository.equals((Object)other.scmRepository));
    }

    public CloudRepositoryNode getRepositoryNode() {
        if (this.repositoryNode == null) {
            this.repositoryNode = DevCloudCore.createRepositoryNode(this);
        }
        return this.repositoryNode;
    }

    public void reset() {
        this.repositoryNode = null;
    }

    @Override
    public boolean isActivated() {
        return this.isCloned();
    }

    @Override
    public void setActivated(boolean val) {
    }
}

