/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.common.service.domain.QueryResult;
import com.tasktop.c2c.server.common.service.web.ApacheHttpRestClientDelegate;
import com.tasktop.c2c.server.common.service.web.RestClientDelegate;
import com.tasktop.c2c.server.profile.domain.project.Project;
import com.tasktop.c2c.server.profile.domain.project.ProjectRelationship;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import com.tasktop.c2c.server.profile.domain.project.ProjectsQuery;
import com.tasktop.c2c.server.profile.service.ProfileWebService;
import com.tasktop.c2c.server.profile.service.ProfileWebServiceClient;
import com.tasktop.c2c.server.scm.domain.ScmRepository;
import com.tasktop.c2c.server.scm.service.ScmServiceClient;
import com.tasktop.c2c.server.tasks.domain.PredefinedTaskQuery;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.cloud.ApacheHttpClient;
import oracle.eclipse.tools.cloud.CloudConnection;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.OracleCloudTools;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.CloudRepositoryNode;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.dev.GitRepoNode;
import oracle.eclipse.tools.cloud.dev.TaskService;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.core.securestorage.UserPasswordCredentials;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildServerConfiguration;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Display;

public class DevCloudCore {
    public static String DEFAULT_NAME = "Oracle Developer Cloud Service";
    private static Map<String, List<String>> cloudProjectNamesCache = new HashMap<String, List<String>>();
    private static final RepositoryCache repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
    public static final String ID = CloudPlugin.class.getPackage().getName();
    public static final String CONNECTOR_KIND = "CloudDev";
    public static final String CRITERIA_QUERY = "findTasksWithCriteria";
    public static final String PREDEFINED_QUERY = "findTasksWithQuery";
    public static final String QUERY_CRITERIA = "QueryCriteria";
    public static final String QUERY_NAME = "QueryName";

    public static DevServiceDesc createInternalDevServiceDesc(CloudConnection connection, ICloudProfile devProfile) {
        String idDomain = (String)devProfile.getIdentityDomain().content();
        String dcsUrl = (String)devProfile.getDevCloudBaseUrl().content();
        dcsUrl = dcsUrl.endsWith("/") ? dcsUrl : String.valueOf(dcsUrl) + '/';
        dcsUrl = String.valueOf(dcsUrl) + idDomain + "/";
        DevServiceDesc devSvcDesc = new DevServiceDesc(connection, idDomain, dcsUrl, devProfile);
        devSvcDesc.setInternal(true);
        return devSvcDesc;
    }

    public static ICloudProfile findConnection(String name) {
        for (CloudConnection connection : OracleCloudTools.connections()) {
            if (!connection.name().equals(name)) continue;
            return connection.profile();
        }
        return null;
    }

    public static ICloudProfile getConnection(IProject project) {
        URIish projGitUrl = DevCloudCore.getRemoteGitUrl(project);
        if (projGitUrl == null) {
            return null;
        }
        String gitUrl = projGitUrl.toString();
        for (CloudConnection connection : OracleCloudTools.connections()) {
            ICloudProfile profile = connection.profile();
            String identityDomain = (String)profile.getIdentityDomain().content();
            String baseUrl = (String)profile.getDevCloudBaseUrl().content();
            String user = (String)profile.getUser().content();
            int n = baseUrl.indexOf("://");
            StringBuffer sb = new StringBuffer(baseUrl);
            sb.insert(n + 3, String.valueOf(user.replace("@", "%40")) + "@");
            if (!gitUrl.startsWith(sb.toString()) || gitUrl.indexOf(identityDomain) <= 0) continue;
            return profile;
        }
        return null;
    }

    public static String getDevServiceUrl(ICloudProfile profile, String cloudProjName) {
        String orgId = cloudProjName.indexOf(95) > 0 ? cloudProjName.substring(0, cloudProjName.indexOf(95)) : (String)profile.getIdentityDomain().content();
        String url = (String)profile.getDevCloudBaseUrl().content();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + orgId + "/";
        return url;
    }

    public static URIish getRemoteGitUrl(IProject project) {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
        if (mapping == null) {
            return null;
        }
        Repository repo = mapping.getRepository();
        String remoteName = "origin";
        try {
            RemoteConfig rc = new RemoteConfig((Config)repo.getConfig(), remoteName);
            if (!rc.getURIs().isEmpty()) {
                URIish uri = (URIish)rc.getURIs().get(0);
                return uri;
            }
        }
        catch (URISyntaxException e) {
            CloudPlugin.log(e);
            return null;
        }
        return null;
    }

    public static ProfileWebService getProfileWebServiceClient(String baseUrl, String user, String passwd) throws MalformedURLException {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        ClassLoader cldr1 = ProfileWebService.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(cldr1);
        String apiUrl = baseUrl.endsWith("/") ? String.valueOf(baseUrl) + "api" : String.valueOf(baseUrl) + "/api";
        ProfileWebServiceClient client = new ProfileWebServiceClient();
        client.setBaseUrl(apiUrl);
        ApacheHttpRestClientDelegate springDelegate = new ApacheHttpRestClientDelegate(user, passwd);
        client.setRestClientDelegate((RestClientDelegate)springDelegate);
        Thread.currentThread().setContextClassLoader(cldr);
        return client;
    }

    public static ScmServiceClient getScmServiceClient(ICloudProfile profile, ProjectService scmService) throws MalformedURLException {
        String user = (String)profile.getUser().content();
        String passwd = (String)profile.getPassword().content();
        String baseUrl = scmService.getUrl();
        String apiUrl = baseUrl.endsWith("/") ? String.valueOf(baseUrl) + "api" : String.valueOf(baseUrl) + "/api";
        ScmServiceClient client = new ScmServiceClient();
        client.setBaseUrl(apiUrl);
        ApacheHttpRestClientDelegate springDelegate = new ApacheHttpRestClientDelegate(user, passwd);
        client.setRestClientDelegate((RestClientDelegate)springDelegate);
        return client;
    }

    public static List<ScmRepository> getGitRepositories(ICloudProfile devProfile, ProjectService scmService) {
        try {
            ScmServiceClient client = DevCloudCore.getScmServiceClient(devProfile, scmService);
            return client.getScmRepositories();
        }
        catch (Exception e) {
            if (OracleCloudTools.isDevCloudDebugMode()) {
                CloudPlugin.log(e);
            }
            return Collections.emptyList();
        }
    }

    public static void resetCache() {
        cloudProjectNamesCache.clear();
    }

    public static List<CloudProject> getCloudProjects(DevServiceDesc devService) throws MalformedURLException {
        return DevCloudCore.getCloudProjects(devService, false);
    }

    public static List<CloudProject> getCloudProjects(DevServiceDesc devService, boolean showAll) throws MalformedURLException {
        ICloudProfile profile = devService.devCloudProfile();
        String dcsServiceId = String.valueOf(devService.getName().toLowerCase()) + "-" + (String)profile.getIdentityDomain().content();
        if (devService.isInternal()) {
            dcsServiceId = (String)profile.getIdentityDomain().content();
        }
        return DevCloudCore.getCloudProjects(profile, dcsServiceId, showAll);
    }

    public static List<CloudProject> getCloudProjects(ICloudProfile profile, String dcsServiceId, boolean showAll) throws MalformedURLException {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        ClassLoader cldr1 = ProfileWebService.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(cldr1);
        ArrayList<CloudProject> ret = new ArrayList<CloudProject>();
        try {
            ApacheHttpClient httpClient = new ApacheHttpClient(null, null);
            httpClient.setTimeout(5000);
            String dcsBaseUrl = (String)profile.getDevCloudBaseUrl().content();
            if (!dcsBaseUrl.endsWith("/")) {
                dcsBaseUrl = String.valueOf(dcsBaseUrl) + "/";
            }
            String url = String.valueOf(dcsBaseUrl) + dcsServiceId + "/";
            ApacheHttpClient.ResponseData rd = httpClient.doGet(url);
            if (rd.exception != null) {
                return null;
            }
            try {
                ProfileWebService client = DevCloudCore.getProfileWebServiceClient(url, (String)profile.getUser().content(), (String)profile.getPassword().content());
                Thread.currentThread().setContextClassLoader(cldr1);
                ProjectsQuery query = new ProjectsQuery(showAll ? ProjectRelationship.ALL : ProjectRelationship.MEMBER, null);
                query.setOrganizationIdentifier(dcsServiceId);
                QueryResult result = client.findProjects(query);
                for (Project p : result.getResultPage()) {
                    CloudProject cp = new CloudProject(profile, p);
                    ret.add(cp);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cldr);
        }
        return ret;
    }

    public static CloudProject findCloudProjectById(DevServiceDesc devService, String projId) {
        try {
            for (CloudProject cp : DevCloudCore.getCloudProjects(devService)) {
                if (!cp.getProject().getIdentifier().equals(projId)) continue;
                return cp;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static List<ProjectService> getProjectServices(DevServiceDesc devService, String projectId) {
        try {
            for (CloudProject pp : DevCloudCore.getCloudProjects(devService)) {
                Project p = pp.getProject();
                String projId = p.getIdentifier();
                if (!projId.equalsIgnoreCase(projectId)) continue;
                return p.getProjectServices();
            }
        }
        catch (Exception e) {
            CloudPlugin.log(e);
        }
        return Collections.emptyList();
    }

    public static String getHudsonUrl(DevServiceDesc devService, String cloudProjId) {
        for (ProjectService ps : DevCloudCore.getProjectServices(devService, cloudProjId)) {
            if (ps.getServiceType() != ServiceType.BUILD) continue;
            return ps.getUrl();
        }
        return null;
    }

    public static String getHudsonWebUrl(DevServiceDesc devProfile, String cloudProjId) {
        for (ProjectService ps : DevCloudCore.getProjectServices(devProfile, cloudProjId)) {
            if (ps.getServiceType() != ServiceType.BUILD) continue;
            return ps.getWebUrl();
        }
        return null;
    }

    public static String getMavenUrl(DevServiceDesc devProfile, String cloudProjName) {
        for (ProjectService ps : DevCloudCore.getProjectServices(devProfile, cloudProjName)) {
            if (ps.getServiceType() != ServiceType.MAVEN) continue;
            return ps.getUrl();
        }
        return null;
    }

    public static List<String> getGitUrls(DevServiceDesc devService, String cloudProjName) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ProjectService ps : DevCloudCore.getProjectServices(devService, cloudProjName)) {
            if (ps.getServiceType() != ServiceType.SCM) continue;
            for (ScmRepository repo : DevCloudCore.getGitRepositories(devService.devCloudProfile(), ps)) {
                ret.add(repo.getUrl());
            }
        }
        return ret;
    }

    public static String getGitBaseUrl(DevServiceDesc devProfile, String cloudProjName) {
        for (ProjectService ps : DevCloudCore.getProjectServices(devProfile, cloudProjName)) {
            if (ps.getServiceType() != ServiceType.SCM) continue;
            String gitUrl = ps.getUrl();
            return gitUrl;
        }
        return null;
    }

    public static String getGitWebUrl(DevServiceDesc devProfile, String cloudProjName) {
        for (ProjectService ps : DevCloudCore.getProjectServices(devProfile, cloudProjName)) {
            if (ps.getServiceType() != ServiceType.SCM) continue;
            String gitUrl = ps.getWebUrl();
            return gitUrl;
        }
        return null;
    }

    public static String getDomainPrefix(String baseUrl) {
        String domainPrefix = "";
        if ((baseUrl.startsWith("http://") || baseUrl.startsWith("https://")) && baseUrl.indexOf(".") > 0) {
            domainPrefix = baseUrl.substring(baseUrl.indexOf("://") + 3, baseUrl.indexOf("."));
        }
        return domainPrefix;
    }

    public static String findCloudProjectIdFor(IProject project) {
        File parentFile = project.getLocation().toFile().getParentFile();
        File gitDir = new File(parentFile, ".git");
        boolean isGitRepo = RepositoryCache.FileKey.isGitRepository((File)gitDir, (FS)FS.DETECTED);
        if (isGitRepo) {
            URIish remoteGitUrl = DevCloudCore.getRemoteGitUrl(project);
            if (remoteGitUrl == null) {
                return null;
            }
            String path = remoteGitUrl.getPath();
            String[] paths = path.split("/");
            if (paths.length >= 3) {
                return paths[3];
            }
            String name = parentFile.getName();
            int end = name.endsWith(".git") ? name.length() - 4 : name.length();
            String cloudProjName = name.substring(0, end);
            return cloudProjName;
        }
        return null;
    }

    public static File getLocalGitRoot(String gitUrl, String cloudProjName) {
        String domainPrefix = DevCloudCore.getDomainPrefix(gitUrl);
        String localGitPath = String.valueOf(domainPrefix) + "_" + cloudProjName + ".git";
        File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File file = new File(workspaceRoot, localGitPath);
        return file;
    }

    public static UserPasswordCredentials getGitCredentials(URIish uri) {
        UserPasswordCredentials credentials = null;
        try {
            credentials = org.eclipse.egit.core.Activator.getDefault().getSecureStore().getCredentials(uri);
        }
        catch (StorageException e) {
            CloudPlugin.logError(UIText.LoginService_readingCredentialsFailed, (Exception)((Object)e));
        }
        return credentials;
    }

    public static IBuildServer findBuildServer(BuildService ps) {
        String url = ps.getProjectService().getUrl();
        return DevCloudCore.findBuildServer(url);
    }

    public static IBuildServer findBuildServer(String url) {
        if ((url = url.replace("/s2/", "/s/")).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        List servers = BuildsUiInternal.getModel().getServers();
        for (IBuildServer s : servers) {
            String theUrl = s.getUrl();
            if (!url.equals(theUrl)) continue;
            return s;
        }
        return null;
    }

    public static void refreshBuildPlans(BuildServer server, IProgressMonitor monitor) throws OperationCanceledException, CoreException, IOException {
        monitor.setTaskName("Refreshing build plans...");
        final HashSet<IBuildPlan> addPlans = new HashSet<IBuildPlan>();
        IOperationMonitor progress = OperationUtil.convert((IProgressMonitor)new NullProgressMonitor(), (String)"Refresh build status", (int)-1);
        BuildServerConfiguration buildServerCfg = server.getBehaviour().refreshConfiguration(progress);
        List plans = buildServerCfg.getPlans();
        for (IBuildPlan plan : plans) {
            plan.setSelected(true);
            plan.setServer((IBuildServer)server);
            addPlans.add(plan);
        }
        final IBuildModel model = BuildsUi.getModel();
        if (addPlans.size() != model.getPlans().size()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    model.getPlans().clear();
                    model.getPlans().addAll(addPlans);
                    try {
                        BuildsUiInternal.save();
                    }
                    catch (IOException iOException) {}
                }
            });
        }
    }

    public static CloudRepositoryNode createRepositoryNode(GitRepoNode gitRepoNode) {
        File gitRoot = DevCloudCore.getLocalGitRoot(gitRepoNode);
        File dir = new File(gitRoot, ".git");
        Repository repo = DevCloudCore.findRepository(dir);
        if (repo != null) {
            CloudRepositoryNode rNode = new CloudRepositoryNode(gitRepoNode, repo);
            return rNode;
        }
        return null;
    }

    public static Repository findRepository(File gitRoot) {
        RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
        for (String directory : repositoryUtil.getConfiguredRepositories()) {
            try {
                File gitDir = new File(directory);
                if (!gitDir.exists() || !gitDir.equals(gitRoot)) continue;
                Repository repo = repositoryCache.lookupRepository(gitDir);
                return repo;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static File getLocalGitRoot(GitRepoNode gitRepoNode) {
        String remoteUrl = gitRepoNode.getUrl();
        return DevCloudCore.getLocalGitRoot(remoteUrl);
    }

    public static File getLocalGitRoot(String remoteUrl) {
        RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
        for (String s : util.getConfiguredRepositories()) {
            try {
                URIish uri;
                FileRepository repo = new FileRepository(s);
                RemoteConfig rc = new RemoteConfig((Config)repo.getConfig(), "origin");
                List uris = rc.getURIs();
                if (uris.size() <= 0 || !(uri = ((URIish)uris.get(0)).setUser(null)).toString().equals(remoteUrl)) continue;
                return new File(s).getParentFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int n = remoteUrl.lastIndexOf(47) + 1;
        String localGitPath = remoteUrl.substring(n);
        File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File file = new File(workspaceRoot, localGitPath);
        return file;
    }

    public static IBuildServer createBuildServer(CloudProjectService ps) {
        IBuildServer server1 = DevCloudCore.findBuildServer(ps.getProjectService().getUrl());
        if (server1 != null) {
            return server1;
        }
        CloudProject cp = ps.getCloudProject();
        ICloudProfile profile = cp.getProfile();
        String url = ps.getProjectService().getUrl();
        if ((url = url.replace("/s2/", "/s/")).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        String label = profile.getConnectionName() + " [" + cp.getProject().getName() + "] Build Server";
        String connectorKind = "org.eclipse.mylyn.hudson";
        final List servers = BuildsUi.getModel().getServers();
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("org.eclipse.mylyn.repositories.proxy.usedefault", Boolean.TRUE.toString());
        defaultProperties.put("id", url);
        RepositoryLocation location = new RepositoryLocation(defaultProperties);
        BuildServer server = (BuildServer)BuildsUiInternal.createServer((String)connectorKind, (RepositoryLocation)location);
        location.setIdPreservingCredentialsStore(url);
        UserCredentials credentials = new UserCredentials((String)profile.getUser().content(), (String)profile.getPassword().content(), true);
        location.setLabel(label);
        location.setUrl(url);
        location.setUserName((String)profile.getUser().content());
        location.setCredentials(org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType.HTTP, (AuthenticationCredentials)credentials);
        server.setName(label);
        server.setUrl(url);
        server.getAttributes().put("id", url);
        server.getAttributes().put("label", label);
        server.getAttributes().put("url", url);
        String httpKey = org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType.HTTP.getKey();
        server.getAttributes().put(String.valueOf(httpKey) + ".enabled", "true");
        ICredentialsStore newCredentialsStore = location.getCredentialsStore();
        try {
            newCredentialsStore.flush();
            Display.getDefault().syncExec(new Runnable((IBuildServer)server){
                private final /* synthetic */ IBuildServer val$server;
                {
                    this.val$server = iBuildServer;
                }

                @Override
                public void run() {
                    servers.add(this.val$server);
                }
            });
            BuildsUiInternal.save();
        }
        catch (IOException ioe) {
            CloudPlugin.log(ioe);
        }
        return server;
    }

    public static boolean hasRepositoryQueries(TaskService ts) {
        String url = ts.getProjectService().getUrl();
        Set queryList = TasksUiPlugin.getTaskList().getRepositoryQueries(url);
        return queryList != null && queryList.size() != 0;
    }

    public static TaskRepository findTaskRepository(String dcsProjBaseUrl) {
        for (TaskRepository taskRepo : TasksUiPlugin.getRepositoryManager().getAllRepositories()) {
            if (!taskRepo.getUrl().startsWith(dcsProjBaseUrl)) continue;
            return taskRepo;
        }
        return null;
    }

    public static Set<RepositoryQuery> getRepositoryQueries(TaskService ts) {
        String url = ts.getProjectService().getUrl();
        Set queryList = TasksUiPlugin.getTaskList().getRepositoryQueries(url);
        return queryList;
    }

    public static RepositoryQuery createPredefinedQuery(TaskService ts, PredefinedTaskQuery query) {
        try {
            CloudProject cp = ts.getCloudProject();
            String url = ts.getProjectService().getUrl();
            TaskRepository taskRepo = DevCloudCore.getTaskRepoitory(url, cp);
            Set queryList = TasksUiPlugin.getTaskList().getRepositoryQueries(url);
            String name = String.valueOf(Character.toUpperCase(query.name().charAt(0))) + query.name().substring(1).toLowerCase();
            for (RepositoryQuery rq : queryList) {
                if (!rq.getSummary().equals(name)) continue;
                return rq;
            }
            RepositoryQuery pq = DevCloudCore.createPredefinedQuery(taskRepo, name, query.toString());
            return pq;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RepositoryQuery findPredefinedQuery(TaskService ts, PredefinedTaskQuery query) {
        try {
            String url = ts.getProjectService().getUrl();
            Set queryList = TasksUiPlugin.getTaskList().getRepositoryQueries(url);
            String name = query.name();
            for (RepositoryQuery rq : queryList) {
                if (!rq.getSummary().equals(name)) continue;
                return rq;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void deleteQuery(RepositoryQuery rq) {
        TasksUiPlugin.getTaskList().deleteQuery(rq);
    }

    public static RepositoryQuery createPredefinedQuery(TaskRepository taskRepo, String name, String refName) {
        RepositoryQuery mq = (RepositoryQuery)TasksUi.getRepositoryModel().createRepositoryQuery(taskRepo);
        mq.setSummary(name);
        mq.setUrl(PREDEFINED_QUERY);
        mq.setAttribute(QUERY_NAME, refName);
        TasksUiPlugin.getTaskList().addQuery(mq);
        return mq;
    }

    public static TaskRepository getTaskRepoitory(String url, CloudProject cp) {
        TaskRepository taskRepository = null;
        IRepositoryManager repoMgr = TasksUi.getRepositoryManager();
        for (TaskRepository repo : repoMgr.getAllRepositories()) {
            if (!repo.getUrl().equals(url)) continue;
            taskRepository = repo;
            break;
        }
        if (taskRepository == null) {
            taskRepository = new TaskRepository(CONNECTOR_KIND, url);
            String label = String.valueOf((String)cp.getProfile().getConnectionName().content()) + " [" + cp.getProject().getName() + "]";
            taskRepository.setRepositoryLabel(label);
            taskRepository.setProperty("category", "org.eclipse.mylyn.category.tasks");
            taskRepository.setProperty("Connection", (String)cp.getProfile().getId().content());
            taskRepository.setProperty("Project", cp.getProject().getName());
            ICloudProfile cloudProfile = cp.getProfile();
            org.eclipse.mylyn.commons.net.AuthenticationCredentials webCredentials = new org.eclipse.mylyn.commons.net.AuthenticationCredentials((String)cloudProfile.getUser().content(), (String)cloudProfile.getPassword().content());
            taskRepository.setCredentials(AuthenticationType.HTTP, webCredentials, true);
            taskRepository.setCredentials(AuthenticationType.REPOSITORY, webCredentials, true);
            repoMgr.addRepository(taskRepository);
        }
        return taskRepository;
    }
}

