/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.dev.DcsBuildPlan;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.operations.GetBuildsOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.sapphire.util.ListFactory;

public class DcsBuilds
extends RemoteData<List<Object>> {
    DcsBuildPlan dcsBuildPlan;

    public DcsBuilds(DcsBuildPlan dcsBuildPlan) {
        super("builds");
        this.dcsBuildPlan = dcsBuildPlan;
    }

    public DcsBuildPlan buildPlan() {
        return this.dcsBuildPlan;
    }

    @Override
    protected List<Object> read() throws Exception {
        ListFactory ret = ListFactory.start();
        Object[] builds = this.getBuildHistory(this.dcsBuildPlan.plan);
        ret.add(builds);
        return ret.result();
    }

    public Object[] getBuildHistory(final IBuildPlan plan) {
        final ArrayList ret = new ArrayList();
        if (plan != null) {
            final boolean[] isDone = new boolean[1];
            GetBuildsRequest request = new GetBuildsRequest(plan, GetBuildsRequest.Kind.ALL, GetBuildsRequest.Scope.HISTORY);
            GetBuildsOperation refreshOperation = new GetBuildsOperation(BuildsUiInternal.getFactory().getService(), request){

                protected void schedule(List<BuildJob> jobs) {
                    for (BuildJob job : jobs) {
                        job.setUser(false);
                        job.schedule();
                    }
                }
            };
            refreshOperation.addOperationChangeListener(new OperationChangeListener(){

                public void done(OperationChangeEvent event) {
                    if (!event.getStatus().isOK()) {
                        isDone[0] = true;
                        return;
                    }
                    GetBuildsOperation operation = (GetBuildsOperation)event.getOperation();
                    List builds = operation.getBuilds();
                    if (builds != null) {
                        for (IBuild build : builds) {
                            build.setPlan(plan);
                            build.setServer(plan.getServer());
                            ret.add(build);
                        }
                    }
                    isDone[0] = true;
                }
            });
            refreshOperation.execute();
            while (!isDone[0]) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret.toArray();
    }
}

