/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import com.tasktop.c2c.server.cloud.domain.ServiceType;
import com.tasktop.c2c.server.profile.domain.project.ProjectService;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.cloud.RemoteData;
import oracle.eclipse.tools.cloud.dev.BuildService;
import oracle.eclipse.tools.cloud.dev.CloudProject;
import oracle.eclipse.tools.cloud.dev.CloudProjectService;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.ScmService;
import oracle.eclipse.tools.cloud.dev.TaskService;
import org.eclipse.sapphire.util.ListFactory;

public class CloudProjectServices
extends RemoteData<List<CloudProjectService>> {
    private CloudProject cloudProj = null;

    public CloudProjectServices(CloudProject cloudProj) {
        super("Cloud project services");
        this.cloudProj = cloudProj;
    }

    public CloudProject cloudProject() {
        return this.cloudProj;
    }

    @Override
    protected List<CloudProjectService> read() throws Exception {
        ListFactory ret = ListFactory.start();
        List<CloudProjectService> list = CloudProjectServices.createCloudProjectServices(this.cloudProj);
        ret.add(list);
        return ret.result();
    }

    public static List<CloudProjectService> createCloudProjectServices(CloudProject p) {
        ArrayList<CloudProjectService> ret = new ArrayList<CloudProjectService>();
        List psList = p.getProject().getProjectServices();
        for (ProjectService ps : psList) {
            if (ps.getServiceType() == ServiceType.TASKS) {
                TaskService ts = new TaskService(p, ps);
                ret.add(ts);
                continue;
            }
            if (ps.getServiceType() == ServiceType.BUILD) {
                BuildService buildSvc;
                buildSvc.setActivated(DevCloudCore.findBuildServer(buildSvc = new BuildService(p, ps)) != null);
                ret.add(buildSvc);
                continue;
            }
            if (ps.getServiceType() != ServiceType.SCM) continue;
            ScmService scmSvc = new ScmService(p, ps);
            scmSvc.setActivated(true);
            ret.add(scmSvc);
        }
        return ret;
    }
}

