/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud.dev;

import com.tasktop.c2c.server.profile.domain.project.Project;
import java.util.List;
import oracle.eclipse.tools.cloud.ActivationStateFilter;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.cloud.dev.CloudProjectServices;
import oracle.eclipse.tools.cloud.dev.DevCloudCore;
import oracle.eclipse.tools.cloud.dev.DevServiceDesc;
import oracle.eclipse.tools.cloud.profile.ICloudProfile;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IActionFilter;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CloudProject
implements IActionFilter,
ActivationStateFilter {
    DevServiceDesc devServiceDesc = null;
    ICloudProfile profile = null;
    Project project = null;
    CloudProjectServices cloudProjectServices = new CloudProjectServices(this);
    List<String> remoteGitUrls = null;
    boolean isActivated = false;

    public CloudProject(ICloudProfile profile, Project proj) {
        this.profile = profile;
        this.project = proj;
    }

    public String name() {
        return this.project.getName();
    }

    @Override
    public boolean isActivated() {
        return this.isActivated;
    }

    @Override
    public void setActivated(boolean val) {
        this.isActivated = val;
        this.devServiceDesc.cloudProjects().fetch(true, null);
    }

    public boolean testAttribute(Object target, String name, String value) {
        Boolean isActivated;
        if (target instanceof CloudProject && name.equals("isActivated") && (isActivated = Boolean.valueOf(value)).booleanValue()) {
            return this.isActivated();
        }
        return false;
    }

    public ICloudProfile getProfile() {
        return this.profile;
    }

    public Project getProject() {
        return this.project;
    }

    public CloudProjectServices projectServices() {
        return this.cloudProjectServices;
    }

    public List<String> getRemoteGitUrls() {
        if (this.remoteGitUrls == null) {
            this.remoteGitUrls = DevCloudCore.getGitUrls(this.devServiceDesc, this.getProject().getIdentifier());
        }
        return this.remoteGitUrls;
    }

    public static IStatus canSupport(Object obj) {
        if (obj instanceof IProject) {
            IProject project = (IProject)obj;
            if (ComponentCore.createComponent((IProject)project) == null) {
                return Status.CANCEL_STATUS;
            }
            if (!WtpProjectUtil.isEarProject((IProject)project)) {
                IProject earProj = WtpProjectUtil.findReferencingEarProject((IProject)project);
                if (earProj != null) {
                    IStatus ret = CloudPlugin.createErrorStatus("Project selected is a child module in JavaEE project. Please rerun the wizard on parent project: " + earProj.getName(), null);
                    return ret;
                }
                if (!CloudProject.isJavaFacetVersionSupported(project)) {
                    IStatus ret = CloudPlugin.createErrorStatus("Oracle Developer Cloud Service only supports JaveEE project with Java version 1.6 or lower.", null);
                    return ret;
                }
            }
            for (IProject refProj : WtpProjectUtil.findReferencedProjects((IProject)project)) {
                if (CloudProject.isJavaFacetVersionSupported(refProj)) continue;
                IStatus ret = CloudPlugin.createErrorStatus("Oracle Developer Cloud Service only supports project with Java version 1.6 or lower.", null);
                return ret;
            }
        }
        return Status.OK_STATUS;
    }

    public static boolean isJavaFacetVersionSupported(IProject proj) {
        IProjectFacetVersion fv = FacetedProjectUtilities.getProjectFacetVersion((IProject)proj, (String)"jst.java");
        return fv == null || fv.getVersionString().compareTo("1.6") <= 0;
    }

    public void setDevServiceDesc(DevServiceDesc devSvcDesc) {
        this.devServiceDesc = devSvcDesc;
    }

    public DevServiceDesc getDevServiceDesc() {
        return this.devServiceDesc;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.devServiceDesc == null ? 0 : this.devServiceDesc.getUrl().hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CloudProject other = (CloudProject)obj;
        if (this.devServiceDesc == null ? other.devServiceDesc != null : !this.devServiceDesc.getUrl().equals(other.devServiceDesc.getUrl())) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.getName().equals(other.project.getName()));
    }
}

