/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.cloud;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import oracle.eclipse.tools.cloud.CloudPlugin;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;

public abstract class RemoteData<T> {
    @Text(value="{0} already disposed")
    private static LocalizableText alreadyDisposedMessage;
    private static final long CACHE_EXPIRATION = 604800000L;
    private static final SecretKeySpec cacheEncryptionKey;
    private static final Map<Class<?>, Cache> caches;
    private String label;
    private T content;
    private boolean fetchFailed = false;
    private ListenerContext listeners;
    private Serializer<T> serializer;
    private BackgroundFetcher backgroundFetcher;
    private boolean backgroundFetcherActivated;
    private boolean initializedFromCache;
    private boolean disposed;

    static {
        LocalizableText.init(RemoteData.class);
        byte[] key = null;
        try {
            ISecurePreferences prefs = SecurePreferencesFactory.getDefault().node(RemoteData.class.getName());
            key = prefs.getByteArray("CacheEncryptionKey", null);
            if (key == null || key.length != 16) {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
                keyGenerator.init(128);
                key = keyGenerator.generateKey().getEncoded();
                prefs.putByteArray("CacheEncryptionKey", key, true);
                prefs.flush();
            }
        }
        catch (Exception e) {
            CloudPlugin.log(e);
        }
        cacheEncryptionKey = key == null ? null : new SecretKeySpec(key, "AES");
        caches = new HashMap();
    }

    public RemoteData(String label) {
        this(label, null);
    }

    public RemoteData(String label, Serializer<T> serializer) {
        this(label, serializer, null);
    }

    public RemoteData(String label, Serializer<T> serializer, BackgroundFetcher backgroundFetcher) {
        this.label = label;
        this.serializer = serializer;
        this.backgroundFetcher = backgroundFetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String label() {
        RemoteData remoteData = this;
        synchronized (remoteData) {
            this.assertNotDisposed();
            return this.label;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T content() {
        if (!this.available()) {
            this.fetch();
        }
        RemoteData remoteData = this;
        synchronized (remoteData) {
            this.assertNotDisposed();
            return this.content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean available() {
        RemoteData remoteData = this;
        synchronized (remoteData) {
            this.assertNotDisposed();
            return this.content != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean fetchFailed() {
        RemoteData remoteData = this;
        synchronized (remoteData) {
            this.assertNotDisposed();
            return this.fetchFailed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        boolean changed;
        RemoteData remoteData = this;
        synchronized (remoteData) {
            changed = this.available();
            this.content = null;
        }
        if (changed) {
            this.broadcast(new ContentEvent(this));
        }
    }

    public final void fetch() {
        this.fetch(false);
    }

    public final void fetch(boolean fork) {
        this.fetch(fork, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fetch(boolean fork, final IProgressMonitor monitor) {
        if (fork) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    RemoteData.this.fetch(false, monitor);
                }
            };
            thread.start();
        } else {
            Cache cache;
            if (monitor != null) {
                monitor.beginTask("Fetching " + this.label + "...", -1);
            }
            Object d = null;
            boolean fetchedFromCache = false;
            Object object = caches;
            synchronized (object) {
                Class<?> cl = this.getClass();
                cache = caches.get(cl);
                if (cache == null) {
                    cache = new Cache(cl);
                    caches.put(cl, cache);
                }
            }
            object = this;
            synchronized (object) {
                if (this.serializer != null && !this.initializedFromCache) {
                    this.initializedFromCache = true;
                    this.serializer.init(this);
                    byte[] content = cache.read(this.serializer.id());
                    if (content != null) {
                        try {
                            d = this.serializer.read(new ByteArrayInputStream(content));
                            fetchedFromCache = true;
                            this.fetchFailed = false;
                            System.err.println(String.valueOf(this.getClass().getName()) + " fetched from cache");
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            boolean fetchedFromOrigin = false;
            if (fetchedFromCache) {
                this.fetch(true);
            } else {
                try {
                    d = this.read();
                    fetchedFromOrigin = true;
                    this.fetchFailed = false;
                }
                catch (Exception e) {
                    CloudPlugin.log(e);
                    this.broadcast(new FetchFailedEvent(this));
                    this.fetchFailed = true;
                }
            }
            if (fetchedFromCache || fetchedFromOrigin) {
                boolean changed = false;
                RemoteData remoteData = this;
                synchronized (remoteData) {
                    if (!ObjectUtil.equal(this.content, d)) {
                        this.content = d;
                        changed = true;
                    }
                }
                if (changed) {
                    this.broadcast(new ContentEvent(this));
                }
            }
            RemoteData remoteData = this;
            synchronized (remoteData) {
                if (fetchedFromOrigin && this.serializer != null) {
                    byte[] content = null;
                    try {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        this.serializer.write(this.content, stream);
                        content = stream.toByteArray();
                    }
                    catch (Exception e) {
                        CloudPlugin.log(e);
                    }
                    if (content != null) {
                        cache.write(this.serializer.id(), content);
                    }
                }
                if (!this.backgroundFetcherActivated) {
                    this.backgroundFetcherActivated = true;
                    if (this.backgroundFetcher != null) {
                        this.backgroundFetcher.activate(this);
                    }
                }
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected abstract T read() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        RemoteData remoteData = this;
        synchronized (remoteData) {
            this.assertNotDisposed();
            if (this.listeners == null) {
                this.listeners = new ListenerContext();
            }
            this.listeners.attach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        RemoteData remoteData = this;
        synchronized (remoteData) {
            if (this.listeners != null) {
                this.listeners.detach(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void broadcast(Event event) {
        ListenerContext listeners;
        if (event == null) {
            throw new IllegalArgumentException();
        }
        RemoteData remoteData = this;
        synchronized (remoteData) {
            listeners = this.listeners;
        }
        if (listeners != null) {
            listeners.broadcast((org.eclipse.sapphire.Event)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disposed() {
        RemoteData remoteData = this;
        synchronized (remoteData) {
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        boolean broadcast = false;
        RemoteData remoteData = this;
        synchronized (remoteData) {
            if (!this.disposed) {
                this.disposed = true;
                this.label = null;
                this.content = null;
                this.listeners = null;
                if (this.backgroundFetcher != null) {
                    this.backgroundFetcher.dispose();
                }
                broadcast = true;
            }
        }
        if (broadcast) {
            this.broadcast(new DisposeEvent(this));
        }
    }

    protected final void assertNotDisposed() {
        if (this.disposed()) {
            throw new IllegalStateException(alreadyDisposedMessage.format(new Object[]{this.getClass().getSimpleName()}));
        }
    }

    public static final class BackgroundFetcher {
        private static ScheduledThreadPoolExecutor backgroundFetchExecutor;
        private final int intervalLength;
        private final TimeUnit intervalTimeUnit;
        private ScheduledFuture<?> backgroundFetchFuture;

        public BackgroundFetcher(int intervalLength, TimeUnit intervalTimeUnit) {
            this.intervalLength = intervalLength;
            this.intervalTimeUnit = intervalTimeUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate(final RemoteData<?> rd) {
            Class<BackgroundFetcher> clazz = BackgroundFetcher.class;
            synchronized (BackgroundFetcher.class) {
                if (backgroundFetchExecutor == null) {
                    backgroundFetchExecutor = new ScheduledThreadPoolExecutor(2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.backgroundFetchFuture = backgroundFetchExecutor.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        rd.fetch();
                    }
                }, this.intervalLength, this.intervalLength, this.intervalTimeUnit);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            BackgroundFetcher backgroundFetcher = this;
            synchronized (backgroundFetcher) {
                if (this.backgroundFetchFuture != null) {
                    this.backgroundFetchFuture.cancel(true);
                    this.backgroundFetchFuture = null;
                }
            }
        }
    }

    private static final class Cache {
        private final Map<String, Entry> entries;
        private final File location;

        public Cache(Class<?> type) {
            block16: {
                this.entries = new HashMap<String, Entry>();
                this.location = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(".metadata").append(".plugins").append("oracle.eclipse.tools.cloud").append("RemoteData").append(type.getName()).toFile();
                File f = new File(this.location, "Inventory");
                if (f.exists()) {
                    FileInputStream fin = null;
                    try {
                        try {
                            fin = new FileInputStream(f);
                            DataInputStream din = new DataInputStream(new BufferedInputStream(fin));
                            int i = 0;
                            int n = din.readInt();
                            while (i < n) {
                                byte[] keyEncryptedBytes = new byte[din.readInt()];
                                din.readFully(keyEncryptedBytes);
                                String key = Cache.decryptAsString(keyEncryptedBytes);
                                Entry entry = new Entry();
                                entry.accessed = din.readLong();
                                entry.file = din.readInt();
                                this.entries.put(key, entry);
                                ++i;
                            }
                        }
                        catch (IOException iOException) {
                            if (fin != null) {
                                try {
                                    fin.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public synchronized byte[] read(String key) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            Entry entry = this.entries.get(key);
            byte[] content = null;
            if (entry != null) {
                block25: {
                    entry.accessed = System.currentTimeMillis();
                    File f = new File(this.location, String.valueOf(entry.file));
                    if (f.exists()) {
                        FileInputStream in = null;
                        try {
                            try {
                                in = new FileInputStream(f);
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                try {
                                    byte[] buffer = new byte[4096];
                                    int count = in.read(buffer);
                                    while (count != -1) {
                                        out.write(buffer, 0, count);
                                        count = in.read(buffer);
                                    }
                                    content = Cache.decrypt(out.toByteArray());
                                }
                                catch (Throwable throwable) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                    throw throwable;
                                }
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            catch (IOException iOException) {
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (content == null) {
                    this.entries.remove(key);
                }
            }
            this.prune();
            return content;
        }

        public synchronized void write(String key, byte[] content) {
            block19: {
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                if (content == null) {
                    throw new IllegalArgumentException();
                }
                Entry entry = this.entries.get(key);
                if (entry == null) {
                    entry = new Entry();
                    int file = 0;
                    for (Entry x : this.entries.values()) {
                        file = Math.max(file, x.file);
                    }
                    entry.file = file + 1;
                    this.entries.put(key, entry);
                }
                entry.accessed = System.currentTimeMillis();
                if (!this.location.exists() && !this.location.mkdirs()) {
                    throw new IllegalStateException();
                }
                File f = new File(this.location, String.valueOf(entry.file));
                FileOutputStream fout = null;
                try {
                    try {
                        fout = new FileOutputStream(f);
                        fout.write(Cache.encrypt(content));
                    }
                    catch (IOException e) {
                        CloudPlugin.log(e);
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.prune();
        }

        private void prune() {
            block17: {
                long now = System.currentTimeMillis();
                Iterator<Entry> itr = this.entries.values().iterator();
                while (itr.hasNext()) {
                    Entry entry = itr.next();
                    if (now - entry.accessed <= 604800000L) continue;
                    itr.remove();
                    if (new File(this.location, String.valueOf(entry.file)).delete()) continue;
                    throw new IllegalStateException();
                }
                FileOutputStream fout = null;
                try {
                    try {
                        if (!this.location.exists() && !this.location.mkdirs()) {
                            throw new IllegalStateException();
                        }
                        fout = new FileOutputStream(new File(this.location, "Inventory"));
                        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(fout));
                        dout.writeInt(this.entries.size());
                        for (Map.Entry<String, Entry> x : this.entries.entrySet()) {
                            byte[] key = Cache.encrypt(x.getKey());
                            Entry entry = x.getValue();
                            dout.writeInt(key.length);
                            dout.write(key);
                            dout.writeLong(entry.accessed);
                            dout.writeInt(entry.file);
                        }
                        dout.flush();
                    }
                    catch (IOException e) {
                        CloudPlugin.log(e);
                        if (fout != null) {
                            try {
                                fout.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (fout != null) {
                        try {
                            fout.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        private static byte[] encrypt(byte[] input) {
            if (input == null) {
                throw new IllegalArgumentException();
            }
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, cacheEncryptionKey);
                return cipher.doFinal(input);
            }
            catch (Exception e) {
                CloudPlugin.log(e);
                return null;
            }
        }

        private static byte[] encrypt(String input) {
            if (input == null) {
                throw new IllegalArgumentException();
            }
            try {
                return Cache.encrypt(input.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                CloudPlugin.log(e);
                return null;
            }
        }

        private static byte[] decrypt(byte[] input) {
            if (input == null) {
                throw new IllegalArgumentException();
            }
            try {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, cacheEncryptionKey);
                return cipher.doFinal(input);
            }
            catch (Exception e) {
                CloudPlugin.log(e);
                return null;
            }
        }

        private static String decryptAsString(byte[] input) {
            if (input == null) {
                throw new IllegalArgumentException();
            }
            try {
                return new String(Cache.decrypt(input), "UTF-8");
            }
            catch (Exception e) {
                CloudPlugin.log(e);
                return null;
            }
        }

        private static final class Entry {
            public long accessed;
            public int file;

            private Entry() {
            }
        }
    }

    public static final class ContentEvent
    extends Event {
        public ContentEvent(RemoteData<?> data) {
            super(data);
        }
    }

    public static final class DisposeEvent
    extends Event {
        public DisposeEvent(RemoteData<?> data) {
            super(data);
        }
    }

    public static abstract class Event
    extends org.eclipse.sapphire.Event {
        private final RemoteData<?> data;

        public Event(RemoteData<?> data) {
            this.data = data;
        }

        public RemoteData<?> data() {
            return this.data;
        }
    }

    public static final class FetchFailedEvent
    extends Event {
        public FetchFailedEvent(RemoteData<?> data) {
            super(data);
        }
    }

    public static abstract class Serializer<T> {
        private RemoteData<T> context;

        protected final void init(RemoteData<T> context) {
            this.context = context;
        }

        protected final RemoteData<T> context() {
            return this.context;
        }

        public abstract String id();

        public abstract T read(InputStream var1) throws Exception;

        public abstract void write(T var1, OutputStream var2) throws Exception;
    }
}

